/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec.idct;

import java.util.logging.Level;
import java.util.logging.Logger;
import jpsxdec.psxvideo.mdec.idct.IDCT_double;

public class StephensIDCT
implements IDCT_double {
    private static final Logger LOG = Logger.getLogger(StephensIDCT.class.getName());
    private static final int N = 8;
    private double[][] c = new double[8][8];
    private double[][] cT = new double[8][8];
    final double[] temp = new double[64];

    public StephensIDCT() {
        this.initMatrix();
    }

    private void initMatrix() {
        int j;
        for (j = 0; j < 8; ++j) {
            double nn = 8.0;
            this.c[0][j] = 1.0 / Math.sqrt(nn);
            this.cT[j][0] = this.c[0][j];
        }
        for (int i = 1; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                double jj = j;
                double ii = i;
                this.c[i][j] = Math.sqrt(0.25) * Math.cos((2.0 * jj + 1.0) * ii * Math.PI / 16.0);
                this.cT[j][i] = this.c[i][j];
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < 8; ++x) {
                sb.setLength(0);
                for (int y = 0; y < 8; ++y) {
                    sb.append(this.c[x][y]);
                    sb.append(' ');
                }
                LOG.finest(sb.toString());
            }
        }
    }

    @Override
    public void IDCT(double[] input, int iOutputOffset, double[] out) {
        int k;
        int j;
        int i;
        assert (input.length == 64);
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                this.temp[i + j * 8] = 0.0;
                for (k = 0; k < 8; ++k) {
                    int n = i + j * 8;
                    this.temp[n] = this.temp[n] + input[i + k * 8] * this.c[k][j];
                }
            }
        }
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                double temp1 = 0.0;
                for (k = 0; k < 8; ++k) {
                    temp1 += this.cT[i][k] * this.temp[k + j * 8];
                }
                out[iOutputOffset + i + j * 8] = temp1;
            }
        }
    }

    @Override
    public void IDCT_1NonZero(double[] adblIdctMatrix, int iNonZeroPos, int iOutputOffset, double[] adblOutput) {
        this.IDCT(adblIdctMatrix, iOutputOffset, adblOutput);
    }

    public void forwardDCT(double[] matrix) {
        int k;
        int j;
        int i;
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                this.temp[i + j * 8] = 0.0;
                for (k = 0; k < 8; ++k) {
                    int n = i + j * 8;
                    this.temp[n] = this.temp[n] + matrix[i + k * 8] * this.cT[k][j];
                }
            }
        }
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                double temp1 = 0.0;
                for (k = 0; k < 8; ++k) {
                    temp1 += this.c[i][k] * this.temp[k + j * 8];
                }
                matrix[i + j * 8] = temp1;
            }
        }
    }

    public static void main(String[] args) {
        double[] matrix_for_idct;
        StephensIDCT idct = new StephensIDCT();
        for (int y = 0; y < 8; ++y) {
            System.out.print("[ ");
            for (int x = 0; x < 8; ++x) {
                System.out.format("%1.3f ", idct.c[y][x]);
            }
            System.out.println(" ]");
        }
        System.out.println();
        System.out.println();
        double[] matrix_for_dct = new double[]{-3.823, -3.823, -3.823, -3.823, -3.865, -3.823, -3.74, -3.698, -4.742, -4.742, -4.742, -4.742, -4.742, -4.742, -4.576, -4.742, -6.58, -6.58, -6.58, -6.58, -6.58, -6.454, -6.204, -6.454, -8.752, -8.752, -8.752, -8.752, -8.752, -8.751, -8.751, -8.917, -11.424, -11.424, -11.341, -11.174, -11.216, -11.424, -11.133, -11.424, -13.596, -13.43, -13.679, -13.596, -13.388, -13.596, -13.513, -13.637, -15.266, -15.183, -15.308, -15.309, -15.266, -15.392, -15.517, -15.267, -16.31, -16.268, -16.019, -16.352, -16.228, -16.103, -16.145, -16.228};
        double[] matrix = matrix_for_idct = new double[]{-112.0, 60.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -54.0, 18.0, 8.25, 0.0, 0.0, 0.0, 0.0, 0.0, -14.25, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.75, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        idct.IDCT(matrix, 0, matrix);
        for (int y = 0; y < 8; ++y) {
            System.out.print("[ ");
            for (int x = 0; x < 8; ++x) {
                System.out.format("%1.3f ", matrix[x + y * 8]);
            }
            System.out.println(" ]");
        }
    }
}

