/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec.idct;

import jpsxdec.psxvideo.mdec.idct.IDCT_int;
import jpsxdec.util.Maths;

public class PsxMdecIDCT_int
implements IDCT_int {
    private static final int[] PSX_DEFAULT_COSINE_MATRIX = new int[]{23170, 23170, 23170, 23170, 23170, 23170, 23170, 23170, 32138, 27245, 18204, 6392, -6393, -18205, -27246, -32139, 30273, 12539, -12540, -30274, -30274, -12540, 12539, 30273, 27245, -6393, -32139, -18205, 18204, 32138, 6392, -27246, 23170, -23171, -23171, 23170, 23170, -23171, -23171, 23170, 18204, -32139, 6392, 27245, -27246, -6393, 32138, -18205, 12539, -30274, 30273, -12540, -12540, 30273, -30274, 12539, 6392, -18205, 27245, -32139, 32138, -27246, 18204, -6393};
    private final long[] _aTemp = new long[64];

    @Override
    public void IDCT(int[] idctMatrix, int iOutputOffset, int[] output) {
        int i;
        long tempSum;
        int y;
        int x;
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0L;
                for (i = 0; i < 8; ++i) {
                    tempSum += (long)(PSX_DEFAULT_COSINE_MATRIX[i * 8 + y] * idctMatrix[x + i * 8]);
                }
                this._aTemp[x + y * 8] = tempSum;
            }
        }
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0L;
                for (i = 0; i < 8; ++i) {
                    tempSum += this._aTemp[i + y * 8] * (long)PSX_DEFAULT_COSINE_MATRIX[x + i * 8];
                }
                output[iOutputOffset + x + y * 8] = (int)Maths.shrRound(tempSum, 32);
            }
        }
    }

    public void DCT(int[] idctMatrix, int iOutputOffset, int[] output) {
        int i;
        long tempSum;
        int y;
        int x;
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0L;
                for (i = 0; i < 8; ++i) {
                    tempSum += (long)(idctMatrix[x + i * 8] * PSX_DEFAULT_COSINE_MATRIX[i + y * 8]);
                }
                this._aTemp[x + y * 8] = tempSum >> 16;
            }
        }
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0L;
                for (i = 0; i < 8; ++i) {
                    tempSum += (long)PSX_DEFAULT_COSINE_MATRIX[x + i * 8] * this._aTemp[i * 8 + y];
                }
                output[iOutputOffset + x + y * 8] = (int)(tempSum >> 16);
            }
        }
    }

    @Override
    public void IDCT_1NonZero(int[] idctMatrix, int iNonZeroPos, int iOutputOffset, int[] output) {
        this.IDCT(idctMatrix, iOutputOffset, output);
    }

    public static void main(String[] args) {
        int[] matrix = new int[]{-112, 60, 0, 0, 0, 0, 0, 0, -54, 18, 8, 0, 0, 0, 0, 0, -14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        matrix = new int[]{-72, -36, 0, 16, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PsxMdecIDCT_int idct = new PsxMdecIDCT_int();
        idct.IDCT(matrix, 0, matrix);
        for (int y = 0; y < 8; ++y) {
            System.out.print("[ ");
            for (int x = 0; x < 8; ++x) {
                System.out.format("%d ", matrix[x + y * 8]);
            }
            System.out.println(" ]");
        }
    }
}

