/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec.idct;

import jpsxdec.psxvideo.mdec.idct.IDCT_double;

public class PsxMdecIDCT_double
implements IDCT_double {
    private static final double F = 65536.0;
    private static final double[] PSX_DEFAULT_COSINE_MATRIX = new double[]{0.353546142578125, 0.353546142578125, 0.353546142578125, 0.353546142578125, 0.353546142578125, 0.353546142578125, 0.353546142578125, 0.353546142578125, 0.490386962890625, 0.4157257080078125, 0.27777099609375, 0.0975341796875, -0.0975494384765625, -0.2777862548828125, -0.415740966796875, -0.4904022216796875, 0.4619293212890625, 0.1913299560546875, -0.19134521484375, -0.461944580078125, -0.461944580078125, -0.19134521484375, 0.1913299560546875, 0.4619293212890625, 0.4157257080078125, -0.0975494384765625, -0.4904022216796875, -0.2777862548828125, 0.27777099609375, 0.490386962890625, 0.0975341796875, -0.415740966796875, 0.353546142578125, -0.3535614013671875, -0.3535614013671875, 0.353546142578125, 0.353546142578125, -0.3535614013671875, -0.3535614013671875, 0.353546142578125, 0.27777099609375, -0.4904022216796875, 0.0975341796875, 0.4157257080078125, -0.415740966796875, -0.0975494384765625, 0.490386962890625, -0.2777862548828125, 0.1913299560546875, -0.461944580078125, 0.4619293212890625, -0.19134521484375, -0.19134521484375, 0.4619293212890625, -0.461944580078125, 0.1913299560546875, 0.0975341796875, -0.2777862548828125, 0.4157257080078125, -0.4904022216796875, 0.490386962890625, -0.415740966796875, 0.27777099609375, -0.0975494384765625};
    private final double[] _aTemp = new double[64];

    @Override
    public void IDCT(double[] idctMatrix, int iOutputOffset, double[] output) {
        int i;
        double tempSum;
        int y;
        int x;
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0.0;
                for (i = 0; i < 8; ++i) {
                    tempSum += idctMatrix[x + i * 8] * PSX_DEFAULT_COSINE_MATRIX[i * 8 + y];
                }
                this._aTemp[x + y * 8] = tempSum;
            }
        }
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0.0;
                for (i = 0; i < 8; ++i) {
                    tempSum += PSX_DEFAULT_COSINE_MATRIX[x + i * 8] * this._aTemp[i + y * 8];
                }
                output[iOutputOffset + x + y * 8] = tempSum;
            }
        }
    }

    public void DCT(double[] idctMatrix, int iOutputOffset, double[] output) {
        int i;
        double tempSum;
        int y;
        int x;
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0.0;
                for (i = 0; i < 8; ++i) {
                    tempSum += idctMatrix[x + i * 8] * PSX_DEFAULT_COSINE_MATRIX[i + y * 8];
                }
                this._aTemp[x + y * 8] = tempSum;
            }
        }
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                tempSum = 0.0;
                for (i = 0; i < 8; ++i) {
                    tempSum += PSX_DEFAULT_COSINE_MATRIX[x + i * 8] * this._aTemp[i * 8 + y];
                }
                output[iOutputOffset + x + y * 8] = tempSum;
            }
        }
    }

    @Override
    public void IDCT_1NonZero(double[] idctMatrix, int iNonZeroPos, int iOutputOffset, double[] output) {
        this.IDCT(idctMatrix, iOutputOffset, output);
    }
}

