/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;

public class ParsedMdecImage {
    private static final Logger LOG = Logger.getLogger(ParsedMdecImage.class.getName());
    @Nonnull
    private final MacroBlock[] _aoMacroBlocks;
    private final int _iWidth;
    private final int _iHeight;

    public ParsedMdecImage(@Nonnull MdecInputStream mdecIn, int iWidth, int iHeight) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        int iMacroBlockCount = Calc.macroblocks(iWidth, iHeight);
        this._aoMacroBlocks = new MacroBlock[iMacroBlockCount];
        this.readFrom(mdecIn);
    }

    private void readFrom(@Nonnull MdecInputStream mdecIn) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        int iMacBlockWidth = Calc.macroblockDim(this._iWidth);
        int iMacBlockHeight = Calc.macroblockDim(this._iHeight);
        int iMacroBlockIndex = 0;
        for (int iMacBlkX = 0; iMacBlkX < iMacBlockWidth; ++iMacBlkX) {
            for (int iMacBlkY = 0; iMacBlkY < iMacBlockHeight; ++iMacBlkY) {
                LOG.log(Level.FINE, "Reading macroblock {0,number,#}", iMacroBlockIndex);
                this._aoMacroBlocks[iMacroBlockIndex] = new MacroBlock(mdecIn);
                ++iMacroBlockIndex;
            }
        }
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public int getMacroBlockCount() {
        return this._aoMacroBlocks.length;
    }

    @Nonnull
    public MdecInputStream getStream() {
        return new MdecReader(0);
    }

    @Nonnull
    public MdecInputStream getStream(int iMacBlkX, int iMacBlkY) {
        int iMacBlkHeight = Calc.macroblockDim(this._iHeight);
        return new MdecReader(iMacBlkY + iMacBlkX * iMacBlkHeight);
    }

    public ArrayList<MdecCode> getMacroBlockCodes(int iMacBlkX, int iMacBlkY) {
        int iMacBlkHeight = Calc.macroblockDim(this._iHeight);
        return this._aoMacroBlocks[iMacBlkY + iMacBlkX * iMacBlkHeight].getCodes();
    }

    @Nonnull
    public ArrayList<MdecCode> getBlockCodes(int iMacBlkX, int iMacBlkY, int iBlock) {
        int iMacBlkHeight = Calc.macroblockDim(this._iHeight);
        return this._aoMacroBlocks[iMacBlkY + iMacBlkX * iMacBlkHeight].getBlock(iBlock).getCodes();
    }

    public int getMdecCodeCount() {
        int iMdecCodeCount = 0;
        for (MacroBlock mb : this._aoMacroBlocks) {
            iMdecCodeCount += mb.getMdecCodeCount();
        }
        return iMdecCodeCount;
    }

    @Nonnull
    public String getBlockInfo(int iMacBlkX, int iMacBlkY, int iBlock) {
        int iMacBlkHeight = Calc.macroblockDim(this._iHeight);
        return this._aoMacroBlocks[iMacBlkY + iMacBlkX * iMacBlkHeight].getBlock(iBlock).toString();
    }

    @Nonnull
    public int[] getMacroBlockQscales(int iMacBlkX, int iMacBlkY) {
        int[] aiQscales = new int[6];
        int iMacBlkHeight = Calc.macroblockDim(this._iHeight);
        MacroBlock mb = this._aoMacroBlocks[iMacBlkY + iMacBlkX * iMacBlkHeight];
        for (int i = 0; i < aiQscales.length; ++i) {
            aiQscales[i] = mb.getBlock(i).getQscale();
        }
        return aiQscales;
    }

    public void drawMacroBlocks(@Nonnull PrintStream ps) {
        int iMbWidth = Calc.macroblockDim(this.getWidth());
        int iMbHeight = Calc.macroblockDim(this.getHeight());
        for (int iMbY = 0; iMbY < iMbHeight; ++iMbY) {
            for (int iMbX = 0; iMbX < iMbWidth; ++iMbX) {
                ps.println("    " + iMbX + ", " + iMbY);
                for (int iBlk = 0; iBlk < 6; ++iBlk) {
                    ps.println("      " + this.getBlockInfo(iMbX, iMbY, iBlk));
                }
            }
        }
    }

    private class MdecReader
    implements MdecInputStream {
        private int __iCurrentMacroBlock;
        private int __iCurrentBlock = 0;
        private int __iCurrentMdecCode = 0;

        private MdecReader(int iStartMacroBlock) {
            this.__iCurrentMacroBlock = iStartMacroBlock;
        }

        @Override
        public boolean readMdecCode(@Nonnull MdecCode code) throws MdecException.EndOfStream {
            MacroBlock currentMacBlk;
            try {
                currentMacBlk = ParsedMdecImage.this._aoMacroBlocks[this.__iCurrentMacroBlock];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new MdecException.EndOfStream(MdecException.inBlockOfBlocks(this.__iCurrentBlock, ParsedMdecImage.this._aoMacroBlocks.length), ex);
            }
            Block currentBlk = currentMacBlk.getBlock(this.__iCurrentBlock);
            MdecCode c = currentBlk.getMdecCode(this.__iCurrentMdecCode);
            code.setFrom(c);
            ++this.__iCurrentMdecCode;
            boolean eob = false;
            if (this.__iCurrentMdecCode == currentBlk.getMdecCodeCount()) {
                this.__iCurrentMdecCode = 0;
                ++this.__iCurrentBlock;
                eob = true;
                if (this.__iCurrentBlock == 6) {
                    this.__iCurrentBlock = 0;
                    ++this.__iCurrentMacroBlock;
                }
            }
            return eob;
        }
    }

    private static class Block {
        @Nonnull
        private final MdecBlock _block;
        @Nonnull
        private final MdecCode[] _aoCodes;

        public Block(@Nonnull MdecBlock block, @Nonnull MdecInputStream mdecIn) throws MdecException.EndOfStream, MdecException.ReadCorruption {
            this._block = block;
            ArrayList<MdecCode> codes = new ArrayList<MdecCode>();
            MdecCode code = new MdecCode();
            mdecIn.readMdecCode(code);
            codes.add(code);
            while (!mdecIn.readMdecCode(code = new MdecCode())) {
                codes.add(code);
            }
            codes.add(code);
            this._aoCodes = codes.toArray(new MdecCode[codes.size()]);
        }

        @Nonnull
        public MdecCode getMdecCode(int i) {
            return this._aoCodes[i];
        }

        public int getMdecCodeCount() {
            return this._aoCodes.length;
        }

        public int getQscale() {
            return this._aoCodes[0].getTop6Bits();
        }

        @Nonnull
        public ArrayList<MdecCode> getCodes() {
            ArrayList<MdecCode> c = new ArrayList<MdecCode>(this._aoCodes.length);
            Collections.addAll(c, this._aoCodes);
            return c;
        }

        public String toString() {
            return this._block.name() + " Q:" + this.getQscale();
        }
    }

    private static class MacroBlock
    implements Iterable<Block> {
        public final Block[] _aoBlocks = new Block[MdecBlock.count()];

        public MacroBlock(@Nonnull MdecInputStream mdecIn) throws MdecException.EndOfStream, MdecException.ReadCorruption {
            for (MdecBlock block : MdecBlock.list()) {
                this._aoBlocks[block.ordinal()] = new Block(block, mdecIn);
            }
        }

        @Nonnull
        public Block getBlock(int iBlk) {
            return this._aoBlocks[iBlk];
        }

        public int getMdecCodeCount() {
            int iCount = 0;
            for (Block block : this._aoBlocks) {
                iCount += block.getMdecCodeCount();
            }
            return iCount;
        }

        public ArrayList<MdecCode> getCodes() {
            ArrayList<MdecCode> c = new ArrayList<MdecCode>();
            for (Block b : this) {
                Collections.addAll(c, b._aoCodes);
            }
            return c;
        }

        @Override
        @Nonnull
        public Iterator<Block> iterator() {
            return new Iterator<Block>(){
                private int _iBlk = 0;

                @Override
                public boolean hasNext() {
                    return this._iBlk < MdecBlock.count();
                }

                @Override
                @Nonnull
                public Block next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return MacroBlock.this.getBlock(this._iBlk++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Can't remove blocks.");
                }
            };
        }
    }
}

