/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.mdec.Ac0Checker;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.IO;

public class MdecInputStreamReader
implements MdecInputStream {
    private static final Logger LOG = Logger.getLogger(MdecInputStreamReader.class.getName());
    @Nonnull
    private final ByteArrayInputStream _in;

    public MdecInputStreamReader(@Nonnull File file) throws FileNotFoundException, IOException {
        this(IO.readFile(file));
    }

    public MdecInputStreamReader(@Nonnull InputStream is) throws IOException {
        this(IO.readEntireStream(is));
    }

    public MdecInputStreamReader(@Nonnull byte[] abMdecWords) {
        this._in = new ByteArrayInputStream(abMdecWords);
    }

    @Override
    public boolean readMdecCode(@Nonnull MdecCode code) throws MdecException.EndOfStream {
        try {
            code.set(IO.readSInt16LE(this._in));
            return code.isEOD();
        }
        catch (EOFException ex) {
            throw new MdecException.EndOfStream(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("BAOS should not throw a general IOException", ex);
        }
    }

    public void reset() {
        this._in.reset();
    }

    public static void writeMdecDims(@Nonnull MdecInputStream mdecIn, @Nonnull OutputStream streamOut, int iWidth, int iHeight) throws MdecException.EndOfStream, MdecException.ReadCorruption, IOException {
        int iBlockCount = Calc.blocks(iWidth, iHeight);
        MdecInputStreamReader.writeMdecBlocks(mdecIn, streamOut, iBlockCount);
    }

    public static void writeMdecBlocks(@Nonnull MdecInputStream sourceMdecIn, @Nonnull OutputStream streamOut, int iBlockCount) throws MdecException.EndOfStream, MdecException.ReadCorruption, IOException {
        Ac0Checker mdecIn = Ac0Checker.wrapWithChecker(sourceMdecIn, false);
        MdecCode code = new MdecCode();
        int iBlock = 0;
        while (iBlock < iBlockCount) {
            boolean blnIsEod = mdecIn.readMdecCode(code);
            if (blnIsEod) {
                LOG.warning("Qscale+DC code returns as EOD!");
            }
            if (code.isEOD()) {
                LOG.warning("Qscale+DC = EOD!");
            }
            IO.writeInt16LE(streamOut, code.toMdecWord());
            if (!blnIsEod) {
                int iCurrentBlockVectorPosition = 0;
                while (!mdecIn.readMdecCode(code)) {
                    if (code.isEOD()) {
                        LOG.warning("EOD code found in at non-EOD position!");
                    }
                    if ((iCurrentBlockVectorPosition += code.getTop6Bits() + 1) >= 64) {
                        LOG.warning("Run length out of bounds!");
                    }
                    IO.writeInt16LE(streamOut, code.toMdecWord());
                }
            }
            ++iBlock;
            if (!code.isEOD()) {
                LOG.warning("non-EOD code found in at EOD position!");
            }
            IO.writeInt16LE(streamOut, code.toMdecWord());
        }
        mdecIn.logIfAny0AcCoefficient();
    }
}

