/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import java.util.Arrays;
import javax.annotation.Nonnull;
import jpsxdec.formats.RGB;
import jpsxdec.psxvideo.PsxYCbCr_int;
import jpsxdec.psxvideo.mdec.Ac0Checker;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecDecoder;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.idct.IDCT_int;

public class MdecDecoder_int
extends MdecDecoder {
    private final IDCT_int _idct;
    private final int[] _aiCrBuffer;
    private final int[] _aiCbBuffer;
    private final int[] _aiLumaBuffer;
    protected final int[] _CurrentBlock = new int[64];

    public MdecDecoder_int(@Nonnull IDCT_int idct, int iWidth, int iHeight) {
        super(iWidth, iHeight);
        this._idct = idct;
        this._aiCrBuffer = new int[this.CW * this.CH];
        this._aiCbBuffer = new int[this._aiCrBuffer.length];
        this._aiLumaBuffer = new int[this.W * this.H];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(@Nonnull MdecInputStream sourceMdecInStream) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        Ac0Checker mdecInStream = Ac0Checker.wrapWithChecker(sourceMdecInStream, false);
        MdecContext context = new MdecContext(this._iMacBlockHeight);
        try {
            while (context.getTotalMacroBlocksRead() < this._iTotalMacBlocks) {
                assert (!DEBUG || MdecDecoder_int.debugPrintln(String.format("############### Decoding macro block %d %s ###############", context.getTotalMacroBlocksRead(), context.getMacroBlockPixel())));
                for (int iBlock = 0; iBlock < MdecBlock.count(); ++iBlock) {
                    int iCurrentBlockLastNonZeroPosition;
                    int iCurrentBlockNonZeroCount;
                    assert (!DEBUG || MdecDecoder_int.debugPrintln("=========== Decoding block " + (Object)((Object)context.getCurrentBlock()) + " ==========="));
                    Arrays.fill(this._CurrentBlock, 0);
                    mdecInStream.readMdecCode(this._code);
                    assert (!DEBUG || MdecDecoder_int.debugPrintln("Qscale & DC " + this._code));
                    if (this._code.getBottom10Bits() != 0) {
                        this._CurrentBlock[0] = this._code.getBottom10Bits() * this._aiQuantizationTable[0];
                        iCurrentBlockNonZeroCount = 1;
                        iCurrentBlockLastNonZeroPosition = 0;
                    } else {
                        iCurrentBlockNonZeroCount = 0;
                        iCurrentBlockLastNonZeroPosition = -1;
                    }
                    assert (!DEBUG || this.setPrequantValue(0, this._code.getBottom10Bits()));
                    int iCurrentBlockQscale = this._code.getTop6Bits();
                    int iCurrentBlockVectorPosition = 0;
                    while (!mdecInStream.readMdecCode(this._code)) {
                        int iRevZigZagMatrixPos;
                        assert (!DEBUG || MdecDecoder_int.debugPrintln(this._code.toString()));
                        iCurrentBlockVectorPosition += this._code.getTop6Bits() + 1;
                        try {
                            iRevZigZagMatrixPos = MdecInputStream.REVERSE_ZIG_ZAG_LOOKUP_LIST[iCurrentBlockVectorPosition];
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            MdecContext.MacroBlockPixel macBlkXY = context.getMacroBlockPixel();
                            throw new MdecException.ReadCorruption(MdecException.RLC_OOB_IN_BLOCK_NAME(iCurrentBlockVectorPosition, context.getTotalMacroBlocksRead(), macBlkXY.x, macBlkXY.y, context.getCurrentBlock().ordinal(), context.getCurrentBlock().name()), ex);
                        }
                        if (this._code.getBottom10Bits() != 0) {
                            assert (!DEBUG || this.setPrequantValue(iRevZigZagMatrixPos, this._code.getBottom10Bits()));
                            this._CurrentBlock[iRevZigZagMatrixPos] = this._code.getBottom10Bits() * this._aiQuantizationTable[iRevZigZagMatrixPos] * iCurrentBlockQscale + 4 >> 3;
                            ++iCurrentBlockNonZeroCount;
                            iCurrentBlockLastNonZeroPosition = iRevZigZagMatrixPos;
                        }
                        context.nextCode();
                    }
                    assert (!DEBUG || MdecDecoder_int.debugPrintln(this._code.toString()));
                    this.writeEndOfBlock(context.getTotalMacroBlocksRead(), context.getCurrentBlock().ordinal(), iCurrentBlockNonZeroCount, iCurrentBlockLastNonZeroPosition);
                    context.nextCodeEndBlock();
                }
            }
        }
        finally {
            while (context.getTotalMacroBlocksRead() < this._iTotalMacBlocks) {
                this.writeEndOfBlock(context.getTotalMacroBlocksRead(), context.getCurrentBlock().ordinal(), 0, 0);
                context.nextCodeEndBlock();
            }
            mdecInStream.logIfAny0AcCoefficient();
        }
    }

    private boolean debugPrintBlock(@Nonnull String sMsg) {
        System.out.println(sMsg);
        for (int i = 0; i < 8; ++i) {
            System.out.print("[ ");
            for (int j = 0; j < 8; ++j) {
                System.out.format("%d, ", this._CurrentBlock[j + i * 8]);
            }
            System.out.print("]");
            System.out.println();
        }
        return true;
    }

    private void writeEndOfBlock(int iMacroBlock, int iBlock, int iNonZeroCount, int iNonZeroPos) {
        int iOutWidth;
        int iOutOffset;
        int[] outputBuffer;
        assert (!DEBUG || this.debugPrintPrequantBlock());
        assert (!DEBUG || this.debugPrintBlock("Pre-IDCT block"));
        switch (iBlock) {
            case 0: {
                outputBuffer = this._aiCrBuffer;
                iOutOffset = this._aiChromaMacBlkOfsLookup[iMacroBlock];
                iOutWidth = this.CW;
                break;
            }
            case 1: {
                outputBuffer = this._aiCbBuffer;
                iOutOffset = this._aiChromaMacBlkOfsLookup[iMacroBlock];
                iOutWidth = this.CW;
                break;
            }
            default: {
                outputBuffer = this._aiLumaBuffer;
                iOutOffset = this._aiLumaBlkOfsLookup[iMacroBlock * 4 + iBlock - 2];
                iOutWidth = this.W;
            }
        }
        if (iNonZeroCount == 0) {
            int i = 0;
            while (i < 8) {
                Arrays.fill(outputBuffer, iOutOffset, iOutOffset + 8, 0);
                ++i;
                iOutOffset += iOutWidth;
            }
        } else {
            if (iNonZeroCount == 1) {
                this._idct.IDCT_1NonZero(this._CurrentBlock, iNonZeroPos, 0, this._CurrentBlock);
            } else {
                this._idct.IDCT(this._CurrentBlock, 0, this._CurrentBlock);
            }
            int i = 0;
            int iSrcOfs = 0;
            while (i < 8) {
                System.arraycopy(this._CurrentBlock, iSrcOfs, outputBuffer, iOutOffset, 8);
                ++i;
                iSrcOfs += 8;
                iOutOffset += iOutWidth;
            }
        }
        assert (!DEBUG || this.debugPrintBlock("Post-IDCT block"));
    }

    @Override
    public void readDecodedRgb(int iDestWidth, int iDestHeight, @Nonnull int[] aiDest, int iOutStart, int iOutStride) {
        int iDestOfs1;
        int iSrcChromaOfs;
        int iSrcLumaOfs2;
        int iSrcLumaOfs1;
        PsxYCbCr_int psxycc = new PsxYCbCr_int();
        RGB rgb1 = new RGB();
        RGB rgb2 = new RGB();
        RGB rgb3 = new RGB();
        RGB rgb4 = new RGB();
        int W_x2 = this.W * 2;
        int iOutStride_x2 = iOutStride * 2;
        int iDestWidthSub1 = iDestWidth - 1;
        int iDestHeightSub1 = iDestHeight - 1;
        int iLumaLineOfsStart = 0;
        int iChromaLineOfsStart = 0;
        int iDestLineOfsStart = iOutStart;
        int iY = 0;
        while (iY < iDestHeightSub1) {
            iSrcLumaOfs1 = iLumaLineOfsStart;
            iSrcLumaOfs2 = iLumaLineOfsStart + this.W;
            iSrcChromaOfs = iChromaLineOfsStart;
            iDestOfs1 = iDestLineOfsStart;
            int iDestOfs2 = iDestLineOfsStart + iOutStride;
            int iX = 0;
            while (iX < iDestWidthSub1) {
                psxycc.cr = this._aiCrBuffer[iSrcChromaOfs];
                psxycc.cb = this._aiCbBuffer[iSrcChromaOfs];
                psxycc.y1 = this._aiLumaBuffer[iSrcLumaOfs1++];
                psxycc.y2 = this._aiLumaBuffer[iSrcLumaOfs1++];
                psxycc.y3 = this._aiLumaBuffer[iSrcLumaOfs2++];
                psxycc.y4 = this._aiLumaBuffer[iSrcLumaOfs2++];
                psxycc.toRgb(rgb1, rgb2, rgb3, rgb4);
                aiDest[iDestOfs1++] = rgb1.toInt();
                aiDest[iDestOfs1++] = rgb2.toInt();
                aiDest[iDestOfs2++] = rgb3.toInt();
                aiDest[iDestOfs2++] = rgb4.toInt();
                iX += 2;
                ++iSrcChromaOfs;
            }
            if (iX < iDestWidth) {
                psxycc.cr = this._aiCrBuffer[iSrcChromaOfs];
                psxycc.cb = this._aiCbBuffer[iSrcChromaOfs];
                psxycc.y1 = this._aiLumaBuffer[iSrcLumaOfs1];
                psxycc.y2 = this._aiLumaBuffer[iSrcLumaOfs1];
                psxycc.y3 = this._aiLumaBuffer[iSrcLumaOfs2];
                psxycc.y4 = this._aiLumaBuffer[iSrcLumaOfs2];
                psxycc.toRgb(rgb1, rgb2, rgb3, rgb4);
                aiDest[iDestOfs1] = rgb1.toInt();
                aiDest[iDestOfs2] = rgb3.toInt();
            }
            iY += 2;
            iLumaLineOfsStart += W_x2;
            iChromaLineOfsStart += this.CW;
            iDestLineOfsStart += iOutStride_x2;
        }
        if (iY < iDestHeight) {
            iSrcLumaOfs1 = iLumaLineOfsStart;
            iSrcLumaOfs2 = iLumaLineOfsStart + this.W;
            iSrcChromaOfs = iChromaLineOfsStart;
            iDestOfs1 = iDestLineOfsStart;
            int iX = 0;
            while (iX < iDestWidthSub1) {
                psxycc.cr = this._aiCrBuffer[iSrcChromaOfs];
                psxycc.cb = this._aiCbBuffer[iSrcChromaOfs];
                psxycc.y1 = this._aiLumaBuffer[iSrcLumaOfs1++];
                psxycc.y2 = this._aiLumaBuffer[iSrcLumaOfs1++];
                psxycc.y3 = this._aiLumaBuffer[iSrcLumaOfs2++];
                psxycc.y4 = this._aiLumaBuffer[iSrcLumaOfs2++];
                psxycc.toRgb(rgb1, rgb2, rgb3, rgb4);
                aiDest[iDestOfs1++] = rgb1.toInt();
                aiDest[iDestOfs1++] = rgb2.toInt();
                iX += 2;
                ++iSrcChromaOfs;
            }
            if (iX < iDestWidth) {
                psxycc.cr = this._aiCrBuffer[iSrcChromaOfs];
                psxycc.cb = this._aiCbBuffer[iSrcChromaOfs];
                psxycc.y1 = this._aiLumaBuffer[iSrcLumaOfs1];
                psxycc.y2 = this._aiLumaBuffer[iSrcLumaOfs1];
                psxycc.y3 = this._aiLumaBuffer[iSrcLumaOfs2];
                psxycc.y4 = this._aiLumaBuffer[iSrcLumaOfs2];
                psxycc.toRgb(rgb1, rgb2, rgb3, rgb4);
                aiDest[iDestOfs1] = rgb1.toInt();
            }
        }
    }
}

