/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import com.mortennobel.imagescaling.ResampleOp;
import java.util.Arrays;
import javax.annotation.Nonnull;
import jpsxdec.formats.RGB;
import jpsxdec.formats.Rec601YCbCr;
import jpsxdec.formats.YCbCrImage;
import jpsxdec.psxvideo.PsxYCbCr;
import jpsxdec.psxvideo.mdec.Ac0Checker;
import jpsxdec.psxvideo.mdec.ChromaUpsample;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecDecoder;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.idct.IDCT_double;

public class MdecDecoder_double
extends MdecDecoder {
    @Nonnull
    private final IDCT_double _idct;
    @Nonnull
    private final double[] _adblDecodedCrBuffer;
    @Nonnull
    private final double[] _dblDecodedCbBuffer;
    @Nonnull
    private final double[] _adblDecodedLumaBuffer;
    private final double[] _CurrentBlock = new double[64];
    @Nonnull
    private final double[] _adblTempUpsampledCr;
    @Nonnull
    private final double[] _adblTempUpsampledCb;
    private final ResampleOp _resampler = new ResampleOp();
    @Nonnull
    private ChromaUpsample _upsampler = ChromaUpsample.Bicubic;
    static final boolean YUV_TESTS = false;

    public MdecDecoder_double(@Nonnull IDCT_double idct, int iWidth, int iHeight) {
        super(iWidth, iHeight);
        this._idct = idct;
        this._adblDecodedCrBuffer = new double[this.CW * this.CH];
        this._dblDecodedCbBuffer = new double[this._adblDecodedCrBuffer.length];
        this._adblDecodedLumaBuffer = new double[this.W * this.H];
        this._adblTempUpsampledCb = new double[this._adblDecodedLumaBuffer.length];
        this._adblTempUpsampledCr = new double[this._adblDecodedLumaBuffer.length];
        this._resampler.setNumberOfThreads(1);
    }

    public void setUpsampler(@Nonnull ChromaUpsample u) {
        this._upsampler = u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(@Nonnull MdecInputStream sourceMdecInStream) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        Ac0Checker mdecInStream = Ac0Checker.wrapWithChecker(sourceMdecInStream, false);
        MdecContext context = new MdecContext(this._iMacBlockHeight);
        try {
            while (context.getTotalMacroBlocksRead() < this._iTotalMacBlocks) {
                assert (!DEBUG || MdecDecoder_double.debugPrintln(String.format("############### Decoding macro block %d %s ###############", context.getTotalMacroBlocksRead(), context.getMacroBlockPixel())));
                for (int iBlock = 0; iBlock < MdecBlock.count(); ++iBlock) {
                    int iCurrentBlockLastNonZeroPosition;
                    int iCurrentBlockNonZeroCount;
                    assert (!DEBUG || MdecDecoder_double.debugPrintln("=========== Decoding block " + (Object)((Object)context.getCurrentBlock()) + " ==========="));
                    Arrays.fill(this._CurrentBlock, 0.0);
                    mdecInStream.readMdecCode(this._code);
                    assert (!DEBUG || MdecDecoder_double.debugPrintln("Qscale & DC " + this._code));
                    if (this._code.getBottom10Bits() != 0) {
                        this._CurrentBlock[0] = this._code.getBottom10Bits() * this._aiQuantizationTable[0];
                        iCurrentBlockNonZeroCount = 1;
                        iCurrentBlockLastNonZeroPosition = 0;
                    } else {
                        iCurrentBlockNonZeroCount = 0;
                        iCurrentBlockLastNonZeroPosition = -1;
                    }
                    assert (!DEBUG || this.setPrequantValue(0, this._code.getBottom10Bits()));
                    int iCurrentBlockQscale = this._code.getTop6Bits();
                    int iCurrentBlockVectorPosition = 0;
                    while (!mdecInStream.readMdecCode(this._code)) {
                        int iRevZigZagMatrixPos;
                        assert (!DEBUG || MdecDecoder_double.debugPrintln(this._code.toString()));
                        iCurrentBlockVectorPosition += this._code.getTop6Bits() + 1;
                        try {
                            iRevZigZagMatrixPos = MdecInputStream.REVERSE_ZIG_ZAG_LOOKUP_LIST[iCurrentBlockVectorPosition];
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            MdecContext.MacroBlockPixel macBlkXY = context.getMacroBlockPixel();
                            throw new MdecException.ReadCorruption(MdecException.RLC_OOB_IN_BLOCK_NAME(iCurrentBlockVectorPosition, context.getTotalMacroBlocksRead(), macBlkXY.x, macBlkXY.y, context.getCurrentBlock().ordinal(), context.getCurrentBlock().name()), ex);
                        }
                        if (this._code.getBottom10Bits() != 0) {
                            assert (!DEBUG || this.setPrequantValue(iRevZigZagMatrixPos, this._code.getBottom10Bits()));
                            this._CurrentBlock[iRevZigZagMatrixPos] = (double)(this._code.getBottom10Bits() * this._aiQuantizationTable[iRevZigZagMatrixPos] * iCurrentBlockQscale) / 8.0;
                            ++iCurrentBlockNonZeroCount;
                            iCurrentBlockLastNonZeroPosition = iRevZigZagMatrixPos;
                        }
                        context.nextCode();
                    }
                    assert (!DEBUG || MdecDecoder_double.debugPrintln(this._code.toString()));
                    this.writeEndOfBlock(context.getTotalMacroBlocksRead(), context.getCurrentBlock().ordinal(), iCurrentBlockNonZeroCount, iCurrentBlockLastNonZeroPosition);
                    context.nextCodeEndBlock();
                }
            }
        }
        finally {
            while (context.getTotalMacroBlocksRead() < this._iTotalMacBlocks) {
                this.writeEndOfBlock(context.getTotalMacroBlocksRead(), context.getCurrentBlock().ordinal(), 0, 0);
                context.nextCodeEndBlock();
            }
            mdecInStream.logIfAny0AcCoefficient();
        }
    }

    private boolean debugPrintBlock(@Nonnull String sMsg) {
        System.out.println(sMsg);
        for (int i = 0; i < 8; ++i) {
            System.out.print("[ ");
            for (int j = 0; j < 8; ++j) {
                System.out.format("%1.3f, ", this._CurrentBlock[j + i * 8]);
            }
            System.out.print("]");
            System.out.println();
        }
        return true;
    }

    private void writeEndOfBlock(int iMacroBlock, int iBlock, int iNonZeroCount, int iNonZeroPos) {
        int iOutWidth;
        int iOutOffset;
        double[] outputBuffer;
        assert (!DEBUG || this.debugPrintPrequantBlock());
        assert (!DEBUG || this.debugPrintBlock("Pre-IDCT block"));
        switch (iBlock) {
            case 0: {
                outputBuffer = this._adblDecodedCrBuffer;
                iOutOffset = this._aiChromaMacBlkOfsLookup[iMacroBlock];
                iOutWidth = this.CW;
                break;
            }
            case 1: {
                outputBuffer = this._dblDecodedCbBuffer;
                iOutOffset = this._aiChromaMacBlkOfsLookup[iMacroBlock];
                iOutWidth = this.CW;
                break;
            }
            default: {
                outputBuffer = this._adblDecodedLumaBuffer;
                iOutOffset = this._aiLumaBlkOfsLookup[iMacroBlock * 4 + iBlock - 2];
                iOutWidth = this.W;
            }
        }
        if (iNonZeroCount == 0) {
            int i = 0;
            while (i < 8) {
                Arrays.fill(outputBuffer, iOutOffset, iOutOffset + 8, 0.0);
                ++i;
                iOutOffset += iOutWidth;
            }
        } else {
            if (iNonZeroCount == 1) {
                this._idct.IDCT_1NonZero(this._CurrentBlock, iNonZeroPos, 0, this._CurrentBlock);
            } else {
                this._idct.IDCT(this._CurrentBlock, 0, this._CurrentBlock);
            }
            int i = 0;
            int iSrcOfs = 0;
            while (i < 8) {
                System.arraycopy(this._CurrentBlock, iSrcOfs, outputBuffer, iOutOffset, 8);
                ++i;
                iSrcOfs += 8;
                iOutOffset += iOutWidth;
            }
        }
        assert (!DEBUG || this.debugPrintBlock("Post-IDCT block"));
    }

    @Override
    public void readDecodedRgb(int iDestWidth, int iDestHeight, @Nonnull int[] aiDest, int iOutStart, int iOutStride) {
        switch (this._upsampler) {
            case NearestNeighbor: {
                this.nearestNeighborUpsample(this._adblDecodedCrBuffer, this._adblTempUpsampledCr);
                this.nearestNeighborUpsample(this._dblDecodedCbBuffer, this._adblTempUpsampledCb);
                break;
            }
            case Bilinear: {
                this.bilinearUpsample(this._adblDecodedCrBuffer, this._adblTempUpsampledCr);
                this.bilinearUpsample(this._dblDecodedCbBuffer, this._adblTempUpsampledCb);
                break;
            }
            default: {
                this._resampler.setFilter(this._upsampler._filter);
                this._resampler.doFilter(this._adblDecodedCrBuffer, this.CW, this.CH, this._adblTempUpsampledCr);
                this._resampler.doFilter(this._dblDecodedCbBuffer, this.CW, this.CH, this._adblTempUpsampledCb);
            }
        }
        RGB rgb = new RGB();
        int iY = 0;
        int iSrcLineOfsStart = 0;
        int iDestLineOfsStart = iOutStart;
        while (iY < iDestHeight) {
            int iX = 0;
            int iSrcOfs = iSrcLineOfsStart;
            int iDestOfs = iDestLineOfsStart;
            while (iX < iDestWidth) {
                double y = this._adblDecodedLumaBuffer[iSrcOfs];
                double cb = this._adblTempUpsampledCb[iSrcOfs];
                double cr = this._adblTempUpsampledCr[iSrcOfs];
                PsxYCbCr.toRgb(y, cb, cr, rgb);
                aiDest[iDestOfs] = rgb.toInt();
                ++iX;
                ++iSrcOfs;
                ++iDestOfs;
            }
            ++iY;
            iSrcLineOfsStart += this.W;
            iDestLineOfsStart += iOutStride;
        }
    }

    public void readDecoded_Rec601_YCbCr420(@Nonnull YCbCrImage ycc) {
        int WIDTH = ycc.getWidth();
        int HEIGHT = ycc.getHeight();
        if (WIDTH % 2 != 0) {
            throw new IllegalArgumentException("Image width must be multiple of 2.");
        }
        if (HEIGHT % 2 != 0) {
            throw new IllegalArgumentException("Image height must be multiple of 2.");
        }
        PsxYCbCr psxycc = new PsxYCbCr();
        Rec601YCbCr recycc = new Rec601YCbCr();
        int W2 = this.W * 2;
        int iLumaLineOfsStart = 0;
        int iChromaLineOfsStart = 0;
        int iY = 0;
        int iCY = 0;
        while (iY < HEIGHT) {
            int iSrcLumaOfs1 = iLumaLineOfsStart;
            int iSrcLumaOfs2 = iLumaLineOfsStart + this.W;
            int iSrcChromaOfs = iChromaLineOfsStart;
            int iX = 0;
            int iCX = 0;
            while (iX < WIDTH) {
                psxycc.cr = this._adblDecodedCrBuffer[iSrcChromaOfs];
                psxycc.cb = this._dblDecodedCbBuffer[iSrcChromaOfs];
                psxycc.y1 = this._adblDecodedLumaBuffer[iSrcLumaOfs1++];
                psxycc.y3 = this._adblDecodedLumaBuffer[iSrcLumaOfs2++];
                psxycc.y2 = this._adblDecodedLumaBuffer[iSrcLumaOfs1++];
                psxycc.y4 = this._adblDecodedLumaBuffer[iSrcLumaOfs2++];
                psxycc.toRec_601_YCbCr(recycc);
                ycc.setY(iX + 0, iY + 0, MdecDecoder_double.clamp(recycc.y1));
                ycc.setY(iX + 1, iY + 0, MdecDecoder_double.clamp(recycc.y2));
                ycc.setY(iX + 0, iY + 1, MdecDecoder_double.clamp(recycc.y3));
                ycc.setY(iX + 1, iY + 1, MdecDecoder_double.clamp(recycc.y4));
                ycc.setCb(iCX, iCY, MdecDecoder_double.clamp(recycc.cb));
                ycc.setCr(iCX, iCY, MdecDecoder_double.clamp(recycc.cr));
                iX += 2;
                ++iCX;
                ++iSrcChromaOfs;
            }
            iY += 2;
            ++iCY;
            iLumaLineOfsStart += W2;
            iChromaLineOfsStart += this.CW;
        }
    }

    public void readDecoded_JFIF_YCbCr420(@Nonnull YCbCrImage ycc) {
        int WIDTH = ycc.getWidth();
        int HEIGHT = ycc.getHeight();
        if (WIDTH % 2 != 0) {
            throw new IllegalArgumentException("Image width must be multiple of 2.");
        }
        if (HEIGHT % 2 != 0) {
            throw new IllegalArgumentException("Image height must be multiple of 2.");
        }
        PsxYCbCr psxycc = new PsxYCbCr();
        Rec601YCbCr recycc = new Rec601YCbCr();
        int W2 = this.W * 2;
        int iLumaLineOfsStart = 0;
        int iChromaLineOfsStart = 0;
        int iY = 0;
        int iCY = 0;
        while (iY < HEIGHT) {
            int iSrcLumaOfs1 = iLumaLineOfsStart;
            int iSrcLumaOfs2 = iLumaLineOfsStart + this.W;
            int iSrcChromaOfs = iChromaLineOfsStart;
            int iX = 0;
            int iCX = 0;
            while (iX < WIDTH) {
                psxycc.cr = this._adblDecodedCrBuffer[iSrcChromaOfs];
                psxycc.cb = this._dblDecodedCbBuffer[iSrcChromaOfs];
                psxycc.y1 = this._adblDecodedLumaBuffer[iSrcLumaOfs1++];
                psxycc.y3 = this._adblDecodedLumaBuffer[iSrcLumaOfs2++];
                psxycc.y2 = this._adblDecodedLumaBuffer[iSrcLumaOfs1++];
                psxycc.y4 = this._adblDecodedLumaBuffer[iSrcLumaOfs2++];
                psxycc.toRec_JFIF_YCbCr(recycc);
                ycc.setY(iX + 0, iY + 0, MdecDecoder_double.clamp(recycc.y1));
                ycc.setY(iX + 1, iY + 0, MdecDecoder_double.clamp(recycc.y2));
                ycc.setY(iX + 0, iY + 1, MdecDecoder_double.clamp(recycc.y3));
                ycc.setY(iX + 1, iY + 1, MdecDecoder_double.clamp(recycc.y4));
                ycc.setCb(iCX, iCY, MdecDecoder_double.clamp(recycc.cb));
                ycc.setCr(iCX, iCY, MdecDecoder_double.clamp(recycc.cr));
                iX += 2;
                ++iCX;
                ++iSrcChromaOfs;
            }
            iY += 2;
            ++iCY;
            iLumaLineOfsStart += W2;
            iChromaLineOfsStart += this.CW;
        }
    }

    private static byte clamp(double dbl) {
        long lng = Math.round(dbl);
        if (lng < 0L) {
            return 0;
        }
        if (lng > 255L) {
            return -1;
        }
        return (byte)lng;
    }

    private void nearestNeighborUpsample(@Nonnull double[] in, @Nonnull double[] out) {
        int outOfs = 0;
        int inOfs = 0;
        for (int inY = 0; inY < this.CH; ++inY) {
            for (int inX = 0; inX < this.CW; ++inX) {
                out[outOfs++] = in[inOfs];
                out[outOfs++] = in[inOfs];
                ++inOfs;
            }
            System.arraycopy(out, outOfs - this.W, out, outOfs, this.W);
            outOfs += this.W;
        }
    }

    private void bilinearUpsample(@Nonnull double[] in, @Nonnull double[] out) {
        double c2;
        double c1;
        int i;
        out[0 + 0 * this.W] = in[0 + 0 * this.CW];
        out[this.W - 1 + 0 * this.W] = in[this.CW - 1 + 0 * this.CW];
        out[0 + (this.H - 1) * this.W] = in[0 + (this.CH - 1) * this.CW];
        out[this.W - 1 + (this.H - 1) * this.W] = in[this.CW - 1 + (this.CH - 1) * this.CW];
        for (i = 0; i < 2; ++i) {
            int inX;
            int outX;
            if (i == 0) {
                outX = 0;
                inX = 0;
            } else {
                outX = this.W - 1;
                inX = this.CW - 1;
            }
            for (int inY = 0; inY < this.CH - 1; ++inY) {
                c1 = in[inX + inY * this.CW];
                c2 = in[inX + (inY + 1) * this.CW];
                int outY = 1 + inY * 2;
                out[outX + outY * this.W] = c1 * 0.75 + c2 * 0.25;
                out[outX + (outY + 1) * this.W] = c1 * 0.25 + c2 * 0.75;
            }
        }
        for (i = 0; i < 2; ++i) {
            int inY;
            int outY;
            if (i == 0) {
                outY = 0;
                inY = 0;
            } else {
                outY = this.H - 1;
                inY = this.CH - 1;
            }
            for (int inX = 0; inX < this.CW - 1; ++inX) {
                c1 = in[inX + inY * this.CW];
                c2 = in[inX + 1 + inY * this.CW];
                int outX = 1 + inX * 2;
                out[outX + outY * this.W] = c1 * 0.75 + c2 * 0.25;
                out[outX + 1 + outY * this.W] = c1 * 0.25 + c2 * 0.75;
            }
        }
        for (int inY = 0; inY < this.CH - 1; ++inY) {
            int inOfs = inY * this.CW;
            int outOfs = (inY * 2 + 1) * this.W + 1;
            double c22 = in[inOfs];
            double c4 = in[inOfs + this.CW];
            ++inOfs;
            int inX = 0;
            while (inX < this.CW - 1) {
                double c12 = c22;
                c22 = in[inOfs];
                double c3 = c4;
                c4 = in[inOfs + this.CW];
                double c1_c4_mul_3_16 = (c12 + c4) * 0.1875;
                double c2_c3_mul_3_16 = (c22 + c3) * 0.1875;
                out[outOfs] = c12 * 0.5625 + c2_c3_mul_3_16 + c4 * 0.0625;
                out[outOfs + this.W] = c1_c4_mul_3_16 + c22 * 0.0625 + c3 * 0.5625;
                out[++outOfs] = c1_c4_mul_3_16 + c22 * 0.5625 + c3 * 0.0625;
                out[outOfs + this.W] = c12 * 0.0625 + c2_c3_mul_3_16 + c4 * 0.5625;
                ++outOfs;
                ++inX;
                ++inOfs;
            }
        }
    }
}

