/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import java.util.Arrays;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;

public abstract class MdecDecoder {
    public static boolean DEBUG = false;
    protected final MdecCode _code = new MdecCode();
    private final int _iMacBlockWidth;
    protected final int _iMacBlockHeight;
    protected final int _iTotalMacBlocks;
    protected final int W;
    protected final int H;
    protected final int CW;
    protected final int CH;
    protected final int[] _aiLumaBlkOfsLookup;
    protected final int[] _aiChromaMacBlkOfsLookup;
    protected final int[] _aiQuantizationTable = Arrays.copyOf(MdecInputStream.PSX_DEFAULT_QUANTIZATION_MATRIX, MdecInputStream.PSX_DEFAULT_QUANTIZATION_MATRIX.length);
    protected final int[] _aiDebugPreqantBlock;

    protected static boolean debugPrintln(String s) {
        System.out.println(s);
        return true;
    }

    protected MdecDecoder(int iWidth, int iHeight) {
        this._iMacBlockWidth = Calc.macroblockDim(iWidth);
        this._iMacBlockHeight = Calc.macroblockDim(iHeight);
        this._iTotalMacBlocks = this._iMacBlockWidth * this._iMacBlockHeight;
        this.W = this._iMacBlockWidth * 16;
        this.H = this._iMacBlockHeight * 16;
        this.CW = this._iMacBlockWidth * 8;
        this.CH = this._iMacBlockHeight * 8;
        this._aiChromaMacBlkOfsLookup = new int[this._iMacBlockWidth * this._iMacBlockHeight];
        this._aiLumaBlkOfsLookup = new int[this._iMacBlockWidth * this._iMacBlockHeight * 4];
        int iMbIdx = 0;
        for (int iMbX = 0; iMbX < this._iMacBlockWidth; ++iMbX) {
            for (int iMbY = 0; iMbY < this._iMacBlockHeight; ++iMbY) {
                this._aiChromaMacBlkOfsLookup[iMbIdx] = iMbX * 8 + iMbY * 8 * this.CW;
                int iBlkIdx = 0;
                for (int iBlkY = 0; iBlkY < 2; ++iBlkY) {
                    for (int iBlkX = 0; iBlkX < 2; ++iBlkX) {
                        this._aiLumaBlkOfsLookup[iMbIdx * 4 + iBlkIdx] = iMbX * 16 + iBlkX * 8 + (iMbY * 16 + iBlkY * 8) * this.W;
                        ++iBlkIdx;
                    }
                }
                ++iMbIdx;
            }
        }
        boolean blnAssertsEnabled = false;
        if (!$assertionsDisabled) {
            blnAssertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this._aiDebugPreqantBlock = (int[])(blnAssertsEnabled && DEBUG ? new int[64] : null);
    }

    protected boolean clearPrequantTable() {
        Arrays.fill(this._aiDebugPreqantBlock, 0);
        return true;
    }

    protected boolean setPrequantValue(int iPos, int iVal) {
        this._aiDebugPreqantBlock[iPos] = iVal;
        return true;
    }

    protected boolean debugPrintPrequantBlock() {
        System.out.println("Pre-dequantization block");
        for (int i = 0; i < 8; ++i) {
            System.out.print("[ ");
            for (int j = 0; j < 8; ++j) {
                System.out.format("%d, ", this._aiDebugPreqantBlock[j + i * 8]);
            }
            System.out.print("]");
            System.out.println();
        }
        return true;
    }

    public abstract void decode(@Nonnull MdecInputStream var1) throws MdecException.EndOfStream, MdecException.ReadCorruption;

    public abstract void readDecodedRgb(int var1, int var2, @Nonnull int[] var3, int var4, int var5);

    public void readDecodedRgb(int iDestWidth, int iDestHeight, @Nonnull int[] aiDest) {
        this.readDecodedRgb(iDestWidth, iDestHeight, aiDest, 0, iDestWidth);
    }

    public void setQuantizationTable(@Nonnull int[] aiNewTable) {
        if (aiNewTable.length != this._aiQuantizationTable.length) {
            throw new IllegalArgumentException("Incorrect table size");
        }
        System.arraycopy(aiNewTable, 0, this._aiQuantizationTable, 0, this._aiQuantizationTable.length);
    }
}

