/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.mdec.MdecBlock;

public class MdecContext {
    private static final Logger LOG = Logger.getLogger(MdecContext.class.getName());
    private int _iCurrentMacroBlock = 0;
    @Nonnull
    private MdecBlock _currentBlock = MdecBlock.first();
    private int _iCurrentMdecCodeInCurrentBlock = 0;
    private int _iCurrentTotalBlocks = 0;
    private int _iCurrentTotalMdecCode = 0;
    @CheckForNull
    private final Integer _oiMacroBlockHeight;

    public MdecContext(int iFrameMacroBlockHeight) {
        this._oiMacroBlockHeight = iFrameMacroBlockHeight;
    }

    public MdecContext() {
        this._oiMacroBlockHeight = null;
    }

    public int getTotalMacroBlocksRead() {
        return this._iCurrentMacroBlock;
    }

    public int getTotalBlocksRead() {
        return this._iCurrentTotalBlocks;
    }

    public int getTotalMdecCodesRead() {
        return this._iCurrentTotalMdecCode;
    }

    @Nonnull
    public MdecBlock getCurrentBlock() {
        return this._currentBlock;
    }

    public int getMdecCodesReadInCurrentBlock() {
        return this._iCurrentMdecCodeInCurrentBlock;
    }

    public boolean atStartOfBlock() {
        return this._iCurrentMdecCodeInCurrentBlock == 0;
    }

    public void nextCode() {
        ++this._iCurrentTotalMdecCode;
        ++this._iCurrentMdecCodeInCurrentBlock;
        if (this._iCurrentMdecCodeInCurrentBlock > 64) {
            LOG.log(Level.WARNING, "Impossible number of codes in a block {0}", this._iCurrentMdecCodeInCurrentBlock);
        }
    }

    public void nextCodeEndBlock() {
        ++this._iCurrentTotalMdecCode;
        this._iCurrentMdecCodeInCurrentBlock = 0;
        ++this._iCurrentTotalBlocks;
        this._currentBlock = this._currentBlock.next();
        if (this._currentBlock == MdecBlock.first()) {
            ++this._iCurrentMacroBlock;
        }
    }

    @Nonnull
    public MdecContext copy() {
        MdecContext c = new MdecContext();
        c._iCurrentMacroBlock = this._iCurrentMacroBlock;
        c._currentBlock = this._currentBlock;
        c._iCurrentMdecCodeInCurrentBlock = this._iCurrentMdecCodeInCurrentBlock;
        c._iCurrentTotalBlocks = this._iCurrentTotalBlocks;
        c._iCurrentTotalMdecCode = this._iCurrentTotalMdecCode;
        return c;
    }

    @CheckForNull
    public MacroBlockPixel getMacroBlockPixel() {
        if (this._oiMacroBlockHeight == null) {
            return null;
        }
        int iMacroBlockHeight = this._oiMacroBlockHeight;
        return new MacroBlockPixel(this._iCurrentMacroBlock / iMacroBlockHeight * 16, this._iCurrentMacroBlock % iMacroBlockHeight * 16);
    }

    public String toString() {
        String s = String.format("Macro.block.code %d.%s(%d).%d total blocks %d codes %d", new Object[]{this._iCurrentMacroBlock, this._currentBlock, this._currentBlock.ordinal(), this._iCurrentMdecCodeInCurrentBlock, this._iCurrentTotalBlocks, this._iCurrentTotalMdecCode});
        MacroBlockPixel pixel = this.getMacroBlockPixel();
        if (pixel == null) {
            return s;
        }
        return s + " " + pixel;
    }

    public static class MacroBlockPixel {
        public final int x;
        public final int y;

        private MacroBlockPixel(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }
}

