/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import javax.annotation.Nonnull;
import jpsxdec.util.Misc;

public class MdecCode
implements Comparable<MdecCode> {
    public static final int MDEC_END_OF_DATA = 65024;
    public static final int MDEC_END_OF_DATA_TOP6 = 63;
    public static final int MDEC_END_OF_DATA_BOTTOM10 = -512;
    private int _iTop6Bits;
    private int _iBottom10Bits;

    public MdecCode() {
        this._iTop6Bits = 0;
        this._iBottom10Bits = 0;
    }

    public MdecCode(int iTop6Bits, int iBottom10Bits) {
        if (!MdecCode.validTop(iTop6Bits)) {
            throw new IllegalArgumentException("Invalid top 6 bits " + iTop6Bits);
        }
        if (!MdecCode.validBottom(iBottom10Bits)) {
            throw new IllegalArgumentException("Invalid bottom 10 bits " + iBottom10Bits);
        }
        this._iTop6Bits = iTop6Bits;
        this._iBottom10Bits = iBottom10Bits;
    }

    public MdecCode(int iMdecWord) {
        this.set(iMdecWord);
    }

    public void setFrom(@Nonnull MdecCode other) {
        this._iTop6Bits = other._iTop6Bits;
        this._iBottom10Bits = other._iBottom10Bits;
    }

    public int getBottom10Bits() {
        return this._iBottom10Bits;
    }

    public void setBottom10Bits(int iBottom10Bits) {
        assert (MdecCode.validBottom(iBottom10Bits));
        this._iBottom10Bits = iBottom10Bits;
    }

    public int getTop6Bits() {
        return this._iTop6Bits;
    }

    public void setTop6Bits(int iTop6Bits) {
        assert (MdecCode.validTop(iTop6Bits));
        this._iTop6Bits = iTop6Bits;
    }

    public void setBits(int iTop6, int iBottom10) {
        assert (MdecCode.validTop(this._iTop6Bits) && MdecCode.validBottom(this._iBottom10Bits));
        this._iTop6Bits = iTop6;
        this._iBottom10Bits = iBottom10;
    }

    public void set(int iMdecWord) {
        this._iTop6Bits = iMdecWord >> 10 & 0x3F;
        this._iBottom10Bits = iMdecWord & 0x3FF;
        if ((this._iBottom10Bits & 0x200) == 512) {
            this._iBottom10Bits -= 1024;
        }
    }

    public int toMdecWord() {
        if (this.isEOD()) {
            return 65024;
        }
        if (!MdecCode.validTop(this._iTop6Bits)) {
            throw new IllegalStateException("MDEC code has invalid top 6 bits " + this._iTop6Bits);
        }
        if (!MdecCode.validBottom(this._iBottom10Bits)) {
            throw new IllegalStateException("MDEC code has invalid bottom 10 bits " + this._iBottom10Bits);
        }
        return (this._iTop6Bits & 0x3F) << 10 | this._iBottom10Bits & 0x3FF;
    }

    @Nonnull
    public MdecCode setToEndOfData() {
        this._iTop6Bits = 63;
        this._iBottom10Bits = -512;
        return this;
    }

    public boolean isEOD() {
        return this._iTop6Bits == 63 && this._iBottom10Bits == -512;
    }

    public boolean isValid() {
        return MdecCode.validTop(this._iTop6Bits) && MdecCode.validBottom(this._iBottom10Bits);
    }

    private static boolean validTop(int iTop6Bits) {
        return iTop6Bits >= 0 && iTop6Bits <= 63;
    }

    private static boolean validBottom(int iBottom10Bits) {
        return iBottom10Bits >= -512 && iBottom10Bits <= 511;
    }

    @Nonnull
    public MdecCode copy() {
        return new MdecCode(this._iTop6Bits, this._iBottom10Bits);
    }

    public String toString() {
        String s = String.format("%04x (%d, %d)", this.toMdecWord(), this._iTop6Bits, this._iBottom10Bits);
        if (this.isEOD()) {
            return s + " EOD";
        }
        return s;
    }

    @Override
    public int compareTo(MdecCode o) {
        int i = Misc.intCompare(this._iTop6Bits, o._iTop6Bits);
        if (i != 0) {
            return i;
        }
        return Misc.intCompare(this._iBottom10Bits, o._iBottom10Bits);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MdecCode other = (MdecCode)obj;
        return this._iTop6Bits == other._iTop6Bits && this._iBottom10Bits == other._iBottom10Bits;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this._iTop6Bits;
        hash = 97 * hash + this._iBottom10Bits;
        return hash;
    }
}

