/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public enum MdecBlock {
    Cr(true),
    Cb(true),
    Y1(false),
    Y2(false),
    Y3(false),
    Y4(false);

    private final boolean _blnIsChroma;
    private MdecBlock _nextBlock;
    private static final List<MdecBlock> VALUES;

    private MdecBlock(boolean blnIsChroma) {
        this._blnIsChroma = blnIsChroma;
    }

    public boolean isChroma() {
        return this._blnIsChroma;
    }

    public boolean isLuma() {
        return !this._blnIsChroma;
    }

    @Nonnull
    public MdecBlock next() {
        return this._nextBlock;
    }

    @Nonnull
    public static List<MdecBlock> list() {
        return VALUES;
    }

    public static int count() {
        return VALUES.size();
    }

    @Nonnull
    public static MdecBlock first() {
        return Cr;
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(MdecBlock.values()));
        MdecBlock.Cr._nextBlock = Cb;
        MdecBlock.Cb._nextBlock = Y1;
        MdecBlock.Y1._nextBlock = Y2;
        MdecBlock.Y2._nextBlock = Y3;
        MdecBlock.Y3._nextBlock = Y4;
        MdecBlock.Y4._nextBlock = Cr;
    }
}

