/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;

public enum ChromaUpsample {
    NearestNeighbor(I.CHROMA_UPSAMPLE_NEAR_NEIGHBOR_DESCRIPTION(), I.CHROMA_UPSAMPLE_NEAR_NEIGHBOR_CMDLINE(), null),
    Bilinear(I.CHROMA_UPSAMPLE_BILINEAR_DESCRIPTION(), I.CHROMA_UPSAMPLE_BILINEAR_CMDLINE(), null),
    Bicubic(I.CHROMA_UPSAMPLE_BICUBIC_DESCRIPTION(), I.CHROMA_UPSAMPLE_BICUBIC_CMDLINE(), ResampleFilters.getBiCubicFilter()),
    Bell(I.CHROMA_UPSAMPLE_BELL_DESCRIPTION(), I.CHROMA_UPSAMPLE_BELL_CMDLINE(), ResampleFilters.getBellFilter()),
    Mitchell(I.CHROMA_UPSAMPLE_MITCHELL_DESCRIPTION(), I.CHROMA_UPSAMPLE_MITCHELL_CMDLINE(), ResampleFilters.getMitchellFilter()),
    BSpline(I.CHROMA_UPSAMPLE_BSPLINE_DESCRIPTION(), I.CHROMA_UPSAMPLE_BSPLINE_CMDLINE(), ResampleFilters.getBSplineFilter()),
    Lanczos3(I.CHROMA_UPSAMPLE_LANCZOS3_DESCRIPTION(), I.CHROMA_UPSAMPLE_LANCZOS3_CMDLINE(), ResampleFilters.getLanczos3Filter()),
    Hermite(I.CHROMA_UPSAMPLE_HERMITE_DESCRIPTION(), I.CHROMA_UPSAMPLE_HERMITE_CMDLINE(), ResampleFilters.getHermiteFilter());

    @Nonnull
    private final ILocalizedMessage _description;
    private final ILocalizedMessage _cmdLine;
    @CheckForNull
    final ResampleFilter _filter;

    private ChromaUpsample(@CheckForNull ILocalizedMessage description, ILocalizedMessage cmdLine, ResampleFilter filter) {
        this._description = description;
        this._cmdLine = cmdLine;
        this._filter = filter;
    }

    public static ChromaUpsample fromCmdLine(String sCmdLine) {
        ChromaUpsample up = null;
        for (ChromaUpsample upsampler : ChromaUpsample.values()) {
            if (!upsampler.getCmdLine().equalsIgnoreCase(sCmdLine)) continue;
            up = upsampler;
            break;
        }
        return up;
    }

    public ILocalizedMessage getDescription() {
        return this._description;
    }

    public ILocalizedMessage getCmdLine() {
        return this._cmdLine;
    }

    public ILocalizedMessage getCmdLineHelp() {
        if (this._cmdLine.equals(this._description)) {
            return this._cmdLine;
        }
        return I.CHROMA_UPSAMPLE_CMDLINE_HELP(this._cmdLine, this._description);
    }

    public String toString() {
        return this.getDescription().getLocalizedMessage();
    }
}

