/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;

public class Ac0Checker
implements MdecInputStream {
    private static final Logger LOG = Logger.getLogger(Ac0Checker.class.getName());
    private final MdecInputStream _source;
    private final boolean _blnAlsoClean;
    private boolean _blnNextCodeIsQscaleDC = true;
    private int _iEscapeCodeAc0Count = 0;

    public static Ac0Checker wrapWithChecker(@Nonnull MdecInputStream source, boolean blnAlsoClean) {
        if (source instanceof Ac0Checker) {
            return (Ac0Checker)source;
        }
        return new Ac0Checker(source, blnAlsoClean);
    }

    public Ac0Checker(MdecInputStream source, boolean blnAlsoClean) {
        this._source = source;
        this._blnAlsoClean = blnAlsoClean;
    }

    public final int get0AcCoefficientCount() {
        return this._iEscapeCodeAc0Count;
    }

    public final void logIfAny0AcCoefficient() {
        if (this._iEscapeCodeAc0Count > 0) {
            LOG.log(Level.INFO, "Frame had {0} codes 0 AC coefficient", this._iEscapeCodeAc0Count);
        }
    }

    @Override
    public boolean readMdecCode(MdecCode code) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        boolean blnEod = this._source.readMdecCode(code);
        if (this._blnNextCodeIsQscaleDC) {
            this._blnNextCodeIsQscaleDC = false;
            if (blnEod) {
                LOG.log(Level.WARNING, "(qscale,DC) code says it's EOD");
            }
        } else if (blnEod) {
            this._blnNextCodeIsQscaleDC = true;
        } else if (code.getBottom10Bits() == 0) {
            ++this._iEscapeCodeAc0Count;
            LOG.log(Level.FINE, "Found AC=0 code {0}", code);
            if (this._blnAlsoClean) {
                blnEod = this.filter0(code);
            }
        }
        return blnEod;
    }

    private boolean filter0(MdecCode code) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        boolean blnEod;
        MdecCode nextCode = new MdecCode();
        do {
            if (blnEod = this._source.readMdecCode(nextCode)) {
                LOG.log(Level.FINE, "Discarding merge {0} at EOD", code);
                code.setFrom(nextCode);
                this._blnNextCodeIsQscaleDC = true;
                break;
            }
            code.setTop6Bits(code.getTop6Bits() + nextCode.getTop6Bits() + 1);
            code.setBottom10Bits(nextCode.getBottom10Bits());
            LOG.log(Level.FINE, "Merged code {0} into prev AC=0 code to form {1}", new Object[]{nextCode, code});
        } while (code.getBottom10Bits() == 0);
        return blnEod;
    }
}

