/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.encode;

import java.awt.image.BufferedImage;
import jpsxdec.formats.RGB;
import jpsxdec.formats.RgbIntImage;
import jpsxdec.psxvideo.PsxYCbCr;

public class PsxYCbCrImage {
    private int _iWidth;
    private int _iHeight;
    private double[] _adblY;
    private double[] _adblCb;
    private double[] _adblCr;

    public PsxYCbCrImage(int iWidth, int iHeight) {
        assert (iWidth > 0 && iHeight > 0 && iWidth % 2 == 0 && iHeight % 2 == 0);
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        int iSize = iWidth * iHeight;
        this._adblY = new double[iSize];
        this._adblCb = new double[iSize / 4];
        this._adblCr = new double[iSize / 4];
    }

    public PsxYCbCrImage(BufferedImage bi) {
        this(new RgbIntImage(bi));
    }

    public PsxYCbCrImage(RgbIntImage rgb) {
        this._iWidth = rgb.getWidth();
        this._iHeight = rgb.getHeight();
        assert (this._iWidth > 0 && this._iHeight > 0 && this._iWidth % 2 == 0 && this._iHeight % 2 == 0);
        int iSize = this._iWidth * this._iHeight;
        this._adblY = new double[iSize];
        this._adblCb = new double[iSize /= 4];
        this._adblCr = new double[iSize];
        RGB rgb1 = new RGB();
        RGB rgb2 = new RGB();
        RGB rgb3 = new RGB();
        RGB rgb4 = new RGB();
        PsxYCbCr yuv = new PsxYCbCr();
        for (int x = 0; x < this._iWidth; x += 2) {
            for (int y = 0; y < this._iHeight; y += 2) {
                rgb1.set(rgb.get(x, y));
                rgb2.set(rgb.get(x + 1, y));
                rgb3.set(rgb.get(x, y + 1));
                rgb4.set(rgb.get(x + 1, y + 1));
                yuv.fromRgb(rgb1, rgb2, rgb3, rgb4);
                this._adblY[x + y * this._iWidth] = yuv.y1;
                this._adblY[x + 1 + y * this._iWidth] = yuv.y2;
                this._adblY[x + (y + 1) * this._iWidth] = yuv.y3;
                this._adblY[x + 1 + (y + 1) * this._iWidth] = yuv.y4;
                this._adblCb[x / 2 + y / 2 * (this._iWidth / 2)] = yuv.cb;
                this._adblCr[x / 2 + y / 2 * (this._iWidth / 2)] = yuv.cr;
            }
        }
    }

    public RgbIntImage toRgb() {
        int[] aiARGB = new int[this._iWidth * this._iHeight];
        PsxYCbCr ycc = new PsxYCbCr();
        RGB rgb1 = new RGB();
        RGB rgb2 = new RGB();
        RGB rgb3 = new RGB();
        RGB rgb4 = new RGB();
        for (int iY = 0; iY < this._iHeight; iY += 2) {
            int iLinePos = iY * this._iWidth;
            int iChromLinePos = iY / 2 * (this._iWidth / 2);
            for (int iX = 0; iX < this._iWidth; iX += 2) {
                ycc.cb = this._adblCb[iChromLinePos];
                ycc.cr = this._adblCr[iChromLinePos];
                ++iChromLinePos;
                ycc.y1 = this._adblY[iLinePos + iX];
                ycc.y2 = this._adblY[iLinePos + iX + 1];
                ycc.y3 = this._adblY[iLinePos + this._iWidth + iX];
                ycc.y4 = this._adblY[iLinePos + this._iWidth + iX + 1];
                ycc.toRgb(rgb1, rgb2, rgb3, rgb4);
                aiARGB[iLinePos + iX] = rgb1.toInt();
                aiARGB[iLinePos + iX + 1] = rgb2.toInt();
                aiARGB[iLinePos + this._iWidth + iX] = rgb3.toInt();
                aiARGB[iLinePos + this._iWidth + iX + 1] = rgb4.toInt();
            }
        }
        return new RgbIntImage(this._iWidth, this._iHeight, aiARGB);
    }

    public double getY(int iLuminX, int iLuminY) {
        return this._adblY[iLuminX + iLuminY * this._iWidth];
    }

    public double getCbForY(int iLuminX, int iLuminY) {
        return this._adblCb[iLuminX / 2 + iLuminY / 2 * (this._iWidth / 2)];
    }

    public double getCrForY(int iLuminX, int iLuminY) {
        return this._adblCr[iLuminX / 2 + iLuminY / 2 * (this._iWidth / 2)];
    }

    public void setY(int iLuminX, int iLuminY, double y) {
        this._adblY[iLuminX + iLuminY * this._iWidth] = y;
    }

    public void setCb(int iChromX, int iChromY, double cb) {
        this._adblCb[iChromX + iChromY * (this._iWidth / 2)] = cb;
    }

    public void setCr(int iChromX, int iChromY, double cr) {
        this._adblCr[iChromX + iChromY * (this._iWidth / 2)] = cr;
    }

    public int getLumaHeight() {
        return this._iHeight;
    }

    public int getLumaWidth() {
        return this._iWidth;
    }

    public int getChromHeight() {
        return this._iHeight / 2;
    }

    public int getChromWidth() {
        return this._iWidth / 2;
    }

    public BufferedImage CrToBufferedImage() {
        return PsxYCbCrImage.doubleArrayToBufferedImage(this.getChromWidth(), this.getChromHeight(), this._adblCr, 0);
    }

    public BufferedImage CbToBufferedImage() {
        return PsxYCbCrImage.doubleArrayToBufferedImage(this.getChromWidth(), this.getChromHeight(), this._adblCb, 1);
    }

    public BufferedImage YToBufferedImage() {
        return PsxYCbCrImage.doubleArrayToBufferedImage(this.getLumaWidth(), this.getLumaHeight(), this._adblY, 2);
    }

    private static BufferedImage doubleArrayToBufferedImage(int iWidth, int iHeight, double[] adbl, int iMod) {
        BufferedImage bi = new BufferedImage(iWidth, iHeight, 1);
        for (int x = 0; x < iWidth; ++x) {
            for (int y = 0; y < iHeight; ++y) {
                int c = (int)(adbl[x + y * iWidth] + 128.0);
                if (c < 0) {
                    c = 0;
                } else if (c > 255) {
                    c = 255;
                }
                switch (iMod) {
                    case 0: {
                        c <<= 16;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        c |= c << 8 | c << 16;
                    }
                }
                bi.setRGB(x, y, c);
            }
        }
        return bi;
    }

    public double[] get8x8blockY(int iX, int iY) {
        if (iX < 0 || iX >= this._iWidth) {
            throw new IllegalArgumentException(iX + " X is out of bounds");
        }
        if (iY < 0 || iY >= this._iHeight) {
            throw new IllegalArgumentException(iY + " Y is out of bounds");
        }
        return PsxYCbCrImage.get8x8block(iX, iY, this._adblY, this._iWidth);
    }

    public double[] get8x8blockCb(int iX, int iY) {
        return PsxYCbCrImage.get8x8block(iX, iY, this._adblCb, this._iWidth / 2);
    }

    public double[] get8x8blockCr(int iX, int iY) {
        return PsxYCbCrImage.get8x8block(iX, iY, this._adblCr, this._iWidth / 2);
    }

    private static double[] get8x8block(int iX, int iY, double[] adblComponent, int iWidth) {
        double[] adblBlock = new double[64];
        for (int iXofs = 0; iXofs < 8; ++iXofs) {
            for (int iYofs = 0; iYofs < 8; ++iYofs) {
                adblBlock[iXofs + iYofs * 8] = adblComponent[iX + iXofs + (iY + iYofs) * iWidth];
            }
        }
        return adblBlock;
    }
}

