/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.encode;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.encode.MacroBlockEncoder;
import jpsxdec.psxvideo.encode.PsxYCbCrImage;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.ParsedMdecImage;

public class MdecEncoder
implements Iterable<MacroBlockEncoder> {
    private final Iterable<MdecCode>[] _aoMacroBlocks;
    private final ArrayList<MacroBlockEncoder> _replaceMbs = new ArrayList();
    private final int _iMacBlockWidth;
    private final int _iPixWidth;
    private final int _iPixHeight;
    private final int _iMacBlockHeight;

    public MdecEncoder(@Nonnull PsxYCbCrImage ycbcr, int iWidth, int iHeight) {
        if (ycbcr.getLumaWidth() % 16 != 0 || ycbcr.getLumaHeight() % 16 != 0) {
            throw new IllegalArgumentException();
        }
        this._iPixWidth = iWidth;
        this._iPixHeight = iHeight;
        this._iMacBlockWidth = ycbcr.getLumaWidth() / 16;
        this._iMacBlockHeight = ycbcr.getLumaHeight() / 16;
        this._aoMacroBlocks = new Iterable[this._iMacBlockWidth * this._iMacBlockHeight];
        for (int iMbX = 0; iMbX < this._iMacBlockWidth; ++iMbX) {
            for (int iMbY = 0; iMbY < this._iMacBlockHeight; ++iMbY) {
                MacroBlockEncoder enc;
                this._aoMacroBlocks[iMbX * this._iMacBlockHeight + iMbY] = enc = new MacroBlockEncoder(ycbcr, iMbX, iMbY);
                this._replaceMbs.add(enc);
            }
        }
    }

    public MdecEncoder(@Nonnull ParsedMdecImage original, @Nonnull PsxYCbCrImage newYcbcr, @Nonnull List<Point> macroBlocksToReplace) {
        if (newYcbcr.getLumaWidth() % 16 != 0 || newYcbcr.getLumaHeight() % 16 != 0) {
            throw new IllegalArgumentException();
        }
        this._iPixWidth = original.getWidth();
        this._iPixHeight = original.getHeight();
        this._iMacBlockWidth = Calc.macroblockDim(newYcbcr.getLumaWidth());
        this._iMacBlockHeight = Calc.macroblockDim(newYcbcr.getLumaHeight());
        this._aoMacroBlocks = new Iterable[this._iMacBlockWidth * this._iMacBlockHeight];
        Point p = new Point();
        for (int iMbX = 0; iMbX < this._iMacBlockWidth; ++iMbX) {
            for (int iMbY = 0; iMbY < this._iMacBlockHeight; ++iMbY) {
                Iterable<MdecCode> enc;
                p.setLocation(iMbX, iMbY);
                if (macroBlocksToReplace.contains(p)) {
                    MacroBlockEncoder e = new MacroBlockEncoder(newYcbcr, iMbX, iMbY);
                    this._replaceMbs.add(e);
                    enc = e;
                } else {
                    enc = original.getMacroBlockCodes(iMbX, iMbY);
                }
                this._aoMacroBlocks[iMbX * this._iMacBlockHeight + iMbY] = enc;
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<MacroBlockEncoder> iterator() {
        return this._replaceMbs.iterator();
    }

    @Nonnull
    public MdecInputStream getStream() {
        return new EncodedMdecInputStream();
    }

    public int getMacroBlockCount() {
        return this._iMacBlockWidth * this._iMacBlockHeight;
    }

    public int getMacroBlockWidth() {
        return this._iMacBlockWidth;
    }

    public int getMacroBlockHeight() {
        return this._iMacBlockHeight;
    }

    public int getPixelWidth() {
        return this._iPixWidth;
    }

    public int getPixelHeight() {
        return this._iPixHeight;
    }

    private class EncodedMdecInputStream
    implements MdecInputStream {
        private int __iCurMacBlk = 0;
        private Iterator<MdecCode> __curMb;

        public EncodedMdecInputStream() {
            this.__curMb = MdecEncoder.this._aoMacroBlocks[this.__iCurMacBlk].iterator();
        }

        @Override
        public boolean readMdecCode(@Nonnull MdecCode code) throws MdecException.EndOfStream {
            if (!this.__curMb.hasNext()) {
                if (this.__iCurMacBlk >= MdecEncoder.this._aoMacroBlocks.length) {
                    throw new MdecException.EndOfStream("Read beyond EncodedMdecInputStream");
                }
                ++this.__iCurMacBlk;
                this.__curMb = MdecEncoder.this._aoMacroBlocks[this.__iCurMacBlk].iterator();
            }
            code.setFrom(this.__curMb.next());
            return code.isEOD();
        }
    }
}

