/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.encode.PsxYCbCrImage;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.idct.StephensIDCT;

public class MacroBlockEncoder
implements Iterable<MdecCode> {
    private static final boolean DEBUG = false;
    private static final int[] PSX_DEFAULT_QUANTIZATION_MATRIX = Arrays.copyOf(MdecInputStream.PSX_DEFAULT_QUANTIZATION_MATRIX, MdecInputStream.PSX_DEFAULT_QUANTIZATION_MATRIX.length);
    private final StephensIDCT _DCT = new StephensIDCT();
    private final double[][] _aadblYBlockVectors = new double[4][];
    @Nonnull
    private final double[] _adblCbBlockVector;
    @Nonnull
    private final double[] _adblCrBlockVector;
    @Nonnull
    private int[] _aiQscales;
    @Nonnull
    private int[] _aiSquashQscales;
    public final int X;
    public final int Y;
    private double _dblEnergy = 0.0;

    MacroBlockEncoder(@Nonnull PsxYCbCrImage ycbcr, int iMacroBlockX, int iMacroBlockY) {
        this.X = iMacroBlockX;
        this.Y = iMacroBlockY;
        int iBlock = 0;
        for (int iBlockY = 0; iBlockY < 16; iBlockY += 8) {
            for (int iBlockX = 0; iBlockX < 16; iBlockX += 8) {
                double[] adblBlock = ycbcr.get8x8blockY(iMacroBlockX * 16 + iBlockX, iMacroBlockY * 16 + iBlockY);
                this._aadblYBlockVectors[iBlock] = this.preEncodeBlock(adblBlock, iBlock + 2);
                ++iBlock;
            }
        }
        double[] adblBlock = ycbcr.get8x8blockCb(iMacroBlockX * 8, iMacroBlockY * 8);
        this._adblCbBlockVector = this.preEncodeBlock(adblBlock, 0);
        adblBlock = ycbcr.get8x8blockCr(iMacroBlockX * 8, iMacroBlockY * 8);
        this._adblCrBlockVector = this.preEncodeBlock(adblBlock, 1);
    }

    @Nonnull
    private double[] preEncodeBlock(@Nonnull double[] adblBlock, int iBlock) {
        this._DCT.forwardDCT(adblBlock);
        double[] aiBlock = this.preQuantizeZigZagBlock(adblBlock, iBlock);
        return aiBlock;
    }

    @Nonnull
    private double[] preQuantizeZigZagBlock(@Nonnull double[] adblBlock, int iBlock) {
        double[] adblVector = new double[64];
        adblVector[0] = (int)Math.round(adblBlock[0] / (double)PSX_DEFAULT_QUANTIZATION_MATRIX[0]);
        for (int i = 1; i < MdecInputStream.REVERSE_ZIG_ZAG_LOOKUP_LIST.length; ++i) {
            int iZigZagPos = MdecInputStream.REVERSE_ZIG_ZAG_LOOKUP_LIST[i];
            if (iBlock >= 2) {
                this._dblEnergy += adblBlock[iZigZagPos] * (double)i * (double)i;
            }
            adblVector[i] = adblBlock[iZigZagPos] * 8.0 / (double)PSX_DEFAULT_QUANTIZATION_MATRIX[iZigZagPos];
        }
        return adblVector;
    }

    public double getEnergy() {
        return this._dblEnergy;
    }

    public void setToFullEncode(@Nonnull int[] aiQscales) {
        if (aiQscales.length != 6) {
            throw new IllegalArgumentException();
        }
        this._aiQscales = (int[])aiQscales.clone();
        this._aiSquashQscales = this._aiQscales;
    }

    public void setToPartialEncode(@Nonnull int[] aiQscales, @Nonnull int[] aiSquashQscales) {
        if (aiQscales.length != 6) {
            throw new IllegalArgumentException();
        }
        this._aiQscales = (int[])aiQscales.clone();
        this._aiSquashQscales = (int[])aiSquashQscales.clone();
    }

    @Override
    @Nonnull
    public Iterator<MdecCode> iterator() {
        if (this._aiQscales == null || this._aiSquashQscales == null) {
            throw new IllegalStateException();
        }
        ArrayList<MdecCode> codes = new ArrayList<MdecCode>();
        this.encodeBlock(this._adblCrBlockVector, codes, this._aiQscales[0], this._aiSquashQscales[0]);
        this.encodeBlock(this._adblCbBlockVector, codes, this._aiQscales[1], this._aiSquashQscales[1]);
        this.encodeBlock(this._aadblYBlockVectors[0], codes, this._aiQscales[2], this._aiSquashQscales[2]);
        this.encodeBlock(this._aadblYBlockVectors[1], codes, this._aiQscales[3], this._aiSquashQscales[3]);
        this.encodeBlock(this._aadblYBlockVectors[2], codes, this._aiQscales[4], this._aiSquashQscales[4]);
        this.encodeBlock(this._aadblYBlockVectors[3], codes, this._aiQscales[5], this._aiSquashQscales[5]);
        return codes.iterator();
    }

    private void encodeBlock(@Nonnull double[] adblVector, @Nonnull ArrayList<MdecCode> out, int iQscale, int iSquashQscale) {
        MdecCode code = new MdecCode();
        code.setTop6Bits(iQscale);
        code.setBottom10Bits((int)Math.round(adblVector[0]));
        out.add(code.copy());
        for (int iVectorPos = 1; iVectorPos < adblVector.length; ++iVectorPos) {
            int iZeroCount = 0;
            int iQuantVal = -1;
            while (iVectorPos < adblVector.length && (iQuantVal = iQscale == iSquashQscale ? (int)Math.round(adblVector[iVectorPos] / (double)iQscale) : (int)Math.round((double)(Math.round(adblVector[iVectorPos] / (double)iSquashQscale) * (long)iQscale) / (double)iSquashQscale)) == 0) {
                ++iZeroCount;
                ++iVectorPos;
            }
            if (iVectorPos >= adblVector.length) break;
            code.setTop6Bits(iZeroCount);
            code.setBottom10Bits(iQuantVal);
            out.add(code.copy());
        }
        code.setToEndOfData();
        out.add(code.copy());
    }
}

