/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.bitstreams.BitStreamCode;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAc;
import jpsxdec.psxvideo.mdec.MdecCode;

public class ZeroRunLengthAcLookup
implements Iterable<ZeroRunLengthAc> {
    @Nonnull
    private final ZeroRunLengthAc[] _aoList;
    private final ZeroRunLengthAc[] _aoTable_1xx = new ZeroRunLengthAc[4];
    private final ZeroRunLengthAc[] _aoTable_0xxxxxxx = new ZeroRunLengthAc[256];
    private final ZeroRunLengthAc[] _aoTable_000000xxxxxxxx = new ZeroRunLengthAc[256];
    private final ZeroRunLengthAc[] _aoTable_000000000xxxxxxxx = new ZeroRunLengthAc[256];
    private static final int b11000000000000000 = 98304;
    private static final int b10000000000000000 = 65536;
    private static final int b01000000000000000 = 32768;
    private static final int b00100000000000000 = 16384;
    private static final int b01111100000000000 = 63488;
    private static final int b00000011100000000 = 1792;
    private static final int b00000000011100000 = 224;
    private static final int b1000000000000000_ = 65536;
    private static final int b0100000000000000_ = 32768;
    private static final int b0010000000000000_ = 16384;
    private static final int b0001100000000000_ = 12288;
    private static final int b0001000000000000_ = 8192;
    private static final int b0000100000000000_ = 4096;
    private static final int b0000010000000000_ = 2048;
    private static final int b0000001000000000_ = 1024;
    private static final int b0000000100000000_ = 512;
    private static final int b0000000010000000_ = 256;
    private static final int b0000000001000000_ = 128;
    private static final int b0000000000100000_ = 64;
    private static final int b0000000000010000_ = 32;

    private ZeroRunLengthAcLookup(@Nonnull ZeroRunLengthAc[] aoList) {
        this._aoList = aoList;
        for (int i = 0; i < aoList.length; ++i) {
            ZeroRunLengthAc zrlac = aoList[i];
            BitStreamCode bitStreamCode = BitStreamCode.get(i);
            if (zrlac == null) {
                throw new IllegalStateException("Table incomplete: missing " + (Object)((Object)bitStreamCode));
            }
            this.setBits(bitStreamCode, zrlac);
        }
    }

    private void setBits(@Nonnull BitStreamCode bsc, @Nonnull ZeroRunLengthAc zrlac) {
        int iTableStart;
        int iBitsRemain;
        ZeroRunLengthAc[] aoTable;
        if (bsc.getString().startsWith("000000000")) {
            aoTable = this._aoTable_000000000xxxxxxxx;
            iBitsRemain = 8 - (bsc.getLength() - 9);
            iTableStart = Integer.parseInt(bsc.getString(), 2) << iBitsRemain;
        } else if (bsc.getString().startsWith("000000")) {
            aoTable = this._aoTable_000000xxxxxxxx;
            iBitsRemain = 8 - (bsc.getLength() - 6);
            iTableStart = Integer.parseInt(bsc.getString(), 2) << iBitsRemain;
        } else if (bsc.getString().startsWith("0")) {
            aoTable = this._aoTable_0xxxxxxx;
            iBitsRemain = 8 - (bsc.getLength() - 1);
            iTableStart = Integer.parseInt(bsc.getString(), 2) << iBitsRemain;
        } else {
            aoTable = this._aoTable_1xx;
            iBitsRemain = 2 - (bsc.getLength() - 1);
            iTableStart = Integer.parseInt(bsc.getString().substring(1), 2) << iBitsRemain;
        }
        int iTableEntriesToAssociate = 1 << iBitsRemain;
        for (int i = 0; i < iTableEntriesToAssociate; ++i) {
            if (aoTable[iTableStart + i] != null) {
                throw new RuntimeException("Trying to replace " + aoTable[iTableStart + i] + " with " + zrlac);
            }
            aoTable[iTableStart + i] = zrlac;
        }
    }

    @Override
    @Nonnull
    public Iterator<ZeroRunLengthAc> iterator() {
        return new Iterator<ZeroRunLengthAc>(){
            private int _i = 0;

            @Override
            public boolean hasNext() {
                return this._i < ZeroRunLengthAcLookup.this._aoList.length;
            }

            @Override
            @Nonnull
            public ZeroRunLengthAc next() {
                return ZeroRunLengthAcLookup.this._aoList[this._i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("List is immutable");
            }
        };
    }

    @CheckForNull
    public ZeroRunLengthAc lookup(int i17bits) {
        if ((i17bits & 0x10000) != 0) {
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println("Table 0 offset " + (i17bits >> 14 & 3)));
            return this._aoTable_1xx[i17bits >> 14 & 3];
        }
        if ((i17bits & 0xF800) != 0) {
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println("Table 1 offset " + (i17bits >> 8 & 0xFF)));
            return this._aoTable_0xxxxxxx[i17bits >> 8 & 0xFF];
        }
        if ((i17bits & 0x700) != 0) {
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println("Table 2 offset " + (i17bits >> 3 & 0xFF)));
            return this._aoTable_000000xxxxxxxx[i17bits >> 3 & 0xFF];
        }
        if ((i17bits & 0xE0) != 0) {
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println("Table 3 offset " + (i17bits & 0xFF)));
            return this._aoTable_000000000xxxxxxxx[i17bits & 0xFF];
        }
        return null;
    }

    @CheckForNull
    public ZeroRunLengthAc lookup_slow1(int i17bits) {
        int c;
        ZeroRunLengthAc[] array;
        if ((i17bits & 0x18000) == 65536) {
            return this._aoList[BitStreamCode._10_______________.ordinal()];
        }
        if ((i17bits & 0x18000) == 98304) {
            if ((i17bits & 0x4000) == 0) {
                return this._aoList[BitStreamCode._110______________.ordinal()];
            }
            return this._aoList[BitStreamCode._111______________.ordinal()];
        }
        if ((i17bits & 0xF800) != 0) {
            array = this._aoTable_0xxxxxxx;
            c = i17bits >> 8 & 0xFF;
        } else if ((i17bits & 0x700) != 0) {
            array = this._aoTable_000000xxxxxxxx;
            c = i17bits >> 3 & 0xFF;
        } else if ((i17bits & 0xE0) != 0) {
            array = this._aoTable_000000000xxxxxxxx;
            c = i17bits & 0xFF;
        } else {
            return null;
        }
        return array[c];
    }

    @CheckForNull
    public ZeroRunLengthAc lookup_slow2(int i17bits) {
        if ((i17bits & 0x18000) == 65536) {
            return this._aoList[BitStreamCode._10_______________.ordinal()];
        }
        if ((i17bits & 0x18000) == 98304) {
            if ((i17bits & 0x4000) == 0) {
                return this._aoList[BitStreamCode._110______________.ordinal()];
            }
            return this._aoList[BitStreamCode._111______________.ordinal()];
        }
        if ((i17bits & 0xF800) != 0) {
            return this._aoTable_0xxxxxxx[i17bits >> 8 & 0xFF];
        }
        if ((i17bits & 0x700) != 0) {
            return this._aoTable_000000xxxxxxxx[i17bits >> 3 & 0xFF];
        }
        if ((i17bits & 0xE0) != 0) {
            return this._aoTable_000000000xxxxxxxx[i17bits & 0xFF];
        }
        return null;
    }

    @CheckForNull
    public ZeroRunLengthAc lookup_slow3(int i17bits) {
        int c;
        ZeroRunLengthAc[] array;
        if ((i17bits & 0x10000) != 0) {
            if ((i17bits & 0x8000) == 0) {
                return this._aoList[BitStreamCode._10_______________.ordinal()];
            }
            if ((i17bits & 0x4000) == 0) {
                return this._aoList[BitStreamCode._110______________.ordinal()];
            }
            return this._aoList[BitStreamCode._111______________.ordinal()];
        }
        if ((i17bits & 0xF800) != 0) {
            array = this._aoTable_0xxxxxxx;
            c = i17bits >> 8 & 0xFF;
        } else if ((i17bits & 0x700) != 0) {
            array = this._aoTable_000000xxxxxxxx;
            c = i17bits >> 3 & 0xFF;
        } else if ((i17bits & 0xE0) != 0) {
            array = this._aoTable_000000000xxxxxxxx;
            c = i17bits & 0xFF;
        } else {
            return null;
        }
        return array[c];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckForNull
    public ZeroRunLengthAc lookup_old(int i17bits) {
        BitStreamCode vlc;
        if ((i17bits & 0x10000) != 0) {
            if ((i17bits & 0x8000) == 0) return this._aoList[BitStreamCode._10_______________.ordinal()];
            vlc = BitStreamCode.get(0);
        } else if ((i17bits & 0x8000) != 0) {
            vlc = (i17bits & 0x4000) != 0 ? BitStreamCode.get(1) : BitStreamCode.get(2 + (i17bits >>> 13 & 1));
        } else if ((i17bits & 0x4000) != 0) {
            vlc = (i17bits & 0x3000) != 0 ? BitStreamCode.get(3 + (i17bits >>> 12 & 3)) : BitStreamCode.get(15 + (i17bits >>> 9 & 7));
        } else if ((i17bits & 0x2000) != 0) {
            vlc = BitStreamCode.get(7 + (i17bits >>> 11 & 3));
        } else if ((i17bits & 0x1000) != 0) {
            vlc = BitStreamCode.get(11 + (i17bits >>> 10 & 3));
        } else {
            if ((i17bits & 0x800) != 0) {
                return this._aoList[BitStreamCode._000001___________.ordinal()];
            }
            if ((i17bits & 0x400) != 0) {
                vlc = BitStreamCode.get(23 + (i17bits >>> 7 & 7));
            } else if ((i17bits & 0x200) != 0) {
                vlc = BitStreamCode.get(31 + (i17bits >>> 5 & 0xF));
            } else if ((i17bits & 0x100) != 0) {
                vlc = BitStreamCode.get(47 + (i17bits >>> 4 & 0xF));
            } else if ((i17bits & 0x80) != 0) {
                vlc = BitStreamCode.get(63 + (i17bits >>> 3 & 0xF));
            } else if ((i17bits & 0x40) != 0) {
                vlc = BitStreamCode.get(79 + (i17bits >>> 2 & 0xF));
            } else {
                if ((i17bits & 0x20) == 0) return null;
                vlc = BitStreamCode.get(95 + (i17bits >>> 1 & 0xF));
            }
        }
        if ((i17bits & 1 << 16 - vlc.getLength()) != 0) return this._aoList[vlc.ordinal() + 1];
        return this._aoList[vlc.ordinal()];
    }

    public void printAllLookupTables(@Nonnull PrintStream ps) {
        int i;
        for (i = 0; i < this._aoTable_1xx.length; ++i) {
            ps.println("Table_1xx[" + i + "] = " + this._aoTable_1xx[i]);
        }
        for (i = 0; i < this._aoTable_0xxxxxxx.length; ++i) {
            ps.println("Table_0xxxxxxx[" + i + "] = " + this._aoTable_0xxxxxxx[i]);
        }
        for (i = 0; i < this._aoTable_000000xxxxxxxx.length; ++i) {
            ps.println("Table_000000xxxxxxxx[" + i + "] = " + this._aoTable_000000xxxxxxxx[i]);
        }
        for (i = 0; i < this._aoTable_000000000xxxxxxxx.length; ++i) {
            ps.println("Table_000000000xxxxxxxx[" + i + "] = " + this._aoTable_000000000xxxxxxxx[i]);
        }
    }

    public static class Builder {
        private final ZeroRunLengthAc[] _aoList = new ZeroRunLengthAc[BitStreamCode.getTotalCount()];
        private final TreeSet<MdecCode> _duplicateCodeChecker = new TreeSet();

        @Nonnull
        public Builder set(@Nonnull BitStreamCode bitStreamCode, int iZeroRunLength, int iAcCoefficient) {
            return this.add(new ZeroRunLengthAc(bitStreamCode, iZeroRunLength, iAcCoefficient));
        }

        @Nonnull
        public Builder add(@Nonnull ZeroRunLengthAc zrlac) {
            MdecCode mdecCode = zrlac.getMdecCodeCopy();
            if (mdecCode != null && !this._duplicateCodeChecker.add(mdecCode)) {
                throw new RuntimeException("Already got MDEC code " + mdecCode);
            }
            int iIndex = zrlac.getBitStreamCode().ordinal();
            if (this._aoList[iIndex] != null) {
                throw new RuntimeException("Trying to replace " + this._aoList[iIndex] + " with " + zrlac + " at " + iIndex);
            }
            this._aoList[iIndex] = zrlac;
            return this;
        }

        public Builder _11s(int zr, int aac) {
            return this.set(BitStreamCode._110______________, BitStreamCode._111______________, zr, aac);
        }

        public Builder _011s(int zr, int aac) {
            return this.set(BitStreamCode._0110_____________, BitStreamCode._0111_____________, zr, aac);
        }

        public Builder _0100s(int zr, int aac) {
            return this.set(BitStreamCode._01000____________, BitStreamCode._01001____________, zr, aac);
        }

        public Builder _0101s(int zr, int aac) {
            return this.set(BitStreamCode._01010____________, BitStreamCode._01011____________, zr, aac);
        }

        public Builder _00101s(int zr, int aac) {
            return this.set(BitStreamCode._001010___________, BitStreamCode._001011___________, zr, aac);
        }

        public Builder _00110s(int zr, int aac) {
            return this.set(BitStreamCode._001100___________, BitStreamCode._001101___________, zr, aac);
        }

        public Builder _00111s(int zr, int aac) {
            return this.set(BitStreamCode._001110___________, BitStreamCode._001111___________, zr, aac);
        }

        public Builder _000100s(int zr, int aac) {
            return this.set(BitStreamCode._0001000__________, BitStreamCode._0001001__________, zr, aac);
        }

        public Builder _000101s(int zr, int aac) {
            return this.set(BitStreamCode._0001010__________, BitStreamCode._0001011__________, zr, aac);
        }

        public Builder _000110s(int zr, int aac) {
            return this.set(BitStreamCode._0001100__________, BitStreamCode._0001101__________, zr, aac);
        }

        public Builder _000111s(int zr, int aac) {
            return this.set(BitStreamCode._0001110__________, BitStreamCode._0001111__________, zr, aac);
        }

        public Builder _0000100s(int zr, int aac) {
            return this.set(BitStreamCode._00001000_________, BitStreamCode._00001001_________, zr, aac);
        }

        public Builder _0000101s(int zr, int aac) {
            return this.set(BitStreamCode._00001010_________, BitStreamCode._00001011_________, zr, aac);
        }

        public Builder _0000110s(int zr, int aac) {
            return this.set(BitStreamCode._00001100_________, BitStreamCode._00001101_________, zr, aac);
        }

        public Builder _0000111s(int zr, int aac) {
            return this.set(BitStreamCode._00001110_________, BitStreamCode._00001111_________, zr, aac);
        }

        public Builder _00100000s(int zr, int aac) {
            return this.set(BitStreamCode._001000000________, BitStreamCode._001000001________, zr, aac);
        }

        public Builder _00100001s(int zr, int aac) {
            return this.set(BitStreamCode._001000010________, BitStreamCode._001000011________, zr, aac);
        }

        public Builder _00100010s(int zr, int aac) {
            return this.set(BitStreamCode._001000100________, BitStreamCode._001000101________, zr, aac);
        }

        public Builder _00100011s(int zr, int aac) {
            return this.set(BitStreamCode._001000110________, BitStreamCode._001000111________, zr, aac);
        }

        public Builder _00100100s(int zr, int aac) {
            return this.set(BitStreamCode._001001000________, BitStreamCode._001001001________, zr, aac);
        }

        public Builder _00100101s(int zr, int aac) {
            return this.set(BitStreamCode._001001010________, BitStreamCode._001001011________, zr, aac);
        }

        public Builder _00100110s(int zr, int aac) {
            return this.set(BitStreamCode._001001100________, BitStreamCode._001001101________, zr, aac);
        }

        public Builder _00100111s(int zr, int aac) {
            return this.set(BitStreamCode._001001110________, BitStreamCode._001001111________, zr, aac);
        }

        public Builder _0000001000s(int zr, int aac) {
            return this.set(BitStreamCode._00000010000______, BitStreamCode._00000010001______, zr, aac);
        }

        public Builder _0000001001s(int zr, int aac) {
            return this.set(BitStreamCode._00000010010______, BitStreamCode._00000010011______, zr, aac);
        }

        public Builder _0000001010s(int zr, int aac) {
            return this.set(BitStreamCode._00000010100______, BitStreamCode._00000010101______, zr, aac);
        }

        public Builder _0000001011s(int zr, int aac) {
            return this.set(BitStreamCode._00000010110______, BitStreamCode._00000010111______, zr, aac);
        }

        public Builder _0000001100s(int zr, int aac) {
            return this.set(BitStreamCode._00000011000______, BitStreamCode._00000011001______, zr, aac);
        }

        public Builder _0000001101s(int zr, int aac) {
            return this.set(BitStreamCode._00000011010______, BitStreamCode._00000011011______, zr, aac);
        }

        public Builder _0000001110s(int zr, int aac) {
            return this.set(BitStreamCode._00000011100______, BitStreamCode._00000011101______, zr, aac);
        }

        public Builder _0000001111s(int zr, int aac) {
            return this.set(BitStreamCode._00000011110______, BitStreamCode._00000011111______, zr, aac);
        }

        public Builder _000000010000s(int zr, int aac) {
            return this.set(BitStreamCode._0000000100000____, BitStreamCode._0000000100001____, zr, aac);
        }

        public Builder _000000010001s(int zr, int aac) {
            return this.set(BitStreamCode._0000000100010____, BitStreamCode._0000000100011____, zr, aac);
        }

        public Builder _000000010010s(int zr, int aac) {
            return this.set(BitStreamCode._0000000100100____, BitStreamCode._0000000100101____, zr, aac);
        }

        public Builder _000000010011s(int zr, int aac) {
            return this.set(BitStreamCode._0000000100110____, BitStreamCode._0000000100111____, zr, aac);
        }

        public Builder _000000010100s(int zr, int aac) {
            return this.set(BitStreamCode._0000000101000____, BitStreamCode._0000000101001____, zr, aac);
        }

        public Builder _000000010101s(int zr, int aac) {
            return this.set(BitStreamCode._0000000101010____, BitStreamCode._0000000101011____, zr, aac);
        }

        public Builder _000000010110s(int zr, int aac) {
            return this.set(BitStreamCode._0000000101100____, BitStreamCode._0000000101101____, zr, aac);
        }

        public Builder _000000010111s(int zr, int aac) {
            return this.set(BitStreamCode._0000000101110____, BitStreamCode._0000000101111____, zr, aac);
        }

        public Builder _000000011000s(int zr, int aac) {
            return this.set(BitStreamCode._0000000110000____, BitStreamCode._0000000110001____, zr, aac);
        }

        public Builder _000000011001s(int zr, int aac) {
            return this.set(BitStreamCode._0000000110010____, BitStreamCode._0000000110011____, zr, aac);
        }

        public Builder _000000011010s(int zr, int aac) {
            return this.set(BitStreamCode._0000000110100____, BitStreamCode._0000000110101____, zr, aac);
        }

        public Builder _000000011011s(int zr, int aac) {
            return this.set(BitStreamCode._0000000110110____, BitStreamCode._0000000110111____, zr, aac);
        }

        public Builder _000000011100s(int zr, int aac) {
            return this.set(BitStreamCode._0000000111000____, BitStreamCode._0000000111001____, zr, aac);
        }

        public Builder _000000011101s(int zr, int aac) {
            return this.set(BitStreamCode._0000000111010____, BitStreamCode._0000000111011____, zr, aac);
        }

        public Builder _000000011110s(int zr, int aac) {
            return this.set(BitStreamCode._0000000111100____, BitStreamCode._0000000111101____, zr, aac);
        }

        public Builder _000000011111s(int zr, int aac) {
            return this.set(BitStreamCode._0000000111110____, BitStreamCode._0000000111111____, zr, aac);
        }

        public Builder _0000000010000s(int zr, int aac) {
            return this.set(BitStreamCode._00000000100000___, BitStreamCode._00000000100001___, zr, aac);
        }

        public Builder _0000000010001s(int zr, int aac) {
            return this.set(BitStreamCode._00000000100010___, BitStreamCode._00000000100011___, zr, aac);
        }

        public Builder _0000000010010s(int zr, int aac) {
            return this.set(BitStreamCode._00000000100100___, BitStreamCode._00000000100101___, zr, aac);
        }

        public Builder _0000000010011s(int zr, int aac) {
            return this.set(BitStreamCode._00000000100110___, BitStreamCode._00000000100111___, zr, aac);
        }

        public Builder _0000000010100s(int zr, int aac) {
            return this.set(BitStreamCode._00000000101000___, BitStreamCode._00000000101001___, zr, aac);
        }

        public Builder _0000000010101s(int zr, int aac) {
            return this.set(BitStreamCode._00000000101010___, BitStreamCode._00000000101011___, zr, aac);
        }

        public Builder _0000000010110s(int zr, int aac) {
            return this.set(BitStreamCode._00000000101100___, BitStreamCode._00000000101101___, zr, aac);
        }

        public Builder _0000000010111s(int zr, int aac) {
            return this.set(BitStreamCode._00000000101110___, BitStreamCode._00000000101111___, zr, aac);
        }

        public Builder _0000000011000s(int zr, int aac) {
            return this.set(BitStreamCode._00000000110000___, BitStreamCode._00000000110001___, zr, aac);
        }

        public Builder _0000000011001s(int zr, int aac) {
            return this.set(BitStreamCode._00000000110010___, BitStreamCode._00000000110011___, zr, aac);
        }

        public Builder _0000000011010s(int zr, int aac) {
            return this.set(BitStreamCode._00000000110100___, BitStreamCode._00000000110101___, zr, aac);
        }

        public Builder _0000000011011s(int zr, int aac) {
            return this.set(BitStreamCode._00000000110110___, BitStreamCode._00000000110111___, zr, aac);
        }

        public Builder _0000000011100s(int zr, int aac) {
            return this.set(BitStreamCode._00000000111000___, BitStreamCode._00000000111001___, zr, aac);
        }

        public Builder _0000000011101s(int zr, int aac) {
            return this.set(BitStreamCode._00000000111010___, BitStreamCode._00000000111011___, zr, aac);
        }

        public Builder _0000000011110s(int zr, int aac) {
            return this.set(BitStreamCode._00000000111100___, BitStreamCode._00000000111101___, zr, aac);
        }

        public Builder _0000000011111s(int zr, int aac) {
            return this.set(BitStreamCode._00000000111110___, BitStreamCode._00000000111111___, zr, aac);
        }

        public Builder _00000000010000s(int zr, int aac) {
            return this.set(BitStreamCode._000000000100000__, BitStreamCode._000000000100001__, zr, aac);
        }

        public Builder _00000000010001s(int zr, int aac) {
            return this.set(BitStreamCode._000000000100010__, BitStreamCode._000000000100011__, zr, aac);
        }

        public Builder _00000000010010s(int zr, int aac) {
            return this.set(BitStreamCode._000000000100100__, BitStreamCode._000000000100101__, zr, aac);
        }

        public Builder _00000000010011s(int zr, int aac) {
            return this.set(BitStreamCode._000000000100110__, BitStreamCode._000000000100111__, zr, aac);
        }

        public Builder _00000000010100s(int zr, int aac) {
            return this.set(BitStreamCode._000000000101000__, BitStreamCode._000000000101001__, zr, aac);
        }

        public Builder _00000000010101s(int zr, int aac) {
            return this.set(BitStreamCode._000000000101010__, BitStreamCode._000000000101011__, zr, aac);
        }

        public Builder _00000000010110s(int zr, int aac) {
            return this.set(BitStreamCode._000000000101100__, BitStreamCode._000000000101101__, zr, aac);
        }

        public Builder _00000000010111s(int zr, int aac) {
            return this.set(BitStreamCode._000000000101110__, BitStreamCode._000000000101111__, zr, aac);
        }

        public Builder _00000000011000s(int zr, int aac) {
            return this.set(BitStreamCode._000000000110000__, BitStreamCode._000000000110001__, zr, aac);
        }

        public Builder _00000000011001s(int zr, int aac) {
            return this.set(BitStreamCode._000000000110010__, BitStreamCode._000000000110011__, zr, aac);
        }

        public Builder _00000000011010s(int zr, int aac) {
            return this.set(BitStreamCode._000000000110100__, BitStreamCode._000000000110101__, zr, aac);
        }

        public Builder _00000000011011s(int zr, int aac) {
            return this.set(BitStreamCode._000000000110110__, BitStreamCode._000000000110111__, zr, aac);
        }

        public Builder _00000000011100s(int zr, int aac) {
            return this.set(BitStreamCode._000000000111000__, BitStreamCode._000000000111001__, zr, aac);
        }

        public Builder _00000000011101s(int zr, int aac) {
            return this.set(BitStreamCode._000000000111010__, BitStreamCode._000000000111011__, zr, aac);
        }

        public Builder _00000000011110s(int zr, int aac) {
            return this.set(BitStreamCode._000000000111100__, BitStreamCode._000000000111101__, zr, aac);
        }

        public Builder _00000000011111s(int zr, int aac) {
            return this.set(BitStreamCode._000000000111110__, BitStreamCode._000000000111111__, zr, aac);
        }

        public Builder _000000000010000s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000100000_, BitStreamCode._0000000000100001_, zr, aac);
        }

        public Builder _000000000010001s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000100010_, BitStreamCode._0000000000100011_, zr, aac);
        }

        public Builder _000000000010010s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000100100_, BitStreamCode._0000000000100101_, zr, aac);
        }

        public Builder _000000000010011s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000100110_, BitStreamCode._0000000000100111_, zr, aac);
        }

        public Builder _000000000010100s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000101000_, BitStreamCode._0000000000101001_, zr, aac);
        }

        public Builder _000000000010101s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000101010_, BitStreamCode._0000000000101011_, zr, aac);
        }

        public Builder _000000000010110s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000101100_, BitStreamCode._0000000000101101_, zr, aac);
        }

        public Builder _000000000010111s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000101110_, BitStreamCode._0000000000101111_, zr, aac);
        }

        public Builder _000000000011000s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000110000_, BitStreamCode._0000000000110001_, zr, aac);
        }

        public Builder _000000000011001s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000110010_, BitStreamCode._0000000000110011_, zr, aac);
        }

        public Builder _000000000011010s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000110100_, BitStreamCode._0000000000110101_, zr, aac);
        }

        public Builder _000000000011011s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000110110_, BitStreamCode._0000000000110111_, zr, aac);
        }

        public Builder _000000000011100s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000111000_, BitStreamCode._0000000000111001_, zr, aac);
        }

        public Builder _000000000011101s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000111010_, BitStreamCode._0000000000111011_, zr, aac);
        }

        public Builder _000000000011110s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000111100_, BitStreamCode._0000000000111101_, zr, aac);
        }

        public Builder _000000000011111s(int zr, int aac) {
            return this.set(BitStreamCode._0000000000111110_, BitStreamCode._0000000000111111_, zr, aac);
        }

        public Builder _0000000000010000s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000100000, BitStreamCode._00000000000100001, zr, aac);
        }

        public Builder _0000000000010001s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000100010, BitStreamCode._00000000000100011, zr, aac);
        }

        public Builder _0000000000010010s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000100100, BitStreamCode._00000000000100101, zr, aac);
        }

        public Builder _0000000000010011s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000100110, BitStreamCode._00000000000100111, zr, aac);
        }

        public Builder _0000000000010100s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000101000, BitStreamCode._00000000000101001, zr, aac);
        }

        public Builder _0000000000010101s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000101010, BitStreamCode._00000000000101011, zr, aac);
        }

        public Builder _0000000000010110s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000101100, BitStreamCode._00000000000101101, zr, aac);
        }

        public Builder _0000000000010111s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000101110, BitStreamCode._00000000000101111, zr, aac);
        }

        public Builder _0000000000011000s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000110000, BitStreamCode._00000000000110001, zr, aac);
        }

        public Builder _0000000000011001s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000110010, BitStreamCode._00000000000110011, zr, aac);
        }

        public Builder _0000000000011010s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000110100, BitStreamCode._00000000000110101, zr, aac);
        }

        public Builder _0000000000011011s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000110110, BitStreamCode._00000000000110111, zr, aac);
        }

        public Builder _0000000000011100s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000111000, BitStreamCode._00000000000111001, zr, aac);
        }

        public Builder _0000000000011101s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000111010, BitStreamCode._00000000000111011, zr, aac);
        }

        public Builder _0000000000011110s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000111100, BitStreamCode._00000000000111101, zr, aac);
        }

        public Builder _0000000000011111s(int zr, int aac) {
            return this.set(BitStreamCode._00000000000111110, BitStreamCode._00000000000111111, zr, aac);
        }

        @Nonnull
        private Builder set(@Nonnull BitStreamCode positiveBitStreamCodeEndsWith0, @Nonnull BitStreamCode negitiveBitStreamCodeEndsWith1, int iZeroRunLength, int iAbsoluteAcCoefficient) {
            this.set(positiveBitStreamCodeEndsWith0, iZeroRunLength, iAbsoluteAcCoefficient);
            this.set(negitiveBitStreamCodeEndsWith1, iZeroRunLength, -iAbsoluteAcCoefficient);
            return this;
        }

        @Nonnull
        public ZeroRunLengthAcLookup build() {
            return new ZeroRunLengthAcLookup(this._aoList);
        }
    }
}

