/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.bitstreams.BitStreamCode;
import jpsxdec.psxvideo.mdec.MdecCode;

public class ZeroRunLengthAc {
    @Nonnull
    private final BitStreamCode _bitStreamCode;
    @CheckForNull
    private final MdecCode _mdecCode;
    private final boolean _blnIsEscapeCode;
    private final boolean _blnIsEndOfBlock;

    public ZeroRunLengthAc(@Nonnull BitStreamCode bitStreamCode, int iZeroRunLength, int iAcCoefficient) {
        this._bitStreamCode = bitStreamCode;
        this._mdecCode = new MdecCode(iZeroRunLength, iAcCoefficient);
        this._blnIsEscapeCode = false;
        this._blnIsEndOfBlock = false;
    }

    public ZeroRunLengthAc(@Nonnull BitStreamCode bitStreamCode, boolean blnIsEscapeCode, boolean blnIsEndOfBlock) {
        this(bitStreamCode, null, blnIsEscapeCode, blnIsEndOfBlock);
    }

    public ZeroRunLengthAc(@Nonnull BitStreamCode bitStreamCode, int iZeroRunLength, int iAcCoefficient, boolean blnIsEscapeCode, boolean blnIsEndOfBlock) {
        this(bitStreamCode, new MdecCode(iZeroRunLength, iAcCoefficient), blnIsEscapeCode, blnIsEndOfBlock);
    }

    private ZeroRunLengthAc(@Nonnull BitStreamCode bitStreamCode, @CheckForNull MdecCode mdecCode, boolean blnIsEscapeCode, boolean blnIsEndOfBlock) {
        if (blnIsEscapeCode && blnIsEndOfBlock) {
            throw new IllegalArgumentException("Only one of [escape code] or [end of block] can be true");
        }
        this._bitStreamCode = bitStreamCode;
        this._mdecCode = mdecCode;
        this._blnIsEscapeCode = blnIsEscapeCode;
        this._blnIsEndOfBlock = blnIsEndOfBlock;
    }

    public void getMdecCode(@Nonnull MdecCode out) {
        if (this._mdecCode == null) {
            throw new IllegalStateException("MDEC code requested from AC without code " + this);
        }
        out.setFrom(this._mdecCode);
    }

    @CheckForNull
    public MdecCode getMdecCodeCopy() {
        if (this._mdecCode == null) {
            return null;
        }
        return this._mdecCode.copy();
    }

    @Nonnull
    public BitStreamCode getBitStreamCode() {
        return this._bitStreamCode;
    }

    @Nonnull
    public String getBitString() {
        return this._bitStreamCode.getString();
    }

    public int getBitLength() {
        return this._bitStreamCode.getLength();
    }

    public boolean isIsEscapeCode() {
        return this._blnIsEscapeCode;
    }

    public boolean isIsEndOfBlock() {
        return this._blnIsEndOfBlock;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this._bitStreamCode);
        if (this._mdecCode != null) {
            sb.append(' ').append(this._mdecCode);
        }
        if (this._blnIsEscapeCode) {
            sb.append(" ESCAPE_CODE");
        }
        if (this._blnIsEndOfBlock) {
            sb.append(" END_OF_BLOCK");
        }
        return sb.toString();
    }

    public boolean equalsMdec(@Nonnull MdecCode code) {
        return this._mdecCode != null && this._mdecCode.equals(code);
    }
}

