/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import javax.annotation.Nonnull;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;

public abstract class StrHeader {
    public static final int SIZEOF = 8;
    private int _iQuantizationScale = -1;
    private int _iHalfMdecCodeCountCeil32 = -1;
    private int _iVersion = -1;
    private final boolean _blnIsValid;

    protected StrHeader(@Nonnull byte[] abFrameData, int iDataSize, int iExpectedVersion) {
        if (iDataSize < 8) {
            this._blnIsValid = false;
        } else {
            short iHalfMdecCodeCountCeil32 = IO.readSInt16LE(abFrameData, 0);
            int iMagic3800 = IO.readUInt16LE(abFrameData, 2);
            short iQscale = IO.readSInt16LE(abFrameData, 4);
            short iVersion = IO.readSInt16LE(abFrameData, 6);
            boolean bl = this._blnIsValid = iMagic3800 == 14336 && iQscale >= 1 && iVersion == iExpectedVersion && iHalfMdecCodeCountCeil32 >= 0;
            if (this._blnIsValid) {
                this._iQuantizationScale = iQscale;
                this._iHalfMdecCodeCountCeil32 = iHalfMdecCodeCountCeil32;
                this._iVersion = iVersion;
            }
        }
    }

    public int getQuantizationScale() {
        if (!this._blnIsValid) {
            throw new IllegalStateException();
        }
        return this._iQuantizationScale;
    }

    public int getHalfMdecCodeCountCeil32() {
        if (!this._blnIsValid) {
            throw new IllegalStateException();
        }
        return this._iHalfMdecCodeCountCeil32;
    }

    public boolean isValid() {
        return this._blnIsValid;
    }

    @Nonnull
    public BitStreamUncompressor makeNew(@Nonnull byte[] abBitstream) throws BinaryDataNotRecognized {
        return this.makeNew(abBitstream, abBitstream.length);
    }

    @Nonnull
    public abstract BitStreamUncompressor makeNew(@Nonnull byte[] var1, int var2) throws BinaryDataNotRecognized;

    public String toString() {
        if (this._blnIsValid) {
            return "Qscale " + this._iQuantizationScale + " count " + this._iHalfMdecCodeCountCeil32;
        }
        return "Invalid STR header";
    }
}

