/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.io.ByteArrayOutputStream;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.bitstreams.IByteOrder;

public class BitStreamWriter {
    private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();
    private int _iNextByteWrite = 0;
    private int _iBitIndex = 0;

    public void write(@Nonnull String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '0') {
                this.write(false);
                continue;
            }
            if (c == '1') {
                this.write(true);
                continue;
            }
            throw new IllegalArgumentException(s);
        }
    }

    public void write(boolean blnBit) {
        this._iNextByteWrite <<= 1;
        if (blnBit) {
            this._iNextByteWrite |= 1;
        }
        ++this._iBitIndex;
        if (this._iBitIndex == 8) {
            this._buffer.write(this._iNextByteWrite);
            this._iNextByteWrite = 0;
            this._iBitIndex = 0;
        }
    }

    public void write(long lngValue, int iBits) {
        if (iBits < 1 || iBits > 64) {
            throw new IllegalArgumentException("Invalid bit lengh to write " + iBits);
        }
        for (long lngMask = 1L << iBits - 1; lngMask != 0L; lngMask >>= 1) {
            this.write((lngValue & lngMask) != 0L);
        }
    }

    @Nonnull
    public byte[] toByteArray(@Nonnull IByteOrder byteOrder) {
        byte[] abBytes;
        int iSize;
        if (this._iBitIndex != 0) {
            this._iNextByteWrite <<= 8 - this._iBitIndex;
            this._buffer.write(this._iNextByteWrite);
        }
        if ((iSize = (abBytes = this._buffer.toByteArray()).length) % 2 != 0) {
            ++iSize;
        }
        byte[] abMappedBytes = new byte[iSize];
        for (int i = 0; i < abBytes.length; ++i) {
            abMappedBytes[byteOrder.getByteOffset((int)i)] = abBytes[i];
        }
        return abMappedBytes;
    }

    public void reset() {
        this._buffer.reset();
        this._iNextByteWrite = 0;
        this._iBitIndex = 0;
    }

    public int getBitsWritten() {
        return this._buffer.size() + this._iBitIndex;
    }
}

