/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.BitStreamWriter;
import jpsxdec.psxvideo.bitstreams.IBitStreamWith1QuantizationScale;
import jpsxdec.psxvideo.bitstreams.IByteOrder;
import jpsxdec.psxvideo.bitstreams.StrHeader;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup_STR;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IncompatibleException;
import jpsxdec.util.Misc;

public class BitStreamUncompressor_STRv3
extends BitStreamUncompressor
implements IBitStreamWith1QuantizationScale {
    private static final Logger LOG = Logger.getLogger(BitStreamUncompressor_STRv3.class.getName());
    public static final int DC_CHROMA_LONGEST_VARIABLE_LENGTH_CODE = 8;
    private static final DcVariableLengthCode[] DC_Chroma_VarLenCodes = new DcVariableLengthCode[]{new DcVlc0("00", 0, 0), new DcVlc_("01", 1, 1), new DcVlc_("10", 2, 2, 3), new DcVlc_("110", 3, 4, 7), new DcVlc_("1110", 4, 8, 15), new DcVlc_("11110", 5, 16, 31), new DcVlc_("111110", 6, 32, 63), new DcVlc_("1111110", 7, 64, 127), new DcVlc_("11111110", 8, 128, 255)};
    public static final int DC_LUMA_LONGEST_VARIABLE_LENGTH_CODE = 7;
    private static final DcVariableLengthCode[] DC_Luma_VarLenCodes = new DcVariableLengthCode[]{new DcVlc_("00", 1, 1), new DcVlc_("01", 2, 2, 3), new DcVlc0("100", 0, 0), new DcVlc_("101", 3, 4, 7), new DcVlc_("110", 4, 8, 15), new DcVlc_("1110", 5, 16, 31), new DcVlc_("11110", 6, 32, 63), new DcVlc_("111110", 7, 64, 127), new DcVlc_("1111110", 8, 128, 255)};
    private static final DcVariableLengthCode[] CHROMA_LOOKUP = new DcVariableLengthCode[256];
    private static final DcVariableLengthCode[] LUMA_LOOKUP = new DcVariableLengthCode[128];
    private static final String END_OF_FRAME_EXTRA_BITS = "1111111111";
    private static final int PADDING_BITS_LENGTH;
    private static final int b1111111111 = 1023;
    @Nonnull
    private final StrV3Header _header;
    public static final BitStreamUncompressor.IFrameEndPaddingBits FRAME_END_PADDING_BITS_STRV3;

    @Nonnull
    public static BitStreamUncompressor_STRv3 makeV3(@Nonnull byte[] abFrameData) throws BinaryDataNotRecognized {
        return BitStreamUncompressor_STRv3.makeV3(abFrameData, abFrameData.length);
    }

    @Nonnull
    public static BitStreamUncompressor_STRv3 makeV3(@Nonnull byte[] abFrameData, int iDataSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor_STRv3 bsu = BitStreamUncompressor_STRv3.makeV3NoThrow(abFrameData, iDataSize);
        if (bsu == null) {
            throw new BinaryDataNotRecognized();
        }
        return bsu;
    }

    @CheckForNull
    static BitStreamUncompressor_STRv3 makeV3NoThrow(@Nonnull byte[] abFrameData, int iDataSize) {
        StrV3Header header = new StrV3Header(abFrameData, iDataSize);
        if (!header.isValid()) {
            return null;
        }
        ArrayBitReader bitReader = BitStreamUncompressor_STRv2.makeStrBitReader(abFrameData, iDataSize);
        return new BitStreamUncompressor_STRv3(header, bitReader);
    }

    public BitStreamUncompressor_STRv3(@Nonnull StrV3Header header, @Nonnull ArrayBitReader bitReader) {
        super(bitReader, ZeroRunLengthAcLookup_STR.AC_VARIABLE_LENGTH_CODES_MPEG1, new QuantizationDcReader_STRv3(header.getQuantizationScale()), BitStreamUncompressor_STRv2.AC_ESCAPE_CODE_STR, FRAME_END_PADDING_BITS_STRV3);
        this._header = header;
    }

    @Override
    public int getQuantizationScale() {
        return this._header.getQuantizationScale();
    }

    @Override
    @Nonnull
    public BitStreamCompressor_STRv3 makeCompressor() {
        return new BitStreamCompressor_STRv3(this._context.getTotalMacroBlocksRead());
    }

    static {
        for (DcVariableLengthCode dcVlc : DC_Chroma_VarLenCodes) {
            dcVlc.fillLookupArray(CHROMA_LOOKUP, 8);
        }
        for (DcVariableLengthCode dcVlc : DC_Luma_VarLenCodes) {
            dcVlc.fillLookupArray(LUMA_LOOKUP, 7);
        }
        PADDING_BITS_LENGTH = END_OF_FRAME_EXTRA_BITS.length();
        FRAME_END_PADDING_BITS_STRV3 = new FrameEndPaddingBits_STRv3();
    }

    public static class BitStreamCompressor_STRv3
    extends BitStreamUncompressor_STRv2.BitStreamCompressor_STRv2 {
        private int _iPreviousCr_DcRound4;
        private int _iPreviousCb_DcRound4;
        private int _iPreviousY_DcRound4;

        public BitStreamCompressor_STRv3(int iMacroBlockCount) {
            this(iMacroBlockCount, BitStreamUncompressor_STRv2.LITTLE_ENDIAN_SHORT_ORDER);
        }

        protected BitStreamCompressor_STRv3(int iMacroBlockCount, @Nonnull IByteOrder byteOrder) {
            super(iMacroBlockCount, byteOrder);
        }

        @Override
        protected int getHeaderVersion() {
            return 3;
        }

        @Override
        protected int getFrameQscale(@Nonnull byte[] abFrameData) throws LocalizedIncompatibleException {
            StrV3Header header = new StrV3Header(abFrameData, abFrameData.length);
            if (!header.isValid()) {
                throw new LocalizedIncompatibleException(I.FRAME_IS_NOT_BITSTREAM_FORMAT("STRv3"));
            }
            return header.getQuantizationScale();
        }

        @Override
        @Nonnull
        public byte[] compress(@Nonnull MdecInputStream inStream) throws IncompatibleException, MdecException.EndOfStream, MdecException.ReadCorruption, MdecException.TooMuchEnergy {
            this._iPreviousY_DcRound4 = 0;
            this._iPreviousCb_DcRound4 = 0;
            this._iPreviousCr_DcRound4 = 0;
            return super.compress(inStream);
        }

        @Override
        @Nonnull
        protected String encodeDC(int iDC, @Nonnull MdecBlock block) throws MdecException.TooMuchEnergy {
            DcVariableLengthCode[] lookupTable;
            int iDcDiffRound4Div4;
            int iDcRound4 = (int)Math.round((double)iDC / 4.0) * 4;
            switch (block) {
                case Cr: {
                    iDcDiffRound4Div4 = (iDcRound4 - this._iPreviousCr_DcRound4) / 4;
                    this._iPreviousCr_DcRound4 = iDcRound4;
                    lookupTable = DC_Chroma_VarLenCodes;
                    break;
                }
                case Cb: {
                    iDcDiffRound4Div4 = (iDcRound4 - this._iPreviousCb_DcRound4) / 4;
                    this._iPreviousCb_DcRound4 = iDcRound4;
                    lookupTable = DC_Chroma_VarLenCodes;
                    break;
                }
                default: {
                    iDcDiffRound4Div4 = (iDcRound4 - this._iPreviousY_DcRound4) / 4;
                    this._iPreviousY_DcRound4 = iDcRound4;
                    lookupTable = DC_Luma_VarLenCodes;
                }
            }
            for (DcVariableLengthCode dcCodeBits : lookupTable) {
                String sEncodedBits = dcCodeBits.encode(iDcDiffRound4Div4);
                if (sEncodedBits == null) continue;
                return sEncodedBits;
            }
            throw new MdecException.TooMuchEnergy(String.format("Unable to compress DC value %d as diffed/4=%d", iDC, iDcDiffRound4Div4));
        }

        @Override
        protected void addTrailingBits(@Nonnull BitStreamWriter bitStream) {
            bitStream.write(BitStreamUncompressor_STRv3.END_OF_FRAME_EXTRA_BITS);
        }
    }

    private static class FrameEndPaddingBits_STRv3
    implements BitStreamUncompressor.IFrameEndPaddingBits {
        private FrameEndPaddingBits_STRv3() {
        }

        @Override
        public boolean skipPaddingBits(@Nonnull ArrayBitReader bitReader) throws MdecException.EndOfStream {
            int iPaddingBits = bitReader.readUnsignedBits(PADDING_BITS_LENGTH);
            if (iPaddingBits != 1023) {
                LOG.log(Level.WARNING, "Incorrect padding bits {0} should be {1}", new Object[]{Misc.bitsToString(iPaddingBits, PADDING_BITS_LENGTH), Misc.bitsToString(1023L, PADDING_BITS_LENGTH)});
                return false;
            }
            return true;
        }
    }

    public static class QuantizationDcReader_STRv3
    implements BitStreamUncompressor.IQuantizationDcReader {
        private final int _iFrameQuantizationScale;
        private int _iPreviousCr_DC = 0;
        private int _iPreviousCb_DC = 0;
        private int _iPreviousY_DC = 0;

        public QuantizationDcReader_STRv3(int iFrameQuantizationScale) {
            this._iFrameQuantizationScale = iFrameQuantizationScale;
        }

        @Override
        public void readQuantizationScaleAndDc(@Nonnull ArrayBitReader bitReader, @Nonnull MdecContext context, @Nonnull MdecCode code) throws MdecException.ReadCorruption, MdecException.EndOfStream {
            code.setTop6Bits(this._iFrameQuantizationScale);
            switch (context.getCurrentBlock()) {
                case Cr: {
                    this._iPreviousCr_DC = this.readV3DcChroma(this._iPreviousCr_DC, bitReader, context);
                    code.setBottom10Bits(this._iPreviousCr_DC);
                    return;
                }
                case Cb: {
                    this._iPreviousCb_DC = this.readV3DcChroma(this._iPreviousCb_DC, bitReader, context);
                    code.setBottom10Bits(this._iPreviousCb_DC);
                    return;
                }
            }
            this.readV3DcLuma(bitReader, context);
            code.setBottom10Bits(this._iPreviousY_DC);
        }

        private int readV3DcChroma(int iPreviousDC, @Nonnull ArrayBitReader bitReader, @Nonnull MdecContext context) throws MdecException.ReadCorruption, MdecException.EndOfStream {
            int iBits = bitReader.peekUnsignedBits(8);
            DcVariableLengthCode dcVlc = CHROMA_LOOKUP[iBits];
            if (dcVlc == null) {
                String s = "Unknown chroma DC variable length code: " + Misc.bitsToString(iBits, 8) + " at " + context;
                throw new MdecException.ReadCorruption(s);
            }
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(dcVlc.VariableLengthCode));
            bitReader.skipBits(dcVlc.VariableLengthCode.length());
            if ((iPreviousDC += dcVlc.readDc(bitReader)) < -512 || iPreviousDC > 511) {
                throw new MdecException.ReadCorruption(MdecException.STRV3_BLOCK_UNCOMPRESS_ERR_CHROMA_DC_OOB(context.getTotalMacroBlocksRead(), context.getCurrentBlock().ordinal(), iPreviousDC));
            }
            return iPreviousDC;
        }

        private void readV3DcLuma(@Nonnull ArrayBitReader bitReader, @Nonnull MdecContext context) throws MdecException.ReadCorruption, MdecException.EndOfStream {
            int iBits = bitReader.peekUnsignedBits(7);
            DcVariableLengthCode dcVlc = LUMA_LOOKUP[iBits];
            if (dcVlc == null) {
                throw new MdecException.ReadCorruption(MdecException.STRV3_BLOCK_UNCOMPRESS_ERR_UNKNOWN_LUMA_DC_VLC(context.getTotalMacroBlocksRead(), context.getCurrentBlock().ordinal(), Misc.bitsToString(iBits, 7)));
            }
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(dcVlc.VariableLengthCode));
            bitReader.skipBits(dcVlc.VariableLengthCode.length());
            this._iPreviousY_DC += dcVlc.readDc(bitReader);
            if (this._iPreviousY_DC < -512 || this._iPreviousY_DC > 511) {
                throw new MdecException.ReadCorruption(MdecException.STRV3_BLOCK_UNCOMPRESS_ERR_LUMA_DC_OOB(context.getTotalMacroBlocksRead(), context.getCurrentBlock().ordinal(), this._iPreviousY_DC));
            }
        }
    }

    private static class DcVlc_
    extends DcVariableLengthCode {
        private final int _iNegativeDifferentialMin;
        private final int _iNegativeDifferentialMax;
        private final int _iPositiveDifferentialMin;
        private final int _iPositiveDifferentialMax;
        private final int _iTopBitMask;

        public DcVlc_(@Nonnull String sCode, int iDifferentialBitLen, int iPositiveDifferential) {
            this(sCode, iDifferentialBitLen, iPositiveDifferential, iPositiveDifferential);
        }

        public DcVlc_(@Nonnull String sCode, int iDifferentialBitLen, int iPositiveDifferentialMin, int iPositiveDifferentialMax) {
            super(sCode, iDifferentialBitLen);
            this._iPositiveDifferentialMin = iPositiveDifferentialMin;
            this._iPositiveDifferentialMax = iPositiveDifferentialMax;
            this._iNegativeDifferentialMin = -iPositiveDifferentialMax;
            this._iNegativeDifferentialMax = -iPositiveDifferentialMin;
            this._iTopBitMask = 1 << iDifferentialBitLen - 1;
        }

        @Override
        public int readDc(@Nonnull ArrayBitReader bitReader) throws MdecException.EndOfStream {
            int iDC_Differential = bitReader.readUnsignedBits(this._iDifferentialBitLen);
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(iDC_Differential, this._iDifferentialBitLen)));
            if ((iDC_Differential & this._iTopBitMask) == 0) {
                iDC_Differential += this._iNegativeDifferentialMin;
            }
            return iDC_Differential * 4;
        }

        @Override
        @CheckForNull
        public String encode(int iDCdiffFromPrevDiv4) {
            if (iDCdiffFromPrevDiv4 >= this._iNegativeDifferentialMin && iDCdiffFromPrevDiv4 <= this._iNegativeDifferentialMax) {
                return this.VariableLengthCode + Misc.bitsToString(iDCdiffFromPrevDiv4 - this._iNegativeDifferentialMin, this._iDifferentialBitLen);
            }
            if (iDCdiffFromPrevDiv4 >= this._iPositiveDifferentialMin && iDCdiffFromPrevDiv4 <= this._iPositiveDifferentialMax) {
                return this.VariableLengthCode + Misc.bitsToString(iDCdiffFromPrevDiv4, this._iDifferentialBitLen);
            }
            return null;
        }
    }

    private static class DcVlc0
    extends DcVariableLengthCode {
        private final int _iDifferential;

        public DcVlc0(@Nonnull String sCode, int iDifferentialBitLen, int iDifferential) {
            super(sCode, iDifferentialBitLen);
            if (iDifferentialBitLen != 0) {
                throw new IllegalArgumentException();
            }
            this._iDifferential = iDifferential;
        }

        @Override
        public int readDc(@Nonnull ArrayBitReader bitReader) {
            return this._iDifferential;
        }

        @Override
        @CheckForNull
        public String encode(int i) {
            if (i == this._iDifferential) {
                return this.VariableLengthCode;
            }
            return null;
        }
    }

    private static abstract class DcVariableLengthCode {
        @Nonnull
        public final String VariableLengthCode;
        protected final int _iDifferentialBitLen;

        public DcVariableLengthCode(@Nonnull String sCode, int iDifferentialBitLen) {
            this.VariableLengthCode = sCode;
            this._iDifferentialBitLen = iDifferentialBitLen;
        }

        public void fillLookupArray(@Nonnull DcVariableLengthCode[] aoLookup, int iLongestCode) {
            int iUnimportantBits = iLongestCode - this.VariableLengthCode.length();
            int iStart = Integer.parseInt(this.VariableLengthCode + Misc.dup('0', iUnimportantBits), 2);
            int iEnd = Integer.parseInt(this.VariableLengthCode + Misc.dup('1', iUnimportantBits), 2);
            for (int i = iStart; i <= iEnd; ++i) {
                if (aoLookup[i] != null) {
                    throw new IllegalStateException("Lookup table " + i + " is not null.");
                }
                aoLookup[i] = this;
            }
        }

        public abstract int readDc(@Nonnull ArrayBitReader var1) throws MdecException.EndOfStream;

        @CheckForNull
        public abstract String encode(int var1);
    }

    public static class StrV3Header
    extends StrHeader {
        public StrV3Header(@Nonnull byte[] abFrameData, int iDataSize) {
            super(abFrameData, iDataSize, 3);
        }

        @Override
        @Nonnull
        public BitStreamUncompressor_STRv3 makeNew(@Nonnull byte[] abBitstream, int iBitstreamSize) throws BinaryDataNotRecognized {
            return BitStreamUncompressor_STRv3.makeV3(abBitstream, iBitstreamSize);
        }
    }
}

