/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamCompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamWriter;
import jpsxdec.psxvideo.bitstreams.IBitStreamWith1QuantizationScale;
import jpsxdec.psxvideo.bitstreams.IByteOrder;
import jpsxdec.psxvideo.bitstreams.StrHeader;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAc;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup_STR;
import jpsxdec.psxvideo.encode.MacroBlockEncoder;
import jpsxdec.psxvideo.encode.MdecEncoder;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;
import jpsxdec.util.Misc;

public class BitStreamUncompressor_STRv2
extends BitStreamUncompressor
implements IBitStreamWith1QuantizationScale {
    private static final Logger LOG = Logger.getLogger(BitStreamUncompressor_STRv2.class.getName());
    private static final String END_OF_FRAME_EXTRA_BITS = "0111111111";
    private static final int PADDING_BITS_LENGTH = "0111111111".length();
    private static final int b0111111111 = 511;
    public static final IByteOrder LITTLE_ENDIAN_SHORT_ORDER = new IByteOrder(){

        @Override
        public int getByteOffset(int iByteIndex) {
            return iByteIndex ^ 1;
        }
    };
    @Nonnull
    private final StrV2Header _header;
    public static final BitStreamUncompressor.IAcEscapeCode AC_ESCAPE_CODE_STR = new AcEscapeCode_STR();
    public static final BitStreamUncompressor.IFrameEndPaddingBits FRAME_END_PADDING_BITS_STRV2 = new FrameEndPaddingBits_STRv2();

    @Nonnull
    public static BitStreamUncompressor_STRv2 makeV2(@Nonnull byte[] abBitstream) throws BinaryDataNotRecognized {
        return BitStreamUncompressor_STRv2.makeV2(abBitstream, abBitstream.length);
    }

    @Nonnull
    public static BitStreamUncompressor_STRv2 makeV2(@Nonnull byte[] abBitstream, int iDataSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor_STRv2 bsu = BitStreamUncompressor_STRv2.makeV2NoThrow(abBitstream, iDataSize);
        if (bsu == null) {
            throw new BinaryDataNotRecognized();
        }
        return bsu;
    }

    @CheckForNull
    static BitStreamUncompressor_STRv2 makeV2NoThrow(@Nonnull byte[] abBitstream, int iDataSize) {
        StrV2Header header = new StrV2Header(abBitstream, iDataSize);
        if (!header.isValid()) {
            return null;
        }
        ArrayBitReader bitReader = BitStreamUncompressor_STRv2.makeStrBitReader(abBitstream, iDataSize);
        return new BitStreamUncompressor_STRv2(header, bitReader);
    }

    @Nonnull
    public static ArrayBitReader makeStrBitReader(@Nonnull byte[] abBitstream, int iDataSize) {
        return new ArrayBitReader(abBitstream, LITTLE_ENDIAN_SHORT_ORDER, 8, iDataSize);
    }

    private BitStreamUncompressor_STRv2(@Nonnull StrV2Header header, @Nonnull ArrayBitReader bitReader) {
        super(bitReader, ZeroRunLengthAcLookup_STR.AC_VARIABLE_LENGTH_CODES_MPEG1, new QuantizationDcReader_STRv12(header.getQuantizationScale()), AC_ESCAPE_CODE_STR, FRAME_END_PADDING_BITS_STRV2);
        this._header = header;
    }

    @Override
    public int getQuantizationScale() {
        return this._header.getQuantizationScale();
    }

    @Override
    public String toString() {
        return super.toString() + " Qscale=" + this._header.getQuantizationScale();
    }

    @Override
    @Nonnull
    public BitStreamCompressor_STRv2 makeCompressor() {
        return new BitStreamCompressor_STRv2(this._context.getTotalMacroBlocksRead(), LITTLE_ENDIAN_SHORT_ORDER);
    }

    public static class BitStreamCompressor_STRv2
    implements BitStreamCompressor {
        private final int _iMacroBlockCount;
        private int _iQscale;
        private int _iMdecCodeCount;
        @Nonnull
        private final IByteOrder _byteOrder;

        public BitStreamCompressor_STRv2(int iMacroBlockCount, @Nonnull IByteOrder byteOrder) {
            this._iMacroBlockCount = iMacroBlockCount;
            this._byteOrder = byteOrder;
        }

        @Override
        @CheckForNull
        public byte[] compressFull(int iMaxSize, @Nonnull String sFrameDescription, @Nonnull MdecEncoder encoder, @Nonnull ILocalizedLogger log) throws MdecException.EndOfStream, MdecException.ReadCorruption {
            for (int iQscale = 1; iQscale < 64; ++iQscale) {
                byte[] abNewDemux;
                log.log(Level.INFO, I.TRYING_QSCALE(iQscale));
                int[] aiNewQscale = new int[]{iQscale, iQscale, iQscale, iQscale, iQscale, iQscale};
                for (MacroBlockEncoder macblk : encoder) {
                    macblk.setToFullEncode(aiNewQscale);
                }
                try {
                    abNewDemux = this.compress(encoder.getStream());
                }
                catch (IncompatibleException ex) {
                    throw new RuntimeException("The encoder should be compatible here", ex);
                }
                catch (MdecException.TooMuchEnergy ex) {
                    throw new RuntimeException("This should not happen with STRv2", ex);
                }
                if (abNewDemux.length <= iMaxSize) {
                    log.log(Level.INFO, I.NEW_FRAME_FITS(sFrameDescription, abNewDemux.length, iMaxSize));
                    return abNewDemux;
                }
                log.log(Level.INFO, I.NEW_FRAME_DOES_NOT_FIT(sFrameDescription, abNewDemux.length, iMaxSize));
            }
            return null;
        }

        @Override
        @CheckForNull
        public byte[] compressPartial(@Nonnull byte[] abOriginal, @Nonnull String sFrameDescription, @Nonnull MdecEncoder encoder, @Nonnull ILocalizedLogger log) throws LocalizedIncompatibleException, MdecException.EndOfStream, MdecException.ReadCorruption {
            int iFrameQscale = this.getFrameQscale(abOriginal);
            int[] aiOriginalQscale = new int[]{iFrameQscale, iFrameQscale, iFrameQscale, iFrameQscale, iFrameQscale, iFrameQscale};
            for (int iNewQscale = iFrameQscale; iNewQscale < 64; ++iNewQscale) {
                byte[] abNewDemux;
                log.log(Level.INFO, I.TRYING_QSCALE(iNewQscale));
                int[] aiNewQscale = new int[]{iNewQscale, iNewQscale, iNewQscale, iNewQscale, iNewQscale, iNewQscale};
                for (MacroBlockEncoder macblk : encoder) {
                    macblk.setToPartialEncode(aiOriginalQscale, aiNewQscale);
                }
                try {
                    abNewDemux = this.compress(encoder.getStream());
                }
                catch (IncompatibleException ex) {
                    throw new RuntimeException("The encoder should be compatible here", ex);
                }
                catch (MdecException.TooMuchEnergy ex) {
                    throw new RuntimeException("This should not happen with STRv2", ex);
                }
                if (abNewDemux.length <= abOriginal.length) {
                    log.log(Level.INFO, I.NEW_FRAME_FITS(sFrameDescription, abNewDemux.length, abOriginal.length));
                    return abNewDemux;
                }
                log.log(Level.INFO, I.NEW_FRAME_DOES_NOT_FIT(sFrameDescription, abNewDemux.length, abOriginal.length));
            }
            return null;
        }

        @Override
        @Nonnull
        public byte[] compress(@Nonnull MdecInputStream inStream) throws IncompatibleException, MdecException.EndOfStream, MdecException.ReadCorruption, MdecException.TooMuchEnergy {
            this._iMdecCodeCount = -1;
            this._iQscale = -1;
            BitStreamWriter bitStream = new BitStreamWriter();
            MdecCode code = new MdecCode();
            MdecContext context = new MdecContext();
            while (context.getTotalMacroBlocksRead() < this._iMacroBlockCount) {
                String sBitsToWrite;
                boolean blnEod = inStream.readMdecCode(code);
                if (!code.isValid()) {
                    throw new MdecException.ReadCorruption("Invalid MDEC code " + code);
                }
                if (blnEod) {
                    sBitsToWrite = ZeroRunLengthAcLookup_STR.END_OF_BLOCK.getBitString();
                    context.nextCodeEndBlock();
                } else {
                    if (context.atStartOfBlock()) {
                        this.setBlockQscale(context.getCurrentBlock(), code.getTop6Bits());
                        sBitsToWrite = this.encodeDC(code.getBottom10Bits(), context.getCurrentBlock());
                    } else {
                        sBitsToWrite = this.encodeAC(code);
                    }
                    context.nextCode();
                }
                if (BitStreamDebugging.DEBUG) {
                    System.out.println("Converting " + code.toString() + " to " + sBitsToWrite + " at bit " + bitStream.getBitsWritten());
                }
                bitStream.write(sBitsToWrite);
            }
            if (!context.atStartOfBlock()) {
                throw new IllegalStateException("Ended compressing in the middle of a macroblock.");
            }
            this.addTrailingBits(bitStream);
            byte[] abBitstream = bitStream.toByteArray(this._byteOrder);
            byte[] abHeader = this.createHeader(context.getTotalMdecCodesRead());
            byte[] abReturn = new byte[abHeader.length + abBitstream.length];
            System.arraycopy(abHeader, 0, abReturn, 0, abHeader.length);
            System.arraycopy(abBitstream, 0, abReturn, abHeader.length, abBitstream.length);
            this._iMdecCodeCount = context.getTotalMdecCodesRead();
            return abReturn;
        }

        @Override
        public int getMdecCodesFromLastCompress() {
            return this._iMdecCodeCount;
        }

        protected void addTrailingBits(@Nonnull BitStreamWriter bitStream) {
            bitStream.write(BitStreamUncompressor_STRv2.END_OF_FRAME_EXTRA_BITS);
        }

        protected void setBlockQscale(@Nonnull MdecBlock block, int iQscale) throws IncompatibleException {
            if (this._iQscale < 0) {
                this._iQscale = iQscale;
            } else if (this._iQscale != iQscale) {
                throw new IncompatibleException(String.format("Inconsistent qscale scale: current %d != new %d", this._iQscale, iQscale));
            }
        }

        @Nonnull
        protected String encodeDC(int iDC, @Nonnull MdecBlock block) throws MdecException.TooMuchEnergy {
            if (iDC < -512 || iDC > 511) {
                throw new IllegalArgumentException("Invalid DC code " + iDC);
            }
            return Misc.bitsToString(iDC, 10);
        }

        private String encodeAC(@Nonnull MdecCode code) throws MdecException.TooMuchEnergy {
            if (!code.isValid()) {
                throw new IllegalArgumentException("Invalid MDEC code " + code);
            }
            for (ZeroRunLengthAc vlc : this.getAcVaribleLengthCodeList()) {
                if (!vlc.equalsMdec(code)) continue;
                return vlc.getBitString();
            }
            return this.encodeAcEscape(code);
        }

        @Nonnull
        protected ZeroRunLengthAcLookup getAcVaribleLengthCodeList() {
            return ZeroRunLengthAcLookup_STR.AC_VARIABLE_LENGTH_CODES_MPEG1;
        }

        @Nonnull
        protected String encodeAcEscape(@Nonnull MdecCode code) throws MdecException.TooMuchEnergy {
            if (!code.isValid()) {
                throw new IllegalArgumentException("Invalid MDEC code " + code);
            }
            return ZeroRunLengthAcLookup_STR.ESCAPE_CODE.getBitString() + Misc.bitsToString(code.getTop6Bits(), 6) + Misc.bitsToString(code.getBottom10Bits(), 10);
        }

        @Nonnull
        protected byte[] createHeader(int iMdecCodeCount) {
            byte[] ab = new byte[8];
            IO.writeInt16LE(ab, 0, Calc.calculateHalfCeiling32(iMdecCodeCount));
            IO.writeInt16LE(ab, 2, (short)14336);
            IO.writeInt16LE(ab, 4, (short)this._iQscale);
            IO.writeInt16LE(ab, 6, (short)this.getHeaderVersion());
            return ab;
        }

        protected int getHeaderVersion() {
            return 2;
        }

        protected int getFrameQscale(@Nonnull byte[] abFrameData) throws LocalizedIncompatibleException {
            StrV2Header header = new StrV2Header(abFrameData, abFrameData.length);
            if (!header.isValid()) {
                throw new LocalizedIncompatibleException(I.FRAME_IS_NOT_BITSTREAM_FORMAT("STRv2"));
            }
            return header.getQuantizationScale();
        }
    }

    private static class FrameEndPaddingBits_STRv2
    implements BitStreamUncompressor.IFrameEndPaddingBits {
        private FrameEndPaddingBits_STRv2() {
        }

        @Override
        public boolean skipPaddingBits(@Nonnull ArrayBitReader bitReader) throws MdecException.EndOfStream {
            int iPaddingBits = bitReader.readUnsignedBits(PADDING_BITS_LENGTH);
            if (iPaddingBits != 511) {
                LOG.log(Level.WARNING, "Incorrect padding bits {0} should be {1}", new Object[]{Misc.bitsToString(iPaddingBits, PADDING_BITS_LENGTH), Misc.bitsToString(511L, PADDING_BITS_LENGTH)});
                return false;
            }
            return true;
        }
    }

    private static class AcEscapeCode_STR
    implements BitStreamUncompressor.IAcEscapeCode {
        private AcEscapeCode_STR() {
        }

        @Override
        public void readAcEscapeCode(@Nonnull ArrayBitReader bitReader, @Nonnull MdecCode code) throws MdecException.EndOfStream {
            int iRunAndAc = bitReader.readUnsignedBits(16);
            code.set(iRunAndAc);
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(iRunAndAc, 16)));
        }
    }

    public static class QuantizationDcReader_STRv12
    implements BitStreamUncompressor.IQuantizationDcReader {
        private final int _iFrameQuantizationScale;

        public QuantizationDcReader_STRv12(int iFrameQuantizationScale) {
            this._iFrameQuantizationScale = iFrameQuantizationScale;
        }

        @Override
        public void readQuantizationScaleAndDc(@Nonnull ArrayBitReader bitReader, @Nonnull MdecContext context, @Nonnull MdecCode code) throws MdecException.ReadCorruption, MdecException.EndOfStream {
            code.setTop6Bits(this._iFrameQuantizationScale);
            code.setBottom10Bits(bitReader.readSignedBits(10));
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(code.getBottom10Bits(), 10)));
            assert (!code.isEOD());
        }
    }

    public static class StrV2Header
    extends StrHeader {
        public StrV2Header(@Nonnull byte[] abFrameData, int iDataSize) {
            super(abFrameData, iDataSize, 2);
        }

        @Override
        @Nonnull
        public BitStreamUncompressor_STRv2 makeNew(@Nonnull byte[] abBitstream, int iBitstreamSize) throws BinaryDataNotRecognized {
            return BitStreamUncompressor_STRv2.makeV2(abBitstream, iBitstreamSize);
        }
    }
}

