/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.IBitStreamWith1QuantizationScale;
import jpsxdec.psxvideo.bitstreams.StrHeader;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup_STR;
import jpsxdec.util.BinaryDataNotRecognized;

public class BitStreamUncompressor_STRv1
extends BitStreamUncompressor
implements IBitStreamWith1QuantizationScale {
    @Nonnull
    private final StrV1Header _header;

    @Nonnull
    public static BitStreamUncompressor_STRv1 makeV1(@Nonnull byte[] abFrameData) throws BinaryDataNotRecognized {
        return BitStreamUncompressor_STRv1.makeV1(abFrameData, abFrameData.length);
    }

    @Nonnull
    public static BitStreamUncompressor_STRv1 makeV1(@Nonnull byte[] abFrameData, int iDataSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor_STRv1 bsu = BitStreamUncompressor_STRv1.makeV1NoThrow(abFrameData, iDataSize);
        if (bsu == null) {
            throw new BinaryDataNotRecognized();
        }
        return bsu;
    }

    @CheckForNull
    static BitStreamUncompressor_STRv1 makeV1NoThrow(@Nonnull byte[] abFrameData, int iDataSize) {
        StrV1Header header = new StrV1Header(abFrameData, iDataSize);
        if (!header.isValid()) {
            return null;
        }
        ArrayBitReader bitReader = BitStreamUncompressor_STRv2.makeStrBitReader(abFrameData, iDataSize);
        return new BitStreamUncompressor_STRv1(header, bitReader);
    }

    public BitStreamUncompressor_STRv1(@Nonnull StrV1Header header, @Nonnull ArrayBitReader bitReader) {
        super(bitReader, ZeroRunLengthAcLookup_STR.AC_VARIABLE_LENGTH_CODES_MPEG1, new BitStreamUncompressor_STRv2.QuantizationDcReader_STRv12(header.getQuantizationScale()), BitStreamUncompressor_STRv2.AC_ESCAPE_CODE_STR, BitStreamUncompressor_STRv2.FRAME_END_PADDING_BITS_STRV2);
        this._header = header;
    }

    @Override
    public int getQuantizationScale() {
        return this._header.getQuantizationScale();
    }

    @Override
    @Nonnull
    public BitStreamCompressor_STRv1 makeCompressor() {
        return new BitStreamCompressor_STRv1(this._context.getTotalMacroBlocksRead());
    }

    public static class BitStreamCompressor_STRv1
    extends BitStreamUncompressor_STRv2.BitStreamCompressor_STRv2 {
        private BitStreamCompressor_STRv1(int iMacroBlockCount) {
            super(iMacroBlockCount, BitStreamUncompressor_STRv2.LITTLE_ENDIAN_SHORT_ORDER);
        }

        @Override
        protected int getHeaderVersion() {
            return 1;
        }

        @Override
        protected int getFrameQscale(@Nonnull byte[] abFrameData) throws LocalizedIncompatibleException {
            StrV1Header header = new StrV1Header(abFrameData, abFrameData.length);
            if (!header.isValid()) {
                throw new LocalizedIncompatibleException(I.FRAME_IS_NOT_BITSTREAM_FORMAT("STRv1"));
            }
            return header.getQuantizationScale();
        }
    }

    public static class StrV1Header
    extends StrHeader {
        public StrV1Header(byte[] abFrameData, int iDataSize) {
            super(abFrameData, iDataSize, 1);
        }

        @Override
        @Nonnull
        public BitStreamUncompressor_STRv1 makeNew(@Nonnull byte[] abBitstream, int iBitstreamSize) throws BinaryDataNotRecognized {
            return BitStreamUncompressor_STRv1.makeV1(abBitstream, iBitstreamSize);
        }
    }
}

