/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamCode;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.BitStreamWriter;
import jpsxdec.psxvideo.bitstreams.IByteOrder;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAc;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup;
import jpsxdec.psxvideo.encode.MacroBlockEncoder;
import jpsxdec.psxvideo.encode.MdecEncoder;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;
import jpsxdec.util.Misc;

public class BitStreamUncompressor_Lain
extends BitStreamUncompressor {
    public static final IByteOrder BIG_ENDIAN_ORDER = new IByteOrder(){

        @Override
        public int getByteOffset(int iByteIndex) {
            return iByteIndex;
        }
    };
    public static final ZeroRunLengthAc ESCAPE_CODE = new ZeroRunLengthAc(BitStreamCode._000001___________, true, false);
    public static final ZeroRunLengthAc END_OF_BLOCK = new ZeroRunLengthAc(BitStreamCode._10_______________, 63, -512, false, true);
    private static final ZeroRunLengthAcLookup AC_VARIABLE_LENGTH_CODES_LAIN = new ZeroRunLengthAcLookup.Builder()._11s(0, 1)._011s(0, 2)._0100s(1, 1)._0101s(0, 3)._00101s(0, 4)._00110s(2, 1)._00111s(0, 5)._000100s(0, 6)._000101s(3, 1)._000110s(1, 2)._000111s(0, 7)._0000100s(0, 8)._0000101s(4, 1)._0000110s(0, 9)._0000111s(5, 1)._00100000s(0, 10)._00100001s(0, 11)._00100010s(1, 3)._00100011s(6, 1)._00100100s(0, 12)._00100101s(0, 13)._00100110s(7, 1)._00100111s(0, 14)._0000001000s(0, 15)._0000001001s(2, 2)._0000001010s(8, 1)._0000001011s(1, 4)._0000001100s(0, 16)._0000001101s(0, 17)._0000001110s(9, 1)._0000001111s(0, 18)._000000010000s(0, 19)._000000010001s(1, 5)._000000010010s(0, 20)._000000010011s(10, 1)._000000010100s(0, 21)._000000010101s(3, 2)._000000010110s(12, 1)._000000010111s(0, 23)._000000011000s(0, 22)._000000011001s(11, 1)._000000011010s(0, 24)._000000011011s(0, 28)._000000011100s(0, 25)._000000011101s(1, 6)._000000011110s(2, 3)._000000011111s(0, 27)._0000000010000s(0, 26)._0000000010001s(13, 1)._0000000010010s(0, 29)._0000000010011s(1, 7)._0000000010100s(4, 2)._0000000010101s(0, 31)._0000000010110s(0, 30)._0000000010111s(14, 1)._0000000011000s(0, 32)._0000000011001s(0, 33)._0000000011010s(1, 8)._0000000011011s(0, 35)._0000000011100s(0, 34)._0000000011101s(5, 2)._0000000011110s(0, 36)._0000000011111s(0, 37)._00000000010000s(2, 4)._00000000010001s(1, 9)._00000000010010s(1, 24)._00000000010011s(0, 38)._00000000010100s(15, 1)._00000000010101s(0, 39)._00000000010110s(3, 3)._00000000010111s(7, 3)._00000000011000s(0, 40)._00000000011001s(0, 41)._00000000011010s(0, 42)._00000000011011s(0, 43)._00000000011100s(1, 10)._00000000011101s(0, 44)._00000000011110s(6, 2)._00000000011111s(0, 45)._000000000010000s(0, 47)._000000000010001s(0, 46)._000000000010010s(16, 1)._000000000010011s(2, 5)._000000000010100s(0, 48)._000000000010101s(1, 11)._000000000010110s(0, 49)._000000000010111s(0, 51)._000000000011000s(0, 50)._000000000011001s(7, 2)._000000000011010s(0, 52)._000000000011011s(4, 3)._000000000011100s(0, 53)._000000000011101s(17, 1)._000000000011110s(1, 12)._000000000011111s(0, 55)._0000000000010000s(0, 54)._0000000000010001s(0, 56)._0000000000010010s(0, 57)._0000000000010011s(21, 1)._0000000000010100s(0, 58)._0000000000010101s(3, 4)._0000000000010110s(1, 13)._0000000000010111s(23, 1)._0000000000011000s(8, 2)._0000000000011001s(0, 59)._0000000000011010s(2, 6)._0000000000011011s(19, 1)._0000000000011100s(0, 60)._0000000000011101s(9, 2)._0000000000011110s(24, 1)._0000000000011111s(18, 1).add(ESCAPE_CODE).add(END_OF_BLOCK).build();
    @Nonnull
    private final LainHeader _header;
    private static final AcEscapeCode_Lain AC_ESCAPE_CODE_LAIN = new AcEscapeCode_Lain();
    private static final double LUMA_TO_CHROMA_RATIO = 2.0;

    @Nonnull
    public static BitStreamUncompressor_Lain makeLain(@Nonnull byte[] abFrameData) throws BinaryDataNotRecognized {
        return BitStreamUncompressor_Lain.makeLain(abFrameData, abFrameData.length);
    }

    @Nonnull
    public static BitStreamUncompressor_Lain makeLain(@Nonnull byte[] abFrameData, int iDataSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor_Lain bsu = BitStreamUncompressor_Lain.makeLainNoThrow(abFrameData, iDataSize);
        if (bsu == null) {
            throw new BinaryDataNotRecognized();
        }
        return bsu;
    }

    @CheckForNull
    public static BitStreamUncompressor_Lain makeLainNoThrow(@Nonnull byte[] abFrameData, int iDataSize) {
        LainHeader header = new LainHeader(abFrameData, iDataSize);
        if (!header.isValid()) {
            return null;
        }
        ArrayBitReader bitReader = new ArrayBitReader(abFrameData, BIG_ENDIAN_ORDER, 8, iDataSize);
        return new BitStreamUncompressor_Lain(header, bitReader);
    }

    public BitStreamUncompressor_Lain(@Nonnull LainHeader header, @Nonnull ArrayBitReader bitReader) {
        super(bitReader, AC_VARIABLE_LENGTH_CODES_LAIN, new QuantizationDcReader_Lain(header.getLumaQscale(), header.getChromaQscale()), AC_ESCAPE_CODE_LAIN, FRAME_END_PADDING_BITS_NONE);
        this._header = header;
    }

    public int getLumaQscale() {
        return this._header.getLumaQscale();
    }

    public int getChromaQscale() {
        return this._header.getChromaQscale();
    }

    @Override
    public String toString() {
        return super.toString() + " Qscale L=" + this._header.getLumaQscale() + " C=" + this._header.getChromaQscale();
    }

    @Override
    @Nonnull
    public BitStreamCompressor_Lain makeCompressor() {
        return new BitStreamCompressor_Lain(this._context.getTotalMacroBlocksRead(), this._header.getMagic3800orFrame());
    }

    public static class BitStreamCompressor_Lain
    extends BitStreamUncompressor_STRv2.BitStreamCompressor_STRv2 {
        private final int _iMagic3800orFrame;
        private int _iLumaQscale;
        private int _iChromaQscale;

        public BitStreamCompressor_Lain(int iMacroBlockCount, int iMagic3800orFrame) {
            super(iMacroBlockCount, BIG_ENDIAN_ORDER);
            this._iMagic3800orFrame = iMagic3800orFrame;
        }

        @Override
        @CheckForNull
        public byte[] compressFull(int iMaxSize, @Nonnull String sFrameDescription, @Nonnull MdecEncoder encoder, @Nonnull ILocalizedLogger log) throws MdecException.EndOfStream, MdecException.ReadCorruption {
            int iLQscale = 1;
            int iCQscale = 1;
            while (iLQscale < 64 && iCQscale < 64) {
                log.log(Level.INFO, I.TRYING_LUMA_CHROMA(iLQscale, iCQscale));
                int[] aiNewQscale = new int[]{iCQscale, iCQscale, iLQscale, iLQscale, iLQscale, iLQscale};
                for (MacroBlockEncoder macblk : encoder) {
                    macblk.setToFullEncode(aiNewQscale);
                }
                try {
                    byte[] abNewDemux;
                    try {
                        abNewDemux = this.compress(encoder.getStream());
                    }
                    catch (IncompatibleException ex) {
                        throw new RuntimeException("The encoder should be compatible here", ex);
                    }
                    int iNewDemuxSize = abNewDemux.length;
                    if (iNewDemuxSize <= iMaxSize) {
                        log.log(Level.INFO, I.NEW_FRAME_FITS(sFrameDescription, iNewDemuxSize, iMaxSize));
                        return abNewDemux;
                    }
                    log.log(Level.INFO, I.NEW_FRAME_DOES_NOT_FIT(sFrameDescription, iNewDemuxSize, iMaxSize));
                }
                catch (MdecException.TooMuchEnergy ex) {
                    log.log(Level.INFO, I.COMPRESS_TOO_MUCH_ENERGY(sFrameDescription), ex);
                }
                if ((double)iLQscale / (double)iCQscale < 2.0) {
                    ++iLQscale;
                    continue;
                }
                ++iCQscale;
            }
            return null;
        }

        @Override
        @CheckForNull
        public byte[] compressPartial(@Nonnull byte[] abOriginal, @Nonnull String sFrameDescription, @Nonnull MdecEncoder encoder, @Nonnull ILocalizedLogger log) throws LocalizedIncompatibleException, MdecException.EndOfStream, MdecException.ReadCorruption {
            LainHeader header = new LainHeader(abOriginal, abOriginal.length);
            if (!header.isValid()) {
                throw new LocalizedIncompatibleException(I.FRAME_IS_NOT_BITSTREAM_FORMAT("Lain"));
            }
            int iFrameLQscale = header.getLumaQscale();
            int iFrameCQscale = header.getChromaQscale();
            int[] aiOriginalQscale = new int[]{iFrameCQscale, iFrameCQscale, iFrameLQscale, iFrameLQscale, iFrameLQscale, iFrameLQscale};
            int iLQscale = iFrameLQscale;
            int iCQscale = iFrameCQscale;
            while (iLQscale < 64 && iCQscale < 64) {
                log.log(Level.INFO, I.TRYING_LUMA_CHROMA(iLQscale, iCQscale));
                int[] aiNewQscale = new int[]{iCQscale, iCQscale, iLQscale, iLQscale, iLQscale, iLQscale};
                for (MacroBlockEncoder macblk : encoder) {
                    macblk.setToPartialEncode(aiOriginalQscale, aiNewQscale);
                }
                try {
                    byte[] abNewDemux;
                    try {
                        abNewDemux = this.compress(encoder.getStream());
                    }
                    catch (IncompatibleException ex) {
                        throw new RuntimeException("The encoder should be compatible here", ex);
                    }
                    if (abNewDemux.length <= abOriginal.length) {
                        log.log(Level.INFO, I.NEW_FRAME_FITS(sFrameDescription, abNewDemux.length, abOriginal.length));
                        return abNewDemux;
                    }
                    log.log(Level.INFO, I.NEW_FRAME_DOES_NOT_FIT(sFrameDescription, abNewDemux.length, abOriginal.length));
                }
                catch (MdecException.TooMuchEnergy ex) {
                    log.log(Level.INFO, I.COMPRESS_TOO_MUCH_ENERGY(sFrameDescription), ex);
                }
                if ((double)iLQscale / (double)iCQscale < 2.0) {
                    ++iLQscale;
                    continue;
                }
                ++iCQscale;
            }
            return null;
        }

        @Override
        @Nonnull
        public byte[] compress(@Nonnull MdecInputStream inStream) throws IncompatibleException, MdecException.EndOfStream, MdecException.ReadCorruption, MdecException.TooMuchEnergy {
            this._iLumaQscale = -1;
            this._iChromaQscale = -1;
            return super.compress(inStream);
        }

        @Override
        protected void setBlockQscale(@Nonnull MdecBlock block, int iQscale) throws IncompatibleException {
            if (block.isChroma()) {
                if (this._iChromaQscale < 0) {
                    this._iChromaQscale = iQscale;
                } else if (this._iChromaQscale != iQscale) {
                    throw new IncompatibleException(String.format("Inconsistent chroma qscale: current %d != new %d", this._iChromaQscale, iQscale));
                }
            } else if (this._iLumaQscale < 0) {
                this._iLumaQscale = iQscale;
            } else if (this._iLumaQscale != iQscale) {
                throw new IncompatibleException(String.format("Inconsistent luma qscale: current %d != new %d", this._iLumaQscale, iQscale));
            }
        }

        @Override
        @Nonnull
        protected byte[] createHeader(int iMdecCodeCount) {
            byte[] ab = new byte[8];
            ab[0] = (byte)this._iLumaQscale;
            ab[1] = (byte)this._iChromaQscale;
            IO.writeInt16LE(ab, 2, (short)this._iMagic3800orFrame);
            IO.writeInt16LE(ab, 4, (short)iMdecCodeCount);
            IO.writeInt16LE(ab, 6, (short)this.getHeaderVersion());
            return ab;
        }

        @Override
        protected int getHeaderVersion() {
            return 0;
        }

        @Override
        @Nonnull
        protected ZeroRunLengthAcLookup getAcVaribleLengthCodeList() {
            return AC_VARIABLE_LENGTH_CODES_LAIN;
        }

        @Override
        @Nonnull
        protected String encodeAcEscape(@Nonnull MdecCode code) throws MdecException.TooMuchEnergy {
            String sTopBits = Misc.bitsToString(code.getTop6Bits(), 6);
            if (code.getBottom10Bits() == 0) {
                throw new IllegalArgumentException("Invalid MDEC code to escape " + code);
            }
            if (code.getBottom10Bits() < -256 || code.getBottom10Bits() > 255) {
                throw new MdecException.TooMuchEnergy(String.format("Unable to escape %s, AC code too large for Lain", code));
            }
            if (code.getBottom10Bits() >= -127 && code.getBottom10Bits() <= 127) {
                return ESCAPE_CODE.getBitString() + sTopBits + Misc.bitsToString(code.getBottom10Bits(), 8);
            }
            if (code.getBottom10Bits() > 0) {
                return ESCAPE_CODE.getBitString() + sTopBits + "00000000" + Misc.bitsToString(code.getBottom10Bits(), 8);
            }
            return ESCAPE_CODE.getBitString() + sTopBits + "10000000" + Misc.bitsToString(code.getBottom10Bits() + 256, 8);
        }

        @Override
        protected void addTrailingBits(BitStreamWriter bitStream) {
        }
    }

    private static class AcEscapeCode_Lain
    implements BitStreamUncompressor.IAcEscapeCode {
        private AcEscapeCode_Lain() {
        }

        @Override
        public void readAcEscapeCode(@Nonnull ArrayBitReader bitReader, @Nonnull MdecCode code) throws MdecException.EndOfStream {
            int iBits = bitReader.readUnsignedBits(14);
            code.setTop6Bits(iBits >>> 8 & 0x3F);
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(code.getTop6Bits(), 6)));
            if ((iBits &= 0xFF) == 0) {
                assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits("00000000"));
                int iACCoefficient = bitReader.readUnsignedBits(8);
                assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(iACCoefficient, 8)));
                code.setBottom10Bits(iACCoefficient);
            } else if (iBits == 128) {
                assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits("10000000"));
                int iACCoefficient = -256 + bitReader.readUnsignedBits(8);
                assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(iACCoefficient, 8)));
                code.setBottom10Bits(iACCoefficient);
            } else {
                assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(iBits, 8)));
                byte iACCoefficient = (byte)iBits;
                code.setBottom10Bits(iACCoefficient);
            }
        }
    }

    private static class QuantizationDcReader_Lain
    implements BitStreamUncompressor.IQuantizationDcReader {
        private final int _iFrameLumaQuantizationScale;
        private final int _iFrameChromaQuantizationScale;

        public QuantizationDcReader_Lain(int iFrameLumaQuantizationScale, int iFrameChromaQuantizationScale) {
            this._iFrameLumaQuantizationScale = iFrameLumaQuantizationScale;
            this._iFrameChromaQuantizationScale = iFrameChromaQuantizationScale;
        }

        @Override
        public void readQuantizationScaleAndDc(@Nonnull ArrayBitReader bitReader, @Nonnull MdecContext context, @Nonnull MdecCode code) throws MdecException.EndOfStream {
            code.setBottom10Bits(bitReader.readSignedBits(10));
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(Misc.bitsToString(code.getBottom10Bits(), 10)));
            if (context.getCurrentBlock().isChroma()) {
                code.setTop6Bits(this._iFrameChromaQuantizationScale);
            } else {
                code.setTop6Bits(this._iFrameLumaQuantizationScale);
            }
        }
    }

    public static class LainHeader {
        private static final int SIZEOF = 8;
        int _iQscaleLuma = -1;
        int _iQscaleChroma = -1;
        int _iMagic3800orFrame = -1;
        int _iVlcCount = -1;
        private final boolean _blnIsValid;

        public LainHeader(@Nonnull byte[] abFrameData, int iDataSize) {
            if (iDataSize < 8) {
                this._blnIsValid = false;
                return;
            }
            int iQscaleLuma = abFrameData[0];
            int iQscaleChroma = abFrameData[1];
            int iMagic3800orFrame = IO.readUInt16LE(abFrameData, 2);
            short iVlcCount = IO.readSInt16LE(abFrameData, 4);
            short iVersion = IO.readSInt16LE(abFrameData, 6);
            if (iQscaleChroma < 1 || iQscaleLuma < 1 || iVersion != 0 || iVlcCount < 1) {
                this._blnIsValid = false;
                return;
            }
            if (iMagic3800orFrame != 14336 && (iMagic3800orFrame < 0 || iMagic3800orFrame > 4765)) {
                this._blnIsValid = false;
                return;
            }
            this._iQscaleLuma = iQscaleLuma;
            this._iQscaleChroma = iQscaleChroma;
            this._iMagic3800orFrame = iMagic3800orFrame;
            this._iVlcCount = iVlcCount;
            this._blnIsValid = true;
        }

        public boolean isValid() {
            return this._blnIsValid;
        }

        public int getLumaQscale() {
            if (!this._blnIsValid) {
                throw new IllegalStateException();
            }
            return this._iQscaleLuma;
        }

        public int getChromaQscale() {
            if (!this._blnIsValid) {
                throw new IllegalStateException();
            }
            return this._iQscaleChroma;
        }

        public int getMagic3800orFrame() {
            if (!this._blnIsValid) {
                throw new IllegalStateException();
            }
            return this._iMagic3800orFrame;
        }

        public int getVlcCount() {
            if (!this._blnIsValid) {
                throw new IllegalStateException();
            }
            return this._iVlcCount;
        }
    }
}

