/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.BitStreamWriter;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup_STR;
import jpsxdec.psxvideo.encode.MacroBlockEncoder;
import jpsxdec.psxvideo.encode.MdecEncoder;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;
import jpsxdec.util.Misc;

public class BitStreamUncompressor_Iki
extends BitStreamUncompressor {
    private static final Logger LOG = Logger.getLogger(BitStreamUncompressor_Iki.class.getName());
    @Nonnull
    private final IkiHeader _header;

    @CheckForNull
    public static IkiHeader makeIkiHeader(@Nonnull byte[] abFrameData, int iDataSize) {
        byte[] abQscaleDcLookupTable;
        if (iDataSize < 10) {
            return null;
        }
        int iMdecCodeCount = IO.readUInt16LE(abFrameData, 0);
        int iMagic3800 = IO.readUInt16LE(abFrameData, 2);
        short iWidth = IO.readSInt16LE(abFrameData, 4);
        short iHeight = IO.readSInt16LE(abFrameData, 6);
        int iCompressedDataSize = IO.readUInt16LE(abFrameData, 8);
        if (iMdecCodeCount < 0 || iMagic3800 != 14336 || iWidth < 1 || iHeight < 1 || iCompressedDataSize < 1) {
            return null;
        }
        if (iDataSize < 10 + iCompressedDataSize) {
            LOG.log(Level.WARNING, "Incomplete iki frame header");
            return null;
        }
        int iBlockCount = Calc.blocks(iWidth, iHeight);
        int iQscaleDcLookupTableSize = iBlockCount * 2;
        try {
            abQscaleDcLookupTable = BitStreamUncompressor_Iki.ikiLzssUncompress(abFrameData, 10, iQscaleDcLookupTableSize);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        return new IkiHeader(iMdecCodeCount, iWidth, iHeight, iCompressedDataSize, iBlockCount, abQscaleDcLookupTable);
    }

    @Nonnull
    public static BitStreamUncompressor_Iki makeIki(@Nonnull byte[] abFrameData) throws BinaryDataNotRecognized {
        return BitStreamUncompressor_Iki.makeIki(abFrameData, abFrameData.length);
    }

    @Nonnull
    public static BitStreamUncompressor_Iki makeIki(@Nonnull byte[] abFrameData, int iDataSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor_Iki bsu = BitStreamUncompressor_Iki.makeIkiNoThrow(abFrameData, iDataSize);
        if (bsu == null) {
            throw new BinaryDataNotRecognized();
        }
        return bsu;
    }

    @CheckForNull
    static BitStreamUncompressor_Iki makeIkiNoThrow(@Nonnull byte[] abFrameData, int iDataSize) throws BinaryDataNotRecognized {
        IkiHeader header = BitStreamUncompressor_Iki.makeIkiHeader(abFrameData, iDataSize);
        if (header == null) {
            return null;
        }
        ArrayBitReader bitReader = new ArrayBitReader(abFrameData, BitStreamUncompressor_STRv2.LITTLE_ENDIAN_SHORT_ORDER, 10 + header.getCompressedDataSize(), iDataSize);
        return new BitStreamUncompressor_Iki(header, bitReader);
    }

    protected BitStreamUncompressor_Iki(@Nonnull IkiHeader header, @Nonnull ArrayBitReader bitReader) {
        super(bitReader, ZeroRunLengthAcLookup_STR.AC_VARIABLE_LENGTH_CODES_MPEG1, new QuantizationDcReader_Iki(header), BitStreamUncompressor_STRv2.AC_ESCAPE_CODE_STR, FRAME_END_PADDING_BITS_NONE);
        this._header = header;
    }

    public int getWidth() {
        return this._header.getWidth();
    }

    public int getHeight() {
        return this._header.getHeight();
    }

    @Nonnull
    protected static byte[] ikiLzssUncompress(@Nonnull byte[] abSrc, int iSrcPosition, int iUncompressedSize) throws ArrayIndexOutOfBoundsException {
        byte[] abDest = new byte[iUncompressedSize];
        int iDestPosition = 0;
        block0: while (iDestPosition < iUncompressedSize) {
            int iFlags = abSrc[iSrcPosition++] & 0xFF;
            if (BitStreamDebugging.DEBUG) {
                System.err.println("Flags " + Misc.bitsToString(iFlags, 8));
            }
            int iBit = 0;
            while (iBit < 8) {
                if (BitStreamDebugging.DEBUG) {
                    System.err.format("[InPos: %d OutPos: %d] bit %02x: ", iSrcPosition, iDestPosition, 1 << iBit);
                }
                if ((iFlags & 1) == 0) {
                    byte b = abSrc[iSrcPosition++];
                    if (BitStreamDebugging.DEBUG) {
                        System.err.println(String.format("{Byte %02x}", b));
                    }
                    abDest[iDestPosition++] = b;
                } else {
                    int iCopyOffset;
                    int iCopySize = (abSrc[iSrcPosition++] & 0xFF) + 3;
                    if (((iCopyOffset = abSrc[iSrcPosition++] & 0xFF) & 0x80) != 0) {
                        iCopyOffset = (iCopyOffset & 0x7F) << 8 | abSrc[iSrcPosition++] & 0xFF;
                    }
                    ++iCopyOffset;
                    if (BitStreamDebugging.DEBUG) {
                        System.err.println("Copy " + iCopySize + " bytes from " + (iDestPosition - (iCopyOffset + 1)) + "(-" + iCopyOffset + ")");
                    }
                    while (iCopySize > 0) {
                        abDest[iDestPosition] = abDest[iDestPosition - iCopyOffset];
                        ++iDestPosition;
                        --iCopySize;
                    }
                }
                if (iDestPosition >= iUncompressedSize) continue block0;
                ++iBit;
                iFlags >>= 1;
            }
        }
        if (BitStreamDebugging.DEBUG) {
            System.err.println("Src pos at end: " + iSrcPosition);
        }
        return abDest;
    }

    @Override
    public String toString() {
        int iMinQscale = 64;
        int iMaxQscale = 0;
        MdecCode code = new MdecCode();
        for (int i = 0; i < this._header.getFrameBlockCount(); ++i) {
            code.set(this._header.getBlockQscaleDc(i));
            int iQscale = code.getTop6Bits();
            if (iQscale < iMinQscale) {
                iMinQscale = iQscale;
            }
            if (iQscale <= iMaxQscale) continue;
            iMaxQscale = iQscale;
        }
        return super.toString() + String.format(" Qscale=%d-%d %dx%d", iMinQscale, iMaxQscale, this._header.getWidth(), this._header.getHeight());
    }

    @Override
    @Nonnull
    public BitStreamCompressor_Iki makeCompressor() {
        return new BitStreamCompressor_Iki(this._header.getWidth(), this._header.getHeight());
    }

    static byte[] testIkiLzssCompress(byte[] ab) {
        IkiLzssCompressor compressor = new IkiLzssCompressor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        compressor.compress(ab, baos);
        return baos.toByteArray();
    }

    static byte[] testIkiLzssUncompress(byte[] ab, int iUncompressSize) {
        return BitStreamUncompressor_Iki.ikiLzssUncompress(ab, 0, iUncompressSize);
    }

    public static class BitStreamCompressor_Iki
    extends BitStreamUncompressor_STRv2.BitStreamCompressor_STRv2 {
        private final int _iWidth;
        private final int _iHeight;
        private final ByteArrayOutputStream _top8 = new ByteArrayOutputStream();
        private final ByteArrayOutputStream _bottom8 = new ByteArrayOutputStream();
        private final MdecCode _currentBlockQscaleDc = new MdecCode();
        private final IkiLzssCompressor _lzs = new IkiLzssCompressor();

        protected BitStreamCompressor_Iki(int iWidth, int iHeight) {
            super(Calc.macroblocks(iWidth, iHeight), BitStreamUncompressor_STRv2.LITTLE_ENDIAN_SHORT_ORDER);
            this._iWidth = iWidth;
            this._iHeight = iHeight;
        }

        @Override
        @CheckForNull
        public byte[] compressFull(int iMaxSize, @Nonnull String sFrameDescription, @Nonnull MdecEncoder encoder, @Nonnull ILocalizedLogger log) throws MdecException.EndOfStream, MdecException.ReadCorruption {
            int iQscale;
            byte[] abNewDemux = null;
            for (iQscale = 1; iQscale < 64; ++iQscale) {
                log.log(Level.INFO, I.TRYING_QSCALE(iQscale));
                int[] aiNewQscale = new int[]{iQscale, iQscale, iQscale, iQscale, iQscale, iQscale};
                for (MacroBlockEncoder macblk : encoder) {
                    macblk.setToFullEncode(aiNewQscale);
                }
                try {
                    abNewDemux = this.compress(encoder.getStream());
                }
                catch (IncompatibleException ex) {
                    throw new RuntimeException("The encoder should be compatible here", ex);
                }
                int iNewDemuxSize = abNewDemux.length;
                if (iNewDemuxSize <= iMaxSize) {
                    log.log(Level.INFO, I.NEW_FRAME_FITS(sFrameDescription, iNewDemuxSize, iMaxSize));
                    break;
                }
                log.log(Level.INFO, I.NEW_FRAME_DOES_NOT_FIT(sFrameDescription, iNewDemuxSize, iMaxSize));
                abNewDemux = null;
            }
            if (abNewDemux != null && abNewDemux.length < iMaxSize && iQscale > 1) {
                abNewDemux = this.reduceQscaleForHighEnergyMacroBlocks(abNewDemux, iMaxSize, sFrameDescription, iQscale - 1, encoder, log);
            }
            return abNewDemux;
        }

        @Nonnull
        private byte[] reduceQscaleForHighEnergyMacroBlocks(@Nonnull byte[] abLastGoodDemux, int iOriginalLength, @Nonnull String sFrameDescription, int iNewQscale, @Nonnull MdecEncoder encoder, @Nonnull ILocalizedLogger log) throws MdecException.EndOfStream, MdecException.ReadCorruption {
            final int iMbCenterX = encoder.getMacroBlockWidth() / 2;
            final int iMbCenterY = encoder.getMacroBlockHeight() / 2;
            TreeSet<MacroBlockEncoder> macblocks = new TreeSet<MacroBlockEncoder>(new Comparator<MacroBlockEncoder>(){

                @Override
                public int compare(MacroBlockEncoder o1, MacroBlockEncoder o2) {
                    if (o1.getEnergy() > o2.getEnergy()) {
                        return -1;
                    }
                    if (o1.getEnergy() < o2.getEnergy()) {
                        return 1;
                    }
                    int iDistX = o1.X - iMbCenterX;
                    int iDistY = o1.Y - iMbCenterY;
                    int o1dist = iDistX * iDistX + iDistY * iDistY;
                    iDistX = o2.X - iMbCenterX;
                    iDistY = o2.Y - iMbCenterY;
                    int o2dist = iDistX * iDistX + iDistY * iDistY;
                    return Misc.intCompare(o1dist, o2dist);
                }
            });
            for (MacroBlockEncoder macblk : encoder) {
                macblocks.add(macblk);
            }
            int[] aiNewQscale = new int[]{iNewQscale, iNewQscale, iNewQscale, iNewQscale, iNewQscale, iNewQscale};
            for (MacroBlockEncoder macblk : macblocks) {
                byte[] abNewDemux;
                log.log(Level.INFO, I.IKI_REDUCING_QSCALE_OF_MB_TO_VAL(macblk.X, macblk.Y, iNewQscale));
                macblk.setToFullEncode(aiNewQscale);
                try {
                    abNewDemux = this.compress(encoder.getStream());
                }
                catch (IncompatibleException ex) {
                    throw new RuntimeException("The encoder should be compatible here", ex);
                }
                int iNewDemuxSize = abNewDemux.length;
                if (iNewDemuxSize > iOriginalLength) {
                    log.log(Level.INFO, I.NEW_FRAME_DOES_NOT_FIT(sFrameDescription, iNewDemuxSize, iOriginalLength));
                    break;
                }
                log.log(Level.INFO, I.NEW_FRAME_FITS(sFrameDescription, iNewDemuxSize, iOriginalLength));
                abLastGoodDemux = abNewDemux;
            }
            return abLastGoodDemux;
        }

        @Override
        @CheckForNull
        public byte[] compressPartial(@Nonnull byte[] abOriginal, @Nonnull String sFrameDescription, @Nonnull MdecEncoder encoder, @Nonnull ILocalizedLogger log) throws MdecException.EndOfStream, MdecException.ReadCorruption {
            return this.compressFull(abOriginal.length, sFrameDescription, encoder, log);
        }

        @Override
        @Nonnull
        public byte[] compress(@Nonnull MdecInputStream inStream) throws IncompatibleException, MdecException.EndOfStream, MdecException.ReadCorruption {
            this._top8.reset();
            this._bottom8.reset();
            try {
                return super.compress(inStream);
            }
            catch (MdecException.TooMuchEnergy ex) {
                throw new RuntimeException("This should not happen with Iki", ex);
            }
        }

        @Override
        protected void setBlockQscale(@Nonnull MdecBlock block, int iQscale) {
            this._currentBlockQscaleDc.setTop6Bits(iQscale);
        }

        @Override
        @Nonnull
        protected String encodeDC(int iDC, @Nonnull MdecBlock block) {
            this._currentBlockQscaleDc.setBottom10Bits(iDC);
            int iMdec = this._currentBlockQscaleDc.toMdecWord();
            this._top8.write(iMdec >> 8);
            this._bottom8.write(iMdec & 0xFF);
            return "";
        }

        @Override
        @Nonnull
        protected byte[] createHeader(int iMdecCodeCount) {
            assert (this._top8.size() == this._bottom8.size());
            byte[] ab = this._bottom8.toByteArray();
            this._top8.write(ab, 0, ab.length);
            ab = this._top8.toByteArray();
            this._top8.reset();
            this._bottom8.reset();
            this._lzs.compress(ab, this._bottom8);
            if (this._bottom8.size() % 2 != 0) {
                this._bottom8.write(0);
            }
            ab = this._bottom8.toByteArray();
            byte[] abHdr = new byte[10];
            IO.writeInt16LE(abHdr, 0, Calc.calculateHalfCeiling32(iMdecCodeCount));
            IO.writeInt16LE(abHdr, 2, (short)14336);
            IO.writeInt16LE(abHdr, 4, (short)this._iWidth);
            IO.writeInt16LE(abHdr, 6, (short)this._iHeight);
            IO.writeInt16LE(abHdr, 8, (short)ab.length);
            this._top8.write(abHdr, 0, abHdr.length);
            this._top8.write(ab, 0, ab.length);
            return this._top8.toByteArray();
        }

        @Override
        protected void addTrailingBits(BitStreamWriter bitStream) {
        }
    }

    private static class IkiLzssCompressor {
        private int _iFlags;
        private int _iFlagBit;
        private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();
        private final ByteArrayOutputStream _baosLogger = new ByteArrayOutputStream();
        private final PrintStream _logger = new PrintStream(this._baosLogger, true);

        private IkiLzssCompressor() {
        }

        public void compress(@Nonnull byte[] abSrcData, @Nonnull ByteArrayOutputStream out) {
            this.reset();
            int iSrcPos = 0;
            while (iSrcPos < abSrcData.length) {
                if (BitStreamDebugging.DEBUG) {
                    this._logger.format("[InPos: %d OutPos: %d]: bit %02x: ", out.size() + 1 + this._buffer.size(), iSrcPos, 1 << this._iFlagBit);
                }
                int iLongestRunPos = 0;
                int iLongestRunLen = 0;
                if (iSrcPos < abSrcData.length - 3) {
                    int iFarthestBack = iSrcPos - 32768;
                    if (iFarthestBack < 0) {
                        iFarthestBack = 0;
                    }
                    for (int iMatchStart = iSrcPos - 1; iMatchStart >= iFarthestBack; --iMatchStart) {
                        int iNegOffsetMin1;
                        int iMatchLen = IkiLzssCompressor.matchLength(abSrcData, iMatchStart, iSrcPos);
                        if (iMatchLen <= iLongestRunLen || ((iNegOffsetMin1 = iSrcPos - iMatchStart - 1) >= 128 || iMatchLen < 3) && (iNegOffsetMin1 < 128 || iMatchLen < 4)) continue;
                        iLongestRunLen = iMatchLen;
                        iLongestRunPos = iMatchStart;
                    }
                }
                if (iLongestRunLen > 0) {
                    this.addRun(iSrcPos - iLongestRunPos, iLongestRunLen, iSrcPos);
                    iSrcPos += iLongestRunLen;
                } else {
                    if (BitStreamDebugging.DEBUG) {
                        this._logger.format("{Byte %02x}", abSrcData[iSrcPos] & 0xFF).println();
                    }
                    this.addCopy(abSrcData[iSrcPos]);
                    ++iSrcPos;
                }
                this.incFlag(out);
            }
            if (this._iFlagBit > 0) {
                if (BitStreamDebugging.DEBUG) {
                    this._logger.println("Flags " + Misc.bitsToString(this._iFlags, 8));
                }
                out.write(this._iFlags);
                byte[] ab = this._buffer.toByteArray();
                out.write(ab, 0, ab.length);
            }
        }

        private void addRun(int iPosition, int iLength, int iSrcPos) {
            assert (iPosition > 0);
            if (BitStreamDebugging.DEBUG) {
                this._logger.format("Copy %d bytes from %d(%d)", iLength, iSrcPos - iPosition, -iPosition).println();
            }
            this._iFlags |= 1 << this._iFlagBit;
            this._buffer.write(iLength - 3);
            if (--iPosition < 128) {
                this._buffer.write(iPosition);
            } else {
                this._buffer.write(iPosition >> 8 | 0x80);
                this._buffer.write(iPosition & 0xFF);
            }
        }

        private void addCopy(byte b) {
            this._buffer.write(b);
        }

        private void incFlag(@Nonnull ByteArrayOutputStream out) {
            ++this._iFlagBit;
            if (this._iFlagBit >= 8) {
                if (BitStreamDebugging.DEBUG) {
                    System.err.println("Flags " + Misc.bitsToString(this._iFlags, 8));
                    this._logger.flush();
                    System.err.print(this._baosLogger.toString());
                    this._baosLogger.reset();
                }
                out.write(this._iFlags);
                byte[] ab = this._buffer.toByteArray();
                out.write(ab, 0, ab.length);
                this.reset();
            }
        }

        private void reset() {
            this._iFlagBit = 0;
            this._iFlags = 0;
            this._buffer.reset();
        }

        private static int matchLength(@Nonnull byte[] abData, int iMatchStart, int iEndPos) {
            int iLen;
            for (iLen = 0; iEndPos + iLen < abData.length && iLen < 258 && abData[iMatchStart + iLen] == abData[iEndPos + iLen]; ++iLen) {
            }
            return iLen;
        }
    }

    private static class QuantizationDcReader_Iki
    implements BitStreamUncompressor.IQuantizationDcReader {
        @Nonnull
        private final IkiHeader _header;

        public QuantizationDcReader_Iki(@Nonnull IkiHeader header) {
            this._header = header;
        }

        @Override
        public void readQuantizationScaleAndDc(@Nonnull ArrayBitReader bitReader, @Nonnull MdecContext context, @Nonnull MdecCode mdecCode) throws MdecException.ReadCorruption, MdecException.EndOfStream {
            if (context.getTotalBlocksRead() >= this._header.getFrameBlockCount()) {
                throw new MdecException.EndOfStream(MdecException.inBlockOfBlocks(context.getTotalBlocksRead(), this._header.getFrameBlockCount()));
            }
            mdecCode.set(this._header.getBlockQscaleDc(context.getTotalBlocksRead()));
        }
    }

    public static class IkiHeader {
        public static final int SIZEOF = 10;
        private final int _iMdecCodeCount;
        private final int _iWidth;
        private final int _iHeight;
        private final int _iCompressedDataSize;
        private final int _iBlockCount;
        @Nonnull
        private final byte[] _abQscaleDcLookupTable;

        protected IkiHeader(int iMdecCodeCount, int iWidth, int iHeight, int iCompressedDataSize, int iBlockCount, byte[] abQscaleDcLookupTable) {
            this._iMdecCodeCount = iMdecCodeCount;
            this._iWidth = iWidth;
            this._iHeight = iHeight;
            this._iCompressedDataSize = iCompressedDataSize;
            this._iBlockCount = iBlockCount;
            this._abQscaleDcLookupTable = abQscaleDcLookupTable;
        }

        public int getiMdecCodeCount() {
            return this._iMdecCodeCount;
        }

        public int getWidth() {
            return this._iWidth;
        }

        public int getHeight() {
            return this._iHeight;
        }

        public int getCompressedDataSize() {
            return this._iCompressedDataSize;
        }

        public int getFrameBlockCount() {
            return this._iBlockCount;
        }

        public int getBlockQscaleDc(int iBlock) {
            int b1 = this._abQscaleDcLookupTable[iBlock] & 0xFF;
            int b2 = this._abQscaleDcLookupTable[iBlock + this._iBlockCount] & 0xFF;
            return b1 << 8 | b2;
        }
    }
}

