/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import javax.annotation.Nonnull;
import jpsxdec.modules.panekit.BitStreamUncompressor_Panekit;
import jpsxdec.modules.starwars.BitStreamUncompressor_StarWars;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamCompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_Iki;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_Lain;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv1;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv3;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAc;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.Misc;

public abstract class BitStreamUncompressor
implements MdecInputStream {
    public static final IFrameEndPaddingBits FRAME_END_PADDING_BITS_NONE = new FrameEndPaddingBits_None();
    @Nonnull
    private final ArrayBitReader _bitReader;
    @Nonnull
    private final ZeroRunLengthAcLookup _lookupTable;
    @Nonnull
    private final IQuantizationDcReader _qscaleDcReader;
    @Nonnull
    private final IAcEscapeCode _escapeCodeReader;
    @Nonnull
    private final IFrameEndPaddingBits _endPaddingBits;
    protected final MdecContext _context = new MdecContext();
    private int _iCurrentBlockVectorPos = 0;

    @Nonnull
    public static final BitStreamUncompressor identifyUncompressor(@Nonnull byte[] abBitstream) throws BinaryDataNotRecognized {
        return BitStreamUncompressor.identifyUncompressor(abBitstream, abBitstream.length);
    }

    @Nonnull
    public static final BitStreamUncompressor identifyUncompressor(@Nonnull byte[] abBitstream, int iBitstreamSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor bsu = BitStreamUncompressor_STRv2.makeV2NoThrow(abBitstream, iBitstreamSize);
        if (bsu != null) {
            return bsu;
        }
        bsu = BitStreamUncompressor_STRv3.makeV3NoThrow(abBitstream, iBitstreamSize);
        if (bsu != null) {
            return bsu;
        }
        bsu = BitStreamUncompressor_STRv1.makeV1NoThrow(abBitstream, iBitstreamSize);
        if (bsu != null) {
            return bsu;
        }
        bsu = BitStreamUncompressor_Iki.makeIkiNoThrow(abBitstream, iBitstreamSize);
        if (bsu != null) {
            return bsu;
        }
        bsu = BitStreamUncompressor_Lain.makeLainNoThrow(abBitstream, iBitstreamSize);
        if (bsu != null) {
            return bsu;
        }
        bsu = BitStreamUncompressor_Panekit.makePanekitNoThrow(abBitstream, iBitstreamSize);
        if (bsu != null) {
            return bsu;
        }
        bsu = BitStreamUncompressor_StarWars.makeStarWarsNoThrow(abBitstream, iBitstreamSize);
        if (bsu != null) {
            return bsu;
        }
        throw new BinaryDataNotRecognized();
    }

    public int getReadMdecCodeCount() {
        return this._context.getTotalMdecCodesRead();
    }

    public BitStreamUncompressor(@Nonnull ArrayBitReader bitReader, @Nonnull ZeroRunLengthAcLookup lookupTable, @Nonnull IQuantizationDcReader qscaleDcReader, @Nonnull IAcEscapeCode escapeCodeReader, @Nonnull IFrameEndPaddingBits endPaddingBits) {
        this._bitReader = bitReader;
        this._lookupTable = lookupTable;
        this._qscaleDcReader = qscaleDcReader;
        this._escapeCodeReader = escapeCodeReader;
        this._endPaddingBits = endPaddingBits;
    }

    public final int getBitPosition() {
        return this._bitReader.getBitsRead();
    }

    public final int getByteOffset() {
        return this._bitReader.getCurrentShortPosition();
    }

    @Override
    public final boolean readMdecCode(@Nonnull MdecCode code) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.setPosition(this._bitReader.getCurrentShortPosition()));
        if (this._context.atStartOfBlock()) {
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.printStartOfBlock(this._context));
            this._qscaleDcReader.readQuantizationScaleAndDc(this._bitReader, this._context, code);
            this._context.nextCode();
        } else {
            int i17bits = this._bitReader.peekUnsignedBits(17);
            ZeroRunLengthAc bitCode = this._lookupTable.lookup(i17bits);
            if (bitCode == null) {
                String s = "Unmatched AC variable length code: " + Misc.bitsToString(i17bits, 17) + " " + this;
                throw new MdecException.ReadCorruption(s);
            }
            this._bitReader.skipBits(bitCode.getBitLength());
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.appendBits(bitCode.getBitString()));
            if (bitCode.isIsEndOfBlock()) {
                code.setToEndOfData();
                this._iCurrentBlockVectorPos = 0;
                this._context.nextCodeEndBlock();
            } else {
                if (bitCode.isIsEscapeCode()) {
                    this._escapeCodeReader.readAcEscapeCode(this._bitReader, code);
                } else {
                    bitCode.getMdecCode(code);
                }
                this._iCurrentBlockVectorPos += code.getTop6Bits() + 1;
                if (this._iCurrentBlockVectorPos >= 64) {
                    throw new MdecException.ReadCorruption(MdecException.RLC_OOB_IN_MB_BLOCK(this._iCurrentBlockVectorPos, this._context.getTotalMacroBlocksRead(), this._context.getCurrentBlock().ordinal()));
                }
                this._context.nextCode();
            }
        }
        assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.printBitsResult(this._iCurrentBlockVectorPos, code));
        return this._context.atStartOfBlock();
    }

    public final void skipMacroBlocks(int iPixelWidth, int iPixelHeight) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        int iBlocksToSkip = Calc.blocks(iPixelWidth, iPixelHeight);
        MdecCode code = new MdecCode();
        for (int i = 0; i < iBlocksToSkip; ++i) {
            while (!this.readMdecCode(code)) {
            }
        }
    }

    public final boolean skipPaddingBits() throws MdecException.EndOfStream {
        return this._endPaddingBits.skipPaddingBits(this._bitReader);
    }

    @Nonnull
    public abstract BitStreamCompressor makeCompressor() throws UnsupportedOperationException;

    public String toString() {
        return this.getClass().getSimpleName() + " " + this._context.toString() + " offset=" + this._bitReader.getCurrentShortPosition();
    }

    private static class FrameEndPaddingBits_None
    implements IFrameEndPaddingBits {
        private FrameEndPaddingBits_None() {
        }

        @Override
        public boolean skipPaddingBits(@Nonnull ArrayBitReader bitReader) {
            return true;
        }
    }

    public static interface IFrameEndPaddingBits {
        public boolean skipPaddingBits(@Nonnull ArrayBitReader var1) throws MdecException.EndOfStream;
    }

    public static interface IQuantizationDcReader {
        public void readQuantizationScaleAndDc(@Nonnull ArrayBitReader var1, @Nonnull MdecContext var2, @Nonnull MdecCode var3) throws MdecException.ReadCorruption, MdecException.EndOfStream;
    }

    public static interface IAcEscapeCode {
        public void readAcEscapeCode(@Nonnull ArrayBitReader var1, @Nonnull MdecCode var2) throws MdecException.EndOfStream;
    }
}

