/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.io.PrintStream;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.bitstreams.BitStreamCompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.IBitStreamWith1QuantizationScale;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.ParsedMdecImage;
import jpsxdec.util.BinaryDataNotRecognized;

public class BitStreamAnalysis {
    @Nonnull
    private final ParsedMdecImage _parsed;
    @Nonnull
    private final BitStreamUncompressor _uncompressor;
    private final boolean _blnCorrectPaddingBits;
    @Nonnull
    private final byte[] _abBitStream;
    private final int _iWidth;
    private final int _iHeight;

    public BitStreamAnalysis(@Nonnull byte[] abBitstream, int iWidth, int iHeight) throws BinaryDataNotRecognized, MdecException.ReadCorruption, MdecException.EndOfStream {
        this._abBitStream = abBitstream;
        this._uncompressor = BitStreamUncompressor.identifyUncompressor(this._abBitStream);
        this._parsed = new ParsedMdecImage(this._uncompressor, iWidth, iHeight);
        this._blnCorrectPaddingBits = this._uncompressor.skipPaddingBits();
        this._iWidth = iWidth;
        this._iHeight = iHeight;
    }

    @Nonnull
    public MdecInputStream makeNewStream() {
        return this._parsed.getStream();
    }

    public int getBitStreamArrayLength() {
        return this._abBitStream.length;
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public boolean hasCorrectPaddingBits() {
        return this._blnCorrectPaddingBits;
    }

    @Nonnull
    public BitStreamUncompressor getCompletedBitStream() {
        return this._uncompressor;
    }

    @Nonnull
    public BitStreamCompressor makeBitStreamCompressor() {
        return this._uncompressor.makeCompressor();
    }

    public <T extends BitStreamUncompressor> boolean isBitStreamClass(@Nonnull Class<T> bitStreamClass) {
        return bitStreamClass.isAssignableFrom(this._uncompressor.getClass());
    }

    @Nonnull
    public <T extends BitStreamUncompressor> Class<T> getBitStreamClass() {
        return this._uncompressor.getClass();
    }

    public int getMdecCodeCount() {
        return this._parsed.getMdecCodeCount();
    }

    public int calculateUsedBytesRoundUp4() {
        int iReadOffset;
        int iBitByteOffset = (this._uncompressor.getBitPosition() + 31 & 0xFFFFFFE0) / 8;
        if (iBitByteOffset != (iReadOffset = this._uncompressor.getByteOffset() + 3 & 0xFFFFFFFC)) {
            throw new RuntimeException("My logic is bad: " + iBitByteOffset + " != " + iReadOffset);
        }
        return iReadOffset;
    }

    public int calculateMinUsedBytes() {
        int iReadOffset;
        int iBitByteOffset = this._uncompressor.getBitPosition() / 8 & 0xFFFFFFFC;
        if (iBitByteOffset != (iReadOffset = this._uncompressor.getByteOffset() & 0xFFFFFFFC)) {
            throw new RuntimeException("My logic is bad: " + iBitByteOffset + " != " + iReadOffset);
        }
        return iReadOffset;
    }

    public int calculateNonZeroBytes() {
        int i;
        for (i = this._abBitStream.length - 1; i >= 0 && this._abBitStream[i] == 0; --i) {
        }
        return i + 1;
    }

    public short calculateMdecHalfCeiling32() {
        return Calc.calculateHalfCeiling32(this.getMdecCodeCount());
    }

    public int getFrameQuantizationScale() {
        if (this._uncompressor instanceof IBitStreamWith1QuantizationScale) {
            return ((IBitStreamWith1QuantizationScale)((Object)this._uncompressor)).getQuantizationScale();
        }
        throw new UnsupportedOperationException();
    }

    public void arrayCopy(int iSrcPos, @Nonnull byte[] abDest, int iDestPos, int iLength) {
        System.arraycopy(this._abBitStream, iSrcPos, abDest, iDestPos, iLength);
    }

    public void printInfo(@Nonnull PrintStream ps) {
        if (!this._blnCorrectPaddingBits) {
            ps.println("Incorrect padding bits!");
        }
        ps.println("Frame data info: " + this._uncompressor);
    }

    public void drawMacroBlocks(@Nonnull PrintStream ps) {
        this._parsed.drawMacroBlocks(ps);
    }
}

