/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.bitstreams;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.bitstreams.IByteOrder;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.util.Misc;

public class ArrayBitReader {
    private static final Logger LOG = Logger.getLogger(ArrayBitReader.class.getName());
    @Nonnull
    private final byte[] _abData;
    @Nonnull
    private final IByteOrder _byteOrder;
    private final int _iStartOffset;
    protected final int _iEndOffset;
    protected int _iCurrentOffset = 0;
    protected short _siCurrentShort;
    protected int _iBitsLeft = 0;
    private static final int[] BIT_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};

    public ArrayBitReader(@Nonnull byte[] abData, @Nonnull IByteOrder byteOrder, int iStartOffset, int iEndOffset) {
        if (iStartOffset < 0 || iStartOffset > abData.length) {
            throw new IllegalArgumentException("Read start out of array bounds.");
        }
        if ((iStartOffset & 1) != 0) {
            throw new IllegalArgumentException("Start offset must be a multiple of 2.");
        }
        if (iEndOffset < 0 || iEndOffset > abData.length) {
            throw new IllegalArgumentException("Invalid data size " + iEndOffset);
        }
        this._iEndOffset = iEndOffset & 0xFFFFFFFE;
        if (this._iEndOffset != iEndOffset) {
            LOG.log(Level.WARNING, "Bitstream end offset is an odd number {0}, rounding down to even number", iEndOffset);
        }
        this._iStartOffset = iStartOffset;
        this._abData = abData;
        this._byteOrder = byteOrder;
    }

    protected short readShort(int iByteIndex) throws MdecException.EndOfStream {
        int iOffset1 = this._iStartOffset + this._byteOrder.getByteOffset(iByteIndex);
        int iOffset2 = this._iStartOffset + this._byteOrder.getByteOffset(iByteIndex + 1);
        if (iOffset1 >= this._iEndOffset || iOffset2 >= this._iEndOffset) {
            throw new MdecException.EndOfStream(MdecException.END_OF_BITSTREAM(iByteIndex));
        }
        int b1 = this._abData[iOffset1] & 0xFF;
        int b2 = this._abData[iOffset2] & 0xFF;
        return (short)(b1 << 8 | b2);
    }

    public int getCurrentShortPosition() {
        return this._iStartOffset + this._iCurrentOffset;
    }

    public int getBitsRead() {
        return (this._iStartOffset + this._iCurrentOffset) * 8 - this._iBitsLeft;
    }

    public int getBitsRemaining() {
        return (this._iEndOffset - this._iStartOffset - this._iCurrentOffset) * 8 + this._iBitsLeft;
    }

    public int readUnsignedBits(int iCount) throws MdecException.EndOfStream {
        int iRet;
        if (iCount < 0 || iCount >= 32) {
            throw new IllegalArgumentException("Bits to read are out of range " + iCount);
        }
        if (iCount == 0) {
            return 0;
        }
        if (this._iBitsLeft == 0) {
            this._siCurrentShort = this.readShort(this._iCurrentOffset);
            this._iCurrentOffset += 2;
            this._iBitsLeft = 16;
        }
        if (iCount <= this._iBitsLeft) {
            iRet = this._siCurrentShort >>> this._iBitsLeft - iCount & BIT_MASK[iCount];
            this._iBitsLeft -= iCount;
        } else {
            iRet = this._siCurrentShort & BIT_MASK[this._iBitsLeft];
            iCount -= this._iBitsLeft;
            this._iBitsLeft = 0;
            try {
                while (iCount >= 16) {
                    iRet = iRet << 16 | this.readShort(this._iCurrentOffset) & 0xFFFF;
                    this._iCurrentOffset += 2;
                    iCount -= 16;
                }
                if (iCount > 0) {
                    this._siCurrentShort = this.readShort(this._iCurrentOffset);
                    this._iCurrentOffset += 2;
                    this._iBitsLeft = 16 - iCount;
                    iRet = iRet << iCount | (this._siCurrentShort & 0xFFFF) >>> this._iBitsLeft;
                }
            }
            catch (MdecException.EndOfStream ex) {
                LOG.log(Level.FINE, "Bitstream is about to end", ex);
                return iRet << iCount;
            }
        }
        return iRet;
    }

    public int readSignedBits(int iCount) throws MdecException.EndOfStream {
        return this.readUnsignedBits(iCount) << 32 - iCount >> 32 - iCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peekUnsignedBits(int iCount) throws MdecException.EndOfStream {
        int iSaveOffs = this._iCurrentOffset;
        int iSaveBitsLeft = this._iBitsLeft;
        short siSaveCurrentShort = this._siCurrentShort;
        try {
            int n = this.readUnsignedBits(iCount);
            return n;
        }
        finally {
            this._iCurrentOffset = iSaveOffs;
            this._iBitsLeft = iSaveBitsLeft;
            this._siCurrentShort = siSaveCurrentShort;
        }
    }

    public int peekSignedBits(int iCount) throws MdecException.EndOfStream {
        return this.peekUnsignedBits(iCount) << 32 - iCount >> 32 - iCount;
    }

    public void skipBits(int iCount) throws MdecException.EndOfStream {
        this._iBitsLeft -= iCount;
        if (this._iBitsLeft < 0) {
            this._iCurrentOffset += -this._iBitsLeft >> 4 << 1;
            this._iBitsLeft = -(-this._iBitsLeft & 0xF);
            if (this._iCurrentOffset > this._iEndOffset) {
                this._iBitsLeft = 0;
                this._iCurrentOffset = this._iEndOffset;
                throw new MdecException.EndOfStream(MdecException.END_OF_BITSTREAM(this._iCurrentOffset));
            }
            if (this._iBitsLeft < 0) {
                if (this._iCurrentOffset == this._iEndOffset) {
                    this._iBitsLeft = 0;
                    throw new MdecException.EndOfStream(MdecException.END_OF_BITSTREAM(this._iCurrentOffset));
                }
                this._iBitsLeft += 16;
                this._siCurrentShort = this.readShort(this._iCurrentOffset);
                this._iCurrentOffset += 2;
            }
        }
    }

    @Nonnull
    public String peekBitsToString(int iCount) throws MdecException.EndOfStream {
        int iBitsRemaining = this.getBitsRemaining();
        if (iBitsRemaining < iCount) {
            return Misc.bitsToString(this.peekUnsignedBits(iBitsRemaining), iBitsRemaining);
        }
        return Misc.bitsToString(this.peekUnsignedBits(iCount), iCount);
    }

    @Nonnull
    public String readBitsToString(int iCount) throws MdecException.EndOfStream {
        int iBitsRemaining = this.getBitsRemaining();
        if (iBitsRemaining < iCount) {
            return Misc.bitsToString(this.readUnsignedBits(iBitsRemaining), iBitsRemaining);
        }
        return Misc.bitsToString(this.readUnsignedBits(iCount), iCount);
    }
}

