/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo;

import javax.annotation.Nonnull;
import jpsxdec.formats.RGB;
import jpsxdec.util.Maths;

public class PsxYCbCr_int {
    public int y1;
    public int y2;
    public int y3;
    public int y4;
    public int cb;
    public int cr;
    public static final int FIXED_BITS = 16;
    public static final double FIXED_MULT = 65536.0;
    public static final long _1_402 = 91893L;
    public static final long _0_3437 = 22525L;
    public static final long _0_7143 = 46812L;
    public static final long _1_772 = 116224L;

    public static void toRgb(int y, int cb, int cr, @Nonnull RGB rgb) {
        int Yshift = y + 128;
        long c_r = 91893L * (long)cr;
        long c_g = -22525L * (long)cb - 46812L * (long)cr;
        long c_b = 116224L * (long)cb;
        rgb.setR(Yshift + (int)Maths.shrRound(c_r, 16));
        rgb.setG(Yshift + (int)Maths.shrRound(c_g, 16));
        rgb.setB(Yshift + (int)Maths.shrRound(c_b, 16));
    }

    public final void toRgb(@Nonnull RGB rgb1, @Nonnull RGB rgb2, @Nonnull RGB rgb3, @Nonnull RGB rgb4) {
        int iChromRed = (int)Maths.shrRound(91893L * (long)this.cr, 16);
        int iChromGreen = (int)Maths.shrRound(-(22525L * (long)this.cb) - 46812L * (long)this.cr, 16);
        int iChromBlue = (int)Maths.shrRound(116224L * (long)this.cb, 16);
        int iYshift = this.y1 + 128;
        rgb1.setR(iYshift + iChromRed);
        rgb1.setG(iYshift + iChromGreen);
        rgb1.setB(iYshift + iChromBlue);
        iYshift = this.y2 + 128;
        rgb2.setR(iYshift + iChromRed);
        rgb2.setG(iYshift + iChromGreen);
        rgb2.setB(iYshift + iChromBlue);
        iYshift = this.y3 + 128;
        rgb3.setR(iYshift + iChromRed);
        rgb3.setG(iYshift + iChromGreen);
        rgb3.setB(iYshift + iChromBlue);
        iYshift = this.y4 + 128;
        rgb4.setR(iYshift + iChromRed);
        rgb4.setG(iYshift + iChromGreen);
        rgb4.setB(iYshift + iChromBlue);
    }

    public String toString() {
        return String.format("([%d, %d, %d, %d] %d, %d)", this.y1, this.y2, this.y3, this.y4, this.cb, this.cr);
    }
}

