/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo;

import javax.annotation.Nonnull;
import jpsxdec.formats.RGB;
import jpsxdec.formats.Rec601YCbCr;

public class PsxYCbCr {
    public double y1;
    public double y2;
    public double y3;
    public double y4;
    public double cb;
    public double cr;
    private static final boolean INCORRECTLY_SWAP_CB_CR_LIKE_PSXMC = false;

    public void fromRgb(@Nonnull RGB rgb1, @Nonnull RGB rgb2, @Nonnull RGB rgb3, @Nonnull RGB rgb4) {
        this.cr = 0.0;
        this.cb = 0.0;
        this.y1 = this.oneRgb(rgb1);
        this.y2 = this.oneRgb(rgb2);
        this.y3 = this.oneRgb(rgb3);
        this.y4 = this.oneRgb(rgb4);
        this.cb /= 4.0;
        this.cr /= 4.0;
    }

    private double oneRgb(@Nonnull RGB rgb) {
        int r_128 = rgb.getR() - 128;
        int g_128 = rgb.getG() - 128;
        int b_128 = rgb.getB() - 128;
        double y = (double)r_128 * 0.299 + (double)g_128 * 0.587 + (double)b_128 * 0.114;
        this.cb += (double)r_128 * -0.16871 + (double)g_128 * -0.3313 + (double)b_128 * 0.5;
        this.cr += (double)r_128 * 0.5 + (double)g_128 * -0.4187 + (double)b_128 * -0.0813;
        return y;
    }

    public static void toRgb(double y, double cb, double cr, @Nonnull RGB rgb) {
        double dblChromRed = 1.402 * cr;
        double dblChromGreen = -0.3437 * cb + -0.7143 * cr;
        double dblChromBlue = 1.772 * cb;
        double dblYshift = y + 128.0;
        rgb.setR(dblYshift + dblChromRed);
        rgb.setG(dblYshift + dblChromGreen);
        rgb.setB(dblYshift + dblChromBlue);
    }

    public final void toRgb(@Nonnull RGB rgb1, @Nonnull RGB rgb2, @Nonnull RGB rgb3, @Nonnull RGB rgb4) {
        double dblChromRed = 1.402 * this.cr;
        double dblChromGreen = -0.3437 * this.cb + -0.7143 * this.cr;
        double dblChromBlue = 1.772 * this.cb;
        double dblYshift = this.y1 + 128.0;
        rgb1.setR(dblYshift + dblChromRed);
        rgb1.setG(dblYshift + dblChromGreen);
        rgb1.setB(dblYshift + dblChromBlue);
        dblYshift = this.y2 + 128.0;
        rgb2.setR(dblYshift + dblChromRed);
        rgb2.setG(dblYshift + dblChromGreen);
        rgb2.setB(dblYshift + dblChromBlue);
        dblYshift = this.y3 + 128.0;
        rgb3.setR(dblYshift + dblChromRed);
        rgb3.setG(dblYshift + dblChromGreen);
        rgb3.setB(dblYshift + dblChromBlue);
        dblYshift = this.y4 + 128.0;
        rgb4.setR(dblYshift + dblChromRed);
        rgb4.setG(dblYshift + dblChromGreen);
        rgb4.setB(dblYshift + dblChromBlue);
    }

    public void toRec_601_YCbCr(@Nonnull Rec601YCbCr ycc) {
        double dblYChroma = this.cb * -1.83621143178014E-4 + this.cr * -6.219924768740197E-5 + 16.0;
        ycc.y1 = (this.y1 + 128.0) * 0.8591065292096219 + dblYChroma;
        ycc.y2 = (this.y2 + 128.0) * 0.8591065292096219 + dblYChroma;
        ycc.y3 = (this.y3 + 128.0) * 0.8591065292096219 + dblYChroma;
        ycc.y4 = (this.y4 + 128.0) * 0.8591065292096219 + dblYChroma;
        ycc.cb = this.cb * 0.8782030401440333 + this.cr * 3.587706853723285E-5 + 128.0;
        ycc.cr = this.cb * 1.3391917961103278E-4 + this.cr * 0.8784914786493159 + 128.0;
    }

    public void toRec_JFIF_YCbCr(@Nonnull Rec601YCbCr ycc) {
        double dblYChroma = this.cb * -3415973.0 / 1.3224846875E10 + this.cr * 1242172.0 / 1.3224846875E10;
        ycc.y1 = this.y1 + 128.0 + dblYChroma;
        ycc.y2 = this.y2 + 128.0 + dblYChroma;
        ycc.y3 = this.y3 + 128.0 + dblYChroma;
        ycc.y4 = this.y4 + 128.0 + dblYChroma;
        ycc.cb = this.cb * 1.05814197E8 / 1.05798775E8 + this.cr * -5608.0 / 1.05798775E8 + 128.0;
        ycc.cr = this.cb * 19492.0 / 1.05798775E8 + this.cr * 1.05791687E8 / 1.05798775E8 + 128.0;
    }

    public String toString() {
        return String.format("([%f, %f, %f, %f] %f, %f)", this.y1, this.y2, this.y3, this.y4, this.cb, this.cr);
    }
}

