/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo;

import java.util.Arrays;
import javax.annotation.Nonnull;

public class PsxRgb {
    public static final int PSX_VRAM_WORD_WIDTH = 1024;
    public static final int PSX_VRAM_HEIGHT = 512;
    private static final int[] CONVERT_5_TO_8_BIT = new int[]{0, 8, 16, 25, 33, 41, 49, 58, 66, 74, 82, 90, 99, 107, 115, 123, 132, 140, 148, 156, 165, 173, 181, 189, 197, 206, 214, 222, 230, 239, 247, 255};
    private static final int[] CONVERT_8_TO_5_BIT;
    private static final byte[] CONVERT_4_TO_8_BIT;
    private static final byte[] GRAY_16_PALETTE;
    private static final byte[] GRAY_256_PALETTE;

    public static int psxABGR1555toARGB8888(byte b8first, byte b8second, int iAlphaValue) {
        int iPsx16 = b8first & 0xFF | (b8second & 0xFF) << 8;
        return PsxRgb.psxABGR1555toARGB8888(iPsx16, iAlphaValue);
    }

    public static int psxABGR1555toARGB8888(int i16, int iAlphaValue) {
        int b = CONVERT_5_TO_8_BIT[i16 >>> 10 & 0x1F];
        int g = CONVERT_5_TO_8_BIT[i16 >>> 5 & 0x1F];
        int r = CONVERT_5_TO_8_BIT[i16 & 0x1F];
        int a = r == 0 && g == 0 && b == 0 ? ((i16 & 0x8000) == 0 ? 0 : -1) : ((i16 & 0x8000) == 0 ? -1 : (int)((byte)iAlphaValue));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static short ARGB8888toPsxABGR1555(int i) {
        int a = i >>> 24 & 0xFF;
        int r = CONVERT_8_TO_5_BIT[i >>> 16 & 0xFF];
        int g = CONVERT_8_TO_5_BIT[i >>> 8 & 0xFF];
        int b = CONVERT_8_TO_5_BIT[i & 0xFF];
        int bgr = b << 10 | g << 5 | r;
        if (a == 0) {
            bgr = 0;
            a = 0;
        } else {
            a = a == 255 ? (bgr == 0 ? 1 : 0) : 1;
        }
        return (short)(a << 15 | bgr);
    }

    @Nonnull
    private static byte[] build16GrayRgbaPalette() {
        byte[] abPalette = new byte[64];
        for (int i = 0; i < 16; ++i) {
            byte bClr;
            abPalette[i * 4 + 0] = bClr = CONVERT_4_TO_8_BIT[i];
            abPalette[i * 4 + 1] = bClr;
            abPalette[i * 4 + 2] = bClr;
            abPalette[i * 4 + 3] = -1;
        }
        return abPalette;
    }

    @Nonnull
    public static byte[] get16GrayRgbaPalette() {
        return Arrays.copyOf(GRAY_16_PALETTE, GRAY_16_PALETTE.length);
    }

    public static void fill16GrayRgbaPalette(@Nonnull byte[] abPalette) {
        System.arraycopy(GRAY_16_PALETTE, 0, abPalette, 0, GRAY_16_PALETTE.length);
    }

    @Nonnull
    private static byte[] build256GrayRgbaPalette() {
        byte[] abPalette = new byte[1024];
        for (int i = 0; i < 256; ++i) {
            byte bClr;
            abPalette[i * 4 + 0] = bClr = (byte)i;
            abPalette[i * 4 + 1] = bClr;
            abPalette[i * 4 + 2] = bClr;
            abPalette[i * 4 + 3] = -1;
        }
        return abPalette;
    }

    @Nonnull
    public static byte[] get256GrayRgbaPalette() {
        return Arrays.copyOf(GRAY_256_PALETTE, GRAY_256_PALETTE.length);
    }

    public static void fill256GrayRgbaPalette(@Nonnull byte[] abPalette) {
        System.arraycopy(GRAY_256_PALETTE, 0, abPalette, 0, GRAY_256_PALETTE.length);
    }

    static {
        assert (CONVERT_5_TO_8_BIT.length == 32);
        CONVERT_8_TO_5_BIT = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31};
        assert (CONVERT_8_TO_5_BIT.length == 256);
        CONVERT_4_TO_8_BIT = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
        assert (CONVERT_4_TO_8_BIT.length == 16);
        GRAY_16_PALETTE = PsxRgb.build16GrayRgbaPalette();
        GRAY_256_PALETTE = PsxRgb.build256GrayRgbaPalette();
    }
}

