/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.xa;

import javax.annotation.Nonnull;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.modules.xa.SectorXaAudio;

public class XaAudioFormat {
    private static final String FILE_NUMBER_KEY = "File";
    public final int iFileNumber;
    private static final String CHANNEL_KEY = "Channel";
    public final int iChannel;
    private static final String SAMPLES_PER_SEC_KEY = "Samples/Sec";
    public final int iSampleFramesPerSecond;
    private static final String BITSPERSAMPLE_KEY = "Bits/Sample";
    public final int iBitsPerSample;
    private static final String STEREO_KEY = "Stereo?";
    public final boolean blnIsStereo;

    public XaAudioFormat(int iFileNumber, int iChannel, int iSampleFramesPerSecond, int iBitsPerSample, boolean blnIsStereo) {
        if (!XaAudioFormat.validChannel(iChannel)) {
            throw new IllegalArgumentException("Channel " + iChannel + " is not between 0 and 255");
        }
        if (!XaAudioFormat.validFileNumber(iFileNumber)) {
            throw new IllegalArgumentException("Invalid file number " + iFileNumber);
        }
        if (!XaAudioFormat.validBitsPerSample(iBitsPerSample)) {
            throw new IllegalArgumentException("Bits/sample " + iBitsPerSample + " is not 4 or 8");
        }
        if (!XaAudioFormat.validSampleFramesPerSecond(iSampleFramesPerSecond)) {
            throw new IllegalArgumentException();
        }
        this.iFileNumber = iFileNumber;
        this.iChannel = iChannel;
        this.iSampleFramesPerSecond = iSampleFramesPerSecond;
        this.iBitsPerSample = iBitsPerSample;
        this.blnIsStereo = blnIsStereo;
    }

    public XaAudioFormat(@Nonnull SectorXaAudio xa) {
        this(xa.getFileNumber(), xa.getChannel(), xa.getSamplesPerSecond(), xa.getAdpcmBitsPerSample(), xa.isStereo());
    }

    public XaAudioFormat(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        this.blnIsStereo = fields.getYesNo(STEREO_KEY);
        this.iSampleFramesPerSecond = fields.getInt(SAMPLES_PER_SEC_KEY);
        this.iChannel = fields.getInt(CHANNEL_KEY);
        this.iFileNumber = fields.getInt(FILE_NUMBER_KEY);
        this.iBitsPerSample = fields.getInt(BITSPERSAMPLE_KEY);
        if (!XaAudioFormat.validChannel(this.iChannel)) {
            throw new LocalizedDeserializationFail(I.FIELD_HAS_INVALID_VALUE_NUM(CHANNEL_KEY, this.iChannel));
        }
        if (!XaAudioFormat.validFileNumber(this.iFileNumber)) {
            throw new LocalizedDeserializationFail(I.FIELD_HAS_INVALID_VALUE_NUM(FILE_NUMBER_KEY, this.iFileNumber));
        }
        if (!XaAudioFormat.validBitsPerSample(this.iBitsPerSample)) {
            throw new LocalizedDeserializationFail(I.FIELD_HAS_INVALID_VALUE_NUM(BITSPERSAMPLE_KEY, this.iBitsPerSample));
        }
        if (!XaAudioFormat.validSampleFramesPerSecond(this.iSampleFramesPerSecond)) {
            throw new LocalizedDeserializationFail(I.FIELD_HAS_INVALID_VALUE_NUM(SAMPLES_PER_SEC_KEY, this.iSampleFramesPerSecond));
        }
    }

    public static boolean validChannel(int iChannel) {
        return iChannel >= 0 && iChannel <= 255;
    }

    public static boolean validFileNumber(int iFileNumber) {
        return iFileNumber >= 0 && iFileNumber <= 255;
    }

    public static boolean validBitsPerSample(int iBitsPerSample) {
        return iBitsPerSample == 4 || iBitsPerSample == 8;
    }

    public static boolean validSampleFramesPerSecond(int iSampleFramesPerSecond) {
        return iSampleFramesPerSecond == 18900 || iSampleFramesPerSecond == 37800;
    }

    public void serialize(@Nonnull SerializedDiscItem fields) {
        fields.addNumber(FILE_NUMBER_KEY, this.iFileNumber);
        fields.addNumber(CHANNEL_KEY, this.iChannel);
        fields.addYesNo(STEREO_KEY, this.blnIsStereo);
        fields.addNumber(SAMPLES_PER_SEC_KEY, this.iSampleFramesPerSecond);
        fields.addNumber(BITSPERSAMPLE_KEY, this.iBitsPerSample);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + this.iFileNumber;
        hash = 11 * hash + this.iChannel;
        hash = 11 * hash + this.iSampleFramesPerSecond;
        hash = 11 * hash + this.iBitsPerSample;
        hash = 11 * hash + (this.blnIsStereo ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XaAudioFormat other = (XaAudioFormat)obj;
        return this.iFileNumber == other.iFileNumber && this.iChannel == other.iChannel && this.iSampleFramesPerSecond == other.iSampleFramesPerSecond && this.iBitsPerSample == other.iBitsPerSample && this.blnIsStereo == other.blnIsStereo;
    }

    public int calculateDiscSpeed(int iSectorStride) {
        return XaAudioFormat.calculateDiscSpeed(this.iSampleFramesPerSecond, this.blnIsStereo, this.iBitsPerSample, iSectorStride);
    }

    private static int calculateDiscSpeed(int iSamplesPerSecond, boolean blnStereo, int iBitsPerSample, int iSectorStride) {
        if (iSectorStride < 1) {
            return -1;
        }
        int iDiscSpeed_x_16128 = iSamplesPerSecond * (blnStereo ? 2 : 1) * iSectorStride * iBitsPerSample;
        if (iDiscSpeed_x_16128 == 1209600) {
            return 1;
        }
        if (iDiscSpeed_x_16128 == 2419200) {
            return 2;
        }
        return -1;
    }
}

