/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.xa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.XaAdpcmDecoder;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.xa.SectorXaAudio;
import jpsxdec.util.ByteArrayFPIS;
import jpsxdec.util.Fraction;

public class SectorXaAudioToAudioPacket
implements IdentifiedSectorListener<SectorXaAudio> {
    @Nonnull
    private final XaAdpcmDecoder _decoder;
    private final ByteArrayOutputStream _tempBuffer = new ByteArrayOutputStream();
    private final int _iFileNumber;
    private final int _iChannel;
    private final int _iSampleFramesPerSecond;
    @Nonnull
    private final AudioFormat _audioFormat;
    @CheckForNull
    private DecodedAudioPacket.Listener _listener;
    private final int _iStartSector;
    private final int _iEndSectorInclusive;

    public SectorXaAudioToAudioPacket(@Nonnull XaAdpcmDecoder decoder, int iSampleFramesPerSecond, int iFileNumber, int iChannel, int iStartSector, int iEndSectorInclusive) {
        this._decoder = decoder;
        this._audioFormat = decoder.getOutputFormat(iSampleFramesPerSecond);
        this._iSampleFramesPerSecond = iSampleFramesPerSecond;
        this._iFileNumber = iFileNumber;
        this._iChannel = iChannel;
        this._iStartSector = iStartSector;
        this._iEndSectorInclusive = iEndSectorInclusive;
    }

    public void setListener(@CheckForNull DecodedAudioPacket.Listener listener) {
        this._listener = listener;
    }

    @Override
    @Nonnull
    public Class<SectorXaAudio> getListeningFor() {
        return SectorXaAudio.class;
    }

    @Override
    public void feedSector(@Nonnull SectorXaAudio xaSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (xaSector.getSectorNumber() < this._iStartSector || xaSector.getSectorNumber() > this._iEndSectorInclusive) {
            return;
        }
        if (xaSector.getFileNumber() != this._iFileNumber || xaSector.getChannel() != this._iChannel || xaSector.getAdpcmBitsPerSample() != this._decoder.getAdpcmBitsPerSample() || xaSector.isStereo() != this._decoder.isStereo() || xaSector.getSamplesPerSecond() != this._iSampleFramesPerSecond) {
            return;
        }
        this._tempBuffer.reset();
        long lngSamplesWritten = this._decoder.getSampleFramesWritten();
        try {
            ByteArrayFPIS inStream = xaSector.getIdentifiedUserDataStream();
            this._decoder.decode(inStream, this._tempBuffer, xaSector.getSectorNumber());
        }
        catch (IOException ex) {
            throw new RuntimeException("Should not happen when reading/writing to/from byte stream", ex);
        }
        if (this._decoder.hadCorruption()) {
            log.log(Level.WARNING, I.XA_AUDIO_CORRUPTED(xaSector.getSectorNumber(), lngSamplesWritten));
        }
        if (this._listener != null) {
            DecodedAudioPacket packet = new DecodedAudioPacket(this._iChannel, this._audioFormat, new Fraction(xaSector.getSectorNumber()), this._tempBuffer.toByteArray());
            this._listener.audioPacketComplete(packet, log);
        }
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
    }

    public double getVolume() {
        return this._decoder.getVolume();
    }

    @Nonnull
    public AudioFormat getOutputFormat() {
        return this._audioFormat;
    }
}

