/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.xa;

import java.io.PrintStream;
import javax.annotation.Nonnull;
import jpsxdec.adpcm.XaAdpcmDecoder;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.cdreaders.XaAnalysis;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.util.ByteArrayFPIS;

public class SectorXaAudio
extends IdentifiedSector {
    private int _iSamplesPerSecond;
    private int _iBitsPerSample;
    private boolean _blnStereo;
    private int _iErrors;

    public SectorXaAudio(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        XaAnalysis analysis = XaAnalysis.analyze(cdSector);
        if (analysis == null) {
            return;
        }
        this._blnStereo = analysis.blnStereo;
        this._iSamplesPerSecond = analysis.iSamplesPerSecond;
        this._iBitsPerSample = analysis.iBitsPerSample;
        this._iErrors = analysis.iErrors;
        this.setProbability(analysis.iProbability);
    }

    public int getFileNumber() {
        CdSectorXaSubHeader sh = this.getCdSector().getSubHeader();
        assert (sh != null);
        return sh.getFileNumber();
    }

    public int getChannel() {
        CdSectorXaSubHeader sh = this.getCdSector().getSubHeader();
        assert (sh != null);
        return sh.getChannel();
    }

    public boolean isStereo() {
        return this._blnStereo;
    }

    public int getAdpcmBitsPerSample() {
        return this._iBitsPerSample;
    }

    public int getSamplesPerSecond() {
        return this._iSamplesPerSecond;
    }

    public int getDemuxPieceSize() {
        return super.getCdSector().getCdUserDataSize() - 20;
    }

    @Nonnull
    public ByteArrayFPIS getIdentifiedUserDataStream() {
        return new ByteArrayFPIS(super.getCdSector().getCdUserDataStream(), 0, this.getDemuxPieceSize());
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "XA Audio";
    }

    public int getSampleFrameCount() {
        return XaAdpcmDecoder.pcmSampleFramesGeneratedFromXaAdpcmSector(this._iBitsPerSample, this._blnStereo);
    }

    @Override
    public String toString() {
        CdSector cd = this.getCdSector();
        int iSize = cd.getCdUserDataSize();
        StringBuilder sb = new StringBuilder(String.format("%s %s %s %d bits/sample %d samples/sec %02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x", this.getTypeName(), super.toString(), this._blnStereo ? "Stereo" : "Mono", this._iBitsPerSample, this._iSamplesPerSecond, cd.readUserDataByte(iSize - 20), cd.readUserDataByte(iSize - 19), cd.readUserDataByte(iSize - 18), cd.readUserDataByte(iSize - 17), cd.readUserDataByte(iSize - 16), cd.readUserDataByte(iSize - 15), cd.readUserDataByte(iSize - 14), cd.readUserDataByte(iSize - 13), cd.readUserDataByte(iSize - 12), cd.readUserDataByte(iSize - 11), cd.readUserDataByte(iSize - 10), cd.readUserDataByte(iSize - 9), cd.readUserDataByte(iSize - 8), cd.readUserDataByte(iSize - 7), cd.readUserDataByte(iSize - 6), cd.readUserDataByte(iSize - 5), cd.readUserDataByte(iSize - 4), cd.readUserDataByte(iSize - 3), cd.readUserDataByte(iSize - 2), cd.readUserDataByte(iSize - 1)));
        if (this._iErrors > 0) {
            sb.append(" {").append(this._iErrors).append(" errors}");
        }
        if (this.isSilent()) {
            sb.append(" SILENT");
        }
        return sb.toString();
    }

    public boolean isSilent() {
        int iSndGrp = 0;
        int i = 0;
        while (iSndGrp < 18) {
            for (int j = 16; j < 128; ++j) {
                if (i + j >= this.getCdSector().getCdUserDataSize()) {
                    return false;
                }
                if (this.getCdSector().readUserDataByte(i + j) == 0) continue;
                return false;
            }
            ++iSndGrp;
            i += 128;
        }
        return true;
    }

    public int getErrorCount() {
        return this._iErrors;
    }

    public void printErrors(@Nonnull PrintStream ps) {
        ps.println("Sector " + this.getSectorNumber() + ": " + this._iErrors + " errors in XA sound parameters");
    }
}

