/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.xa;

import java.io.IOException;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.xa.SectorXaAudio;
import jpsxdec.modules.xa.SectorXaEmpty;
import jpsxdec.util.IOIterator;

public class SectorClaimToSectorXaAudio
implements SectorClaimSystem.SectorClaimer {
    @Override
    public void sectorRead(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> peekIt, @Nonnull ILocalizedLogger log) throws IOException, LoggedFailure {
        if (cs.isClaimed()) {
            return;
        }
        CdSector cdSector = cs.getSector();
        SectorXaEmpty emptySect = new SectorXaEmpty(cdSector);
        if (emptySect.getProbability() > 0) {
            cs.claim(emptySect);
        } else {
            SectorXaAudio possibleXa = new SectorXaAudio(cdSector);
            if (possibleXa.getProbability() > 0) {
                cs.claim(possibleXa);
            }
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
    }
}

