/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.xa;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jpsxdec.adpcm.XaAdpcmDecoder;
import jpsxdec.adpcm.XaAdpcmEncoder;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.DiscPatcher;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.modules.xa.SectorXaAudio;
import jpsxdec.modules.xa.SectorXaAudioToAudioPacket;
import jpsxdec.modules.xa.XaAudioFormat;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;
import jpsxdec.util.Misc;
import jpsxdec.util.TaskCanceledException;

public class DiscItemXaAudioStream
extends DiscItemAudioStream {
    private static final Logger LOG = Logger.getLogger(DiscItemXaAudioStream.class.getName());
    public static final String TYPE_ID = "XA";
    @Nonnull
    private final XaAudioFormat _format;
    private static final String STRIDE_KEY = "Sector stride";
    private final int _iSectorStride;
    private static final String DISC_SPEED_KEY = "Disc speed";
    private final int _iDiscSpeed;
    @CheckForNull
    private final BitSet _sectorsWithAudio;

    public DiscItemXaAudioStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull XaAudioFormat format, int iStride, @CheckForNull BitSet sectorsWithAudio) {
        super(cd, iStartSector, iEndSector);
        if (iStride != -1 && iStride != 1 && iStride != 2 && iStride != 4 && iStride != 8 && iStride != 16 && iStride != 32) {
            throw new IllegalArgumentException("Illegal audio sector stride " + iStride);
        }
        this._format = format;
        this._iSectorStride = iStride;
        if (this._iSectorStride == -1 || this._iSectorStride == 1) {
            this._iDiscSpeed = -1;
        } else {
            this._iDiscSpeed = this._format.calculateDiscSpeed(this._iSectorStride);
            if (this._iDiscSpeed < 1) {
                throw new RuntimeException(String.format("Disc speed calc doesn't add up: Samples/sec %d Stereo %s Bits/sample %s Stride %d", this._format.iSampleFramesPerSecond, String.valueOf(this._format.blnIsStereo), this._format.iBitsPerSample, this._iSectorStride));
            }
        }
        this._sectorsWithAudio = sectorsWithAudio;
    }

    public DiscItemXaAudioStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._format = new XaAudioFormat(fields);
        this._iSectorStride = fields.getInt(STRIDE_KEY);
        if (this._iSectorStride != -1 && this._iSectorStride != 1 && this._iSectorStride != 2 && this._iSectorStride != 4 && this._iSectorStride != 8 && this._iSectorStride != 16 && this._iSectorStride != 32) {
            throw new LocalizedDeserializationFail(I.FIELD_HAS_INVALID_VALUE_NUM(STRIDE_KEY, this._iSectorStride));
        }
        String sDiscSpeed = fields.getString(DISC_SPEED_KEY);
        if ("1x".equals(sDiscSpeed)) {
            this._iDiscSpeed = 1;
        } else if ("2x".equals(sDiscSpeed)) {
            this._iDiscSpeed = 2;
        } else if ("?".equals(sDiscSpeed)) {
            this._iDiscSpeed = -1;
        } else {
            throw new LocalizedDeserializationFail(I.FIELD_HAS_INVALID_VALUE_STR(DISC_SPEED_KEY, sDiscSpeed));
        }
        this._sectorsWithAudio = null;
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem fields = super.serialize();
        this._format.serialize(fields);
        fields.addNumber(STRIDE_KEY, this._iSectorStride);
        switch (this._iDiscSpeed) {
            case 1: {
                fields.addString(DISC_SPEED_KEY, "1x");
                break;
            }
            case 2: {
                fields.addString(DISC_SPEED_KEY, "2x");
                break;
            }
            default: {
                fields.addString(DISC_SPEED_KEY, "?");
            }
        }
        return fields;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    @Nonnull
    public DiscItem.GeneralType getType() {
        return DiscItem.GeneralType.Audio;
    }

    public int getChannel() {
        return this._format.iChannel;
    }

    @Override
    public boolean isStereo() {
        return this._format.blnIsStereo;
    }

    public int getSectorStride() {
        return this._iSectorStride;
    }

    @Override
    public int getSectorsPastEnd() {
        return this._iSectorStride - 1;
    }

    @Override
    public int getDiscSpeed() {
        return this._iDiscSpeed;
    }

    @Override
    @Nonnull
    public ILocalizedMessage getInterestingDescription() {
        Date secs = Misc.dateFromSeconds(Math.max((int)this.getApproxDuration(), 1));
        return I.GUI_AUDIO_DESCRIPTION(secs, this._format.iSampleFramesPerSecond, this._format.blnIsStereo ? 2 : 1);
    }

    @Override
    public int getSampleFramesPerSecond() {
        return this._format.iSampleFramesPerSecond;
    }

    @Override
    public int getPresentationStartSector() {
        return this.getStartSector();
    }

    @Override
    public double getApproxDuration() {
        return (double)this.getSampleFrameCount() / (double)this._format.iSampleFramesPerSecond;
    }

    @Override
    public long getSampleFrameCount() {
        int iAudioSectorCount = this.getAudioSectorCount();
        return (long)iAudioSectorCount * (long)XaAdpcmDecoder.pcmSampleFramesGeneratedFromXaAdpcmSector(this._format.iBitsPerSample, this._format.blnIsStereo);
    }

    private int getAudioSectorCount() {
        return DiscItemXaAudioStream.calculateAudioSectorCount(this.getSectorLength(), this._iSectorStride);
    }

    private static int calculateAudioSectorCount(int iSectorLength, int iSectorStride) {
        int iAudioSectorCount;
        if (iSectorLength == 1) {
            iAudioSectorCount = 1;
        } else {
            assert (iSectorStride > 0);
            iAudioSectorCount = iSectorLength / iSectorStride + 1;
        }
        return iAudioSectorCount;
    }

    public boolean isConfirmedToBeSilent() {
        if (this._sectorsWithAudio == null) {
            return false;
        }
        return this._sectorsWithAudio.isEmpty();
    }

    @Override
    public String toString() {
        if (this.isConfirmedToBeSilent()) {
            return super.toString() + " // (SILENT)";
        }
        return super.toString();
    }

    @Override
    @Nonnull
    public ISectorAudioDecoder makeDecoder(double dblVolume) {
        return new XAConverter(dblVolume);
    }

    @Nonnull
    public XaAdpcmDecoder makeXaDecoder(double dblVolume) {
        return new XaAdpcmDecoder(this._format.iBitsPerSample, this.isStereo(), dblVolume);
    }

    @Nonnull
    public DiscItemXaAudioStream[] split(int iBeforeSector) {
        if (iBeforeSector <= this.getStartSector() || iBeforeSector > this.getEndSector()) {
            throw new IllegalArgumentException("Split sector outside the bounds of XA audio stream");
        }
        int iFirstEnd = iBeforeSector - (iBeforeSector - this.getStartSector() - 1) % this._iSectorStride - 1;
        int iSecondStart = iBeforeSector + (this._iSectorStride - (iBeforeSector - this.getStartSector() - 1) % this._iSectorStride) - 1;
        BitSet firstSectorsWithAudio = null;
        BitSet secondSectorsWithAudio = null;
        if (this._sectorsWithAudio != null) {
            int iSectorsInFirst = DiscItemXaAudioStream.calculateAudioSectorCount(iFirstEnd - this.getStartSector() + 1, this._iSectorStride);
            if (iSectorsInFirst >= this._sectorsWithAudio.length()) {
                firstSectorsWithAudio = this._sectorsWithAudio;
                secondSectorsWithAudio = new BitSet();
            } else {
                firstSectorsWithAudio = this._sectorsWithAudio.get(0, iSectorsInFirst);
                secondSectorsWithAudio = this._sectorsWithAudio.get(iSectorsInFirst, this._sectorsWithAudio.length());
            }
        }
        DiscItemXaAudioStream first = new DiscItemXaAudioStream(this.getSourceCd(), this.getStartSector(), iFirstEnd, this._format, this._iSectorStride, firstSectorsWithAudio);
        DiscItemXaAudioStream second = new DiscItemXaAudioStream(this.getSourceCd(), iSecondStart, this.getEndSector(), this._format, this._iSectorStride, secondSectorsWithAudio);
        return new DiscItemXaAudioStream[]{first, second};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(@Nonnull ProgressLogger pl, @Nonnull File audioFile) throws IOException, UnsupportedAudioFileException, LocalizedIncompatibleException, CdFileSectorReader.CdReadException, DiscPatcher.WritePatchException, TaskCanceledException {
        AudioInputStream ais = AudioSystem.getAudioInputStream(audioFile);
        try {
            XaAdpcmEncoder encoder;
            AudioFormat fmt = ais.getFormat();
            boolean blnFormatEquals = Math.abs(fmt.getSampleRate() - (float)this._format.iSampleFramesPerSecond) < 1.0f;
            blnFormatEquals &= this.isStereo() && fmt.getChannels() == 2 || !this.isStereo() && fmt.getChannels() == 1;
            if (!(blnFormatEquals &= ais.getFrameLength() == this.getSampleFrameCount())) {
                throw new LocalizedIncompatibleException(I.AUDIO_REPLACE_FORMAT_MISMATCH(ais.getFrameLength(), fmt.getChannels(), fmt.getSampleRate(), this.getSampleFrameCount(), this.isStereo() ? 2 : 1, this.getSampleFramesPerSecond()));
            }
            try {
                encoder = new XaAdpcmEncoder(ais, this._format.iBitsPerSample);
            }
            catch (IncompatibleException ex) {
                throw new RuntimeException("This should have been checked above", ex);
            }
            try {
                SectorClaimSystem it = this.createClaimSystem();
                pl.progressStart(this.getSectorLength());
                int iSector = 0;
                while (it.hasNext()) {
                    IIdentifiedSector origIdSect = it.next(pl);
                    if (origIdSect instanceof SectorXaAudio && this.isPartOfStream((SectorXaAudio)origIdSect)) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        long lngSampleFramesReadBefore = encoder.getSampleFramesRead();
                        pl.log(Level.INFO, I.WRITING_SAMPLES_TO_SECTOR(lngSampleFramesReadBefore, origIdSect.toString()));
                        encoder.encode1Sector(baos);
                        assert (!encoder.isEof());
                        pl.log(Level.INFO, I.CMD_PATCHING_SECTOR_DESCRIPTION(origIdSect.toString()));
                        if (pl.isSeekingEvent()) {
                            pl.event(I.CMD_PATCHING_SECTOR_NUMBER(origIdSect.getSectorNumber()));
                        }
                        CdSector origSect = origIdSect.getCdSector();
                        this.getSourceCd().addPatch(origSect.getSectorIndexFromStart(), 0, baos.toByteArray());
                        pl.progressUpdate(iSector);
                    }
                    ++iSector;
                }
                it.close(pl);
                pl.progressEnd();
            }
            finally {
                IO.closeSilently(encoder, LOG);
            }
        }
        finally {
            IO.closeSilently(ais, LOG);
        }
    }

    public void replaceXa(@Nonnull ProgressLogger pl, @Nonnull DiscItemXaAudioStream other) throws LocalizedIncompatibleException, CdFileSectorReader.CdReadException, DiscPatcher.WritePatchException, TaskCanceledException {
        pl.log(Level.INFO, I.CMD_PATCHING_DISC_ITEM(this.toString()));
        pl.log(Level.INFO, I.CMD_PATCHING_WITH_DISC_ITEM(other.toString()));
        if (this.getSampleFramesPerSecond() != other.getSampleFramesPerSecond() || this._format.blnIsStereo != other._format.blnIsStereo || this._format.iBitsPerSample != other._format.iBitsPerSample || this.getAudioSectorCount() != other.getAudioSectorCount()) {
            throw new LocalizedIncompatibleException(I.XA_REPLACE_FORMAT_MISMATCH(other._format.iBitsPerSample, other.getSampleFrameCount(), other._format.blnIsStereo ? 2 : 1, other.getSampleFramesPerSecond(), this._format.iBitsPerSample, this.getSampleFrameCount(), this._format.blnIsStereo ? 2 : 1, this.getSampleFramesPerSecond()));
        }
        SectorClaimSystem origIt = this.createClaimSystem();
        SectorClaimSystem patchIt = other.createClaimSystem();
        pl.progressStart(this.getSectorLength());
        int iSector = 0;
        while (origIt.hasNext()) {
            IIdentifiedSector origIdSect = origIt.next(pl);
            if (origIdSect instanceof SectorXaAudio && this.isPartOfStream((SectorXaAudio)origIdSect)) {
                SectorXaAudio origXaSect = (SectorXaAudio)origIdSect;
                IIdentifiedSector patchIdSect = null;
                do {
                    if (patchIt.hasNext()) continue;
                    throw new LocalizedIncompatibleException(I.XA_COPY_REPLACE_SRC_XA_EXHAUSTED());
                } while (!((patchIdSect = patchIt.next(pl)) instanceof SectorXaAudio) || !other.isPartOfStream((SectorXaAudio)patchIdSect));
                SectorXaAudio patchXaSect = (SectorXaAudio)patchIdSect;
                pl.log(Level.INFO, I.CMD_PATCHING_SECTOR_DESCRIPTION(origXaSect.toString()));
                pl.log(Level.INFO, I.CMD_PATCHING_WITH_SECTOR_DESCRIPTION(patchXaSect.toString()));
                if (pl.isSeekingEvent()) {
                    pl.event(I.CMD_PATCHING_SECTOR_NUMBER(origIdSect.getSectorNumber()));
                }
                byte[] abPatchData = patchXaSect.getCdSector().getCdUserDataCopy();
                this.getSourceCd().addPatch(origXaSect.getSectorNumber(), 0, abPatchData);
                pl.progressUpdate(iSector);
            }
            ++iSector;
        }
        pl.progressEnd();
    }

    public boolean isPartOfStream(@Nonnull SectorXaAudio xaSector) {
        return xaSector.getSectorNumber() >= this.getStartSector() && xaSector.getSectorNumber() <= this.getEndSector() && this._format.equals(new XaAudioFormat(xaSector));
    }

    private class XAConverter
    implements ISectorAudioDecoder {
        @Nonnull
        private final SectorXaAudioToAudioPacket __xa2ap;

        public XAConverter(double dblVolume) {
            this.__xa2ap = new SectorXaAudioToAudioPacket(DiscItemXaAudioStream.this.makeXaDecoder(dblVolume), ((DiscItemXaAudioStream)DiscItemXaAudioStream.this)._format.iSampleFramesPerSecond, ((DiscItemXaAudioStream)DiscItemXaAudioStream.this)._format.iFileNumber, ((DiscItemXaAudioStream)DiscItemXaAudioStream.this)._format.iChannel, DiscItemXaAudioStream.this.getStartSector(), DiscItemXaAudioStream.this.getEndSector());
        }

        @Override
        public void setAudioListener(@Nonnull DecodedAudioPacket.Listener listener) {
            this.__xa2ap.setListener(listener);
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            scs.addIdListener(this.__xa2ap);
        }

        @Override
        public double getVolume() {
            return this.__xa2ap.getVolume();
        }

        @Override
        public int getSampleFramesPerSecond() {
            return ((DiscItemXaAudioStream)DiscItemXaAudioStream.this)._format.iSampleFramesPerSecond;
        }

        @Override
        @Nonnull
        public AudioFormat getOutputFormat() {
            return this.__xa2ap.getOutputFormat();
        }

        @Override
        public int getEndSector() {
            return DiscItemXaAudioStream.this.getEndSector();
        }

        @Override
        public int getStartSector() {
            return DiscItemXaAudioStream.this.getStartSector();
        }

        @Override
        public int getAbsolutePresentationStartSector() {
            return DiscItemXaAudioStream.this.getPresentationStartSector();
        }

        @Override
        public int getDiscSpeed() {
            return DiscItemXaAudioStream.this.getDiscSpeed();
        }
    }
}

