/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.xa;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.xa.DiscItemXaAudioStream;
import jpsxdec.modules.xa.SectorXaAudio;
import jpsxdec.modules.xa.XaAudioFormat;
import jpsxdec.util.Misc;

public class DiscIndexerXaAudio
extends DiscIndexer
implements IdentifiedSectorListener<IIdentifiedSector> {
    @Nonnull
    private final ILocalizedLogger _errLog;
    private final TreeMap<FileChannel, AudioStreamIndex> _channels = new TreeMap();

    public DiscIndexerXaAudio(@Nonnull ILocalizedLogger errLog) {
        this._errLog = errLog;
    }

    @Override
    public void listPostProcessing(Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex index) {
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem serial) throws LocalizedDeserializationFail {
        if ("XA".equals(serial.getType())) {
            return new DiscItemXaAudioStream(this.getCd(), serial);
        }
        return null;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        scs.addIdListener(this);
    }

    @Override
    @Nonnull
    public Class<IIdentifiedSector> getListeningFor() {
        return IIdentifiedSector.class;
    }

    @Override
    public void feedSector(@Nonnull IIdentifiedSector idSector, @Nonnull ILocalizedLogger log) {
        FileChannel fc;
        AudioStreamIndex audStream;
        if (idSector instanceof SectorXaAudio) {
            SectorXaAudio xaSector = (SectorXaAudio)idSector;
            FileChannel fc2 = new FileChannel(xaSector);
            AudioStreamIndex audStream2 = this._channels.get(fc2);
            if (audStream2 == null) {
                this._channels.put(fc2, new AudioStreamIndex(xaSector, this._errLog));
            } else if (!audStream2.sectorRead(xaSector)) {
                audStream2.createMediaItem(this);
                this._channels.put(fc2, new AudioStreamIndex(xaSector, this._errLog));
            }
        }
        Iterator<Map.Entry<FileChannel, AudioStreamIndex>> it = this._channels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FileChannel, AudioStreamIndex> channelStream = it.next();
            AudioStreamIndex s = channelStream.getValue();
            if (s == null || !s.ended(idSector.getSectorNumber())) continue;
            s.createMediaItem(this);
            it.remove();
        }
        CdSectorXaSubHeader sh = idSector.getCdSector().getSubHeader();
        if (sh != null && sh.getSubMode().getEndOfFile() && (audStream = this._channels.get(fc = new FileChannel(sh.getFileNumber(), sh.getChannel()))) != null) {
            audStream.createMediaItem(this);
            this._channels.remove(fc);
        }
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) {
        for (AudioStreamIndex audStream : this._channels.values()) {
            audStream.createMediaItem(this);
        }
        this._channels.clear();
    }

    private static class FileChannel
    implements Comparable<FileChannel> {
        public final int iFileNumber;
        public final int iChanel;

        public FileChannel(int iFileNumber, int iChanel) {
            this.iFileNumber = iFileNumber;
            this.iChanel = iChanel;
        }

        public FileChannel(@Nonnull SectorXaAudio xaSector) {
            this.iFileNumber = xaSector.getFileNumber();
            this.iChanel = xaSector.getChannel();
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + this.iFileNumber;
            hash = 89 * hash + this.iChanel;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FileChannel other = (FileChannel)obj;
            return this.iFileNumber == other.iFileNumber && this.iChanel == other.iChanel;
        }

        @Override
        public int compareTo(FileChannel o) {
            int i = Misc.intCompare(this.iFileNumber, o.iFileNumber);
            return i != 0 ? i : Misc.intCompare(this.iChanel, o.iChanel);
        }

        public String toString() {
            return "File:" + this.iFileNumber + " Channel:" + this.iChanel;
        }
    }

    private static class AudioStreamIndex {
        private final int _iStartSector;
        @Nonnull
        private final XaAudioFormat _format;
        private final BitSet _sectorsWithAudio = new BitSet();
        private int _iSectorCount;
        private int _iEndSector;
        private int _iAudioStride = -1;
        @Nonnull
        private final ILocalizedLogger _errLog;

        public AudioStreamIndex(@Nonnull SectorXaAudio first, @Nonnull ILocalizedLogger errLog) {
            this._format = new XaAudioFormat(first);
            this._iEndSector = this._iStartSector = first.getSectorNumber();
            this._iSectorCount = 1;
            if (!first.isSilent()) {
                this._sectorsWithAudio.set(0);
            }
            this._errLog = errLog;
        }

        public boolean sectorRead(@Nonnull SectorXaAudio nextXa) {
            int iDiscSpeed;
            if (!this._format.equals(new XaAudioFormat(nextXa))) {
                return false;
            }
            int iStride = nextXa.getSectorNumber() - this._iEndSector;
            if (iStride != 1 && (iDiscSpeed = this._format.calculateDiscSpeed(iStride)) < 0) {
                return false;
            }
            if (this._iAudioStride < 0) {
                this._iAudioStride = iStride;
            } else if (iStride != this._iAudioStride) {
                return false;
            }
            this._iEndSector = nextXa.getSectorNumber();
            if (!nextXa.isSilent()) {
                this._sectorsWithAudio.set(this._iSectorCount);
            }
            ++this._iSectorCount;
            return true;
        }

        public void createMediaItem(@Nonnull DiscIndexerXaAudio adder) {
            if (this._iSectorCount == 1 && this._sectorsWithAudio.isEmpty()) {
                this._errLog.log(Level.INFO, I.IGNORING_SILENT_XA_SECTOR(this._iStartSector, this._format.iChannel));
                return;
            }
            adder.addDiscItem(new DiscItemXaAudioStream(adder.getCd(), this._iStartSector, this._iEndSector, this._format, this._iAudioStride, this._sectorsWithAudio));
        }

        public boolean ended(int iSectorNum) {
            return this._iAudioStride >= 0 && iSectorNum > this._iEndSector + this._iAudioStride;
        }
    }
}

