/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased.fps;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.Misc;

public class WholeNumberSectorsPerFrame {
    private int _iPrevFrameEndSector;
    @CheckForNull
    private TreeSet<SectorsPerFrameFromStart> _startingPoints;

    public WholeNumberSectorsPerFrame(int iFirstFrameEndSector) {
        if (iFirstFrameEndSector < 0) {
            throw new IllegalArgumentException();
        }
        this._iPrevFrameEndSector = iFirstFrameEndSector;
    }

    public boolean matchesNextVideo(int iNextFrameStartSector, int iNextFrameEndSector) {
        boolean blnRet;
        if (iNextFrameStartSector <= this._iPrevFrameEndSector || iNextFrameEndSector <= this._iPrevFrameEndSector) {
            throw new IllegalArgumentException();
        }
        if (this._startingPoints == null) {
            this._startingPoints = new TreeSet();
            for (int iPossibleFrame2StartSector = this._iPrevFrameEndSector + 1; iPossibleFrame2StartSector <= iNextFrameStartSector; ++iPossibleFrame2StartSector) {
                this._startingPoints.add(new SectorsPerFrameFromStart(iPossibleFrame2StartSector));
            }
            blnRet = true;
        } else if (this._startingPoints.isEmpty()) {
            blnRet = false;
        } else {
            blnRet = false;
            Iterator<SectorsPerFrameFromStart> it = this._startingPoints.iterator();
            while (it.hasNext()) {
                SectorsPerFrameFromStart possibleStart = it.next();
                if (possibleStart.update(this._iPrevFrameEndSector, iNextFrameStartSector)) {
                    blnRet = true;
                    continue;
                }
                it.remove();
            }
        }
        this._iPrevFrameEndSector = iNextFrameEndSector;
        return blnRet;
    }

    @CheckForNull
    public int[] getPossibleSectorsPerFrame() {
        if (this._startingPoints == null) {
            return null;
        }
        if (this._startingPoints.isEmpty()) {
            return new int[]{1};
        }
        return WholeNumberSectorsPerFrame.integerCollectionToIntArray(WholeNumberSectorsPerFrame.removeFactors(this.getCombined()));
    }

    @CheckForNull
    int[] getAllPossibleSectorsPerFrame() {
        if (this._startingPoints == null) {
            return null;
        }
        if (this._startingPoints.isEmpty()) {
            return new int[]{1};
        }
        return WholeNumberSectorsPerFrame.integerCollectionToIntArray(this.getCombined());
    }

    @Nonnull
    private TreeSet<Integer> getCombined() {
        TreeSet<Integer> unique = new TreeSet<Integer>();
        for (SectorsPerFrameFromStart startAndInterval : this._startingPoints) {
            if (startAndInterval._possibleSectorsPerFrame == null) continue;
            unique.addAll(startAndInterval._possibleSectorsPerFrame);
        }
        return unique;
    }

    @Nonnull
    private static TreeSet<Integer> removeFactors(@Nonnull TreeSet<Integer> sourceValues) {
        TreeSet copy = (TreeSet)sourceValues.clone();
        Iterator it = copy.iterator();
        block0: while (it.hasNext()) {
            Integer oi = (Integer)it.next();
            Integer[] aioValues = copy.toArray(new Integer[copy.size()]);
            int i = aioValues.length - 1;
            while (aioValues[i].intValue() != oi.intValue()) {
                if (aioValues[i] % oi == 0) {
                    it.remove();
                    continue block0;
                }
                --i;
            }
        }
        return copy;
    }

    @CheckForNull
    private static int[] integerCollectionToIntArray(@Nonnull Collection<Integer> intIterable) {
        if (intIterable.isEmpty()) {
            return null;
        }
        int[] ai = new int[intIterable.size()];
        int i = 0;
        for (Integer oi : intIterable) {
            ai[i] = oi;
            ++i;
        }
        return ai;
    }

    private static class SectorsPerFrameFromStart
    implements Comparable<SectorsPerFrameFromStart> {
        private final int _iFrame2StartSector;
        @CheckForNull
        private TreeSet<Integer> _possibleSectorsPerFrame;

        public SectorsPerFrameFromStart(int iFrame2StartSector) {
            this._iFrame2StartSector = iFrame2StartSector;
        }

        private boolean update(int iLastSectorOfPreviousFrame, int iFirstSectorOfNewFrame) {
            int iLastSectOfPrevFrmFromStart = iLastSectorOfPreviousFrame + 1 - this._iFrame2StartSector;
            int iFirstSectOfNewFrmFromStart = iFirstSectorOfNewFrame - this._iFrame2StartSector;
            if (this._possibleSectorsPerFrame == null) {
                this._possibleSectorsPerFrame = new TreeSet();
                for (int i = 2; i <= iFirstSectOfNewFrmFromStart; ++i) {
                    this._possibleSectorsPerFrame.add(i);
                }
            } else if (this._possibleSectorsPerFrame.isEmpty()) {
                return false;
            }
            TreeSet<Integer> retainedPossibleSPF = new TreeSet<Integer>();
            block1: for (Integer oiSectorsPerFrame : this._possibleSectorsPerFrame) {
                for (int iModCheck = iLastSectOfPrevFrmFromStart; iModCheck <= iFirstSectOfNewFrmFromStart; ++iModCheck) {
                    if (iModCheck % oiSectorsPerFrame != 0) continue;
                    retainedPossibleSPF.add(oiSectorsPerFrame);
                    continue block1;
                }
            }
            this._possibleSectorsPerFrame = retainedPossibleSPF;
            return this._possibleSectorsPerFrame.size() > 0;
        }

        @Override
        public int compareTo(SectorsPerFrameFromStart o) {
            return Misc.intCompare(this._iFrame2StartSector, o._iFrame2StartSector);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + this._iFrame2StartSector;
            hash = 29 * hash + (this._possibleSectorsPerFrame != null ? this._possibleSectorsPerFrame.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((SectorsPerFrameFromStart)obj) == 0;
        }
    }
}

