/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased.fps;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jpsxdec.modules.video.sectorbased.fps.InconsistentFrameSequence;
import jpsxdec.modules.video.sectorbased.fps.WholeNumberSectorsPerFrame;
import jpsxdec.util.Fraction;

public class StrFrameRateCalc {
    private static final Logger LOG = Logger.getLogger(StrFrameRateCalc.class.getName());
    @CheckForNull
    private WholeNumberSectorsPerFrame _wholeFrameRate;
    @CheckForNull
    private LinkedList<InconsistentFrameSequence> _inconsistentFrameRate;

    public StrFrameRateCalc(int iFirstFrameStartSector, int iFirstFrameEndSector) {
        this._wholeFrameRate = new WholeNumberSectorsPerFrame(iFirstFrameEndSector);
        this._inconsistentFrameRate = InconsistentFrameSequence.generate(iFirstFrameStartSector, iFirstFrameEndSector);
    }

    public void addFrame(int iNextFrameStartSector, int iNextFrameEndSector) {
        if (this._wholeFrameRate != null && !this._wholeFrameRate.matchesNextVideo(iNextFrameStartSector, iNextFrameEndSector)) {
            this._wholeFrameRate = null;
        }
        if (this._inconsistentFrameRate != null) {
            Iterator it = this._inconsistentFrameRate.iterator();
            while (it.hasNext()) {
                if (((InconsistentFrameSequence)it.next()).matchesNextVideo(iNextFrameStartSector, iNextFrameEndSector)) continue;
                it.remove();
            }
            if (this._inconsistentFrameRate.size() == 0) {
                this._inconsistentFrameRate = null;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._wholeFrameRate != null || this._inconsistentFrameRate != null) {
            sb.append("Possible frame rates: ");
            if (this._wholeFrameRate != null) {
                sb.append(Arrays.toString(this._wholeFrameRate.getAllPossibleSectorsPerFrame()));
            }
            if (this._inconsistentFrameRate != null) {
                sb.append(this._inconsistentFrameRate);
            }
        } else {
            sb.append("No matching variable rates.");
        }
        return sb.toString();
    }

    @CheckForNull
    public Fraction getSectorsPerFrame() {
        StringBuilder sbLog = null;
        if (LOG.isLoggable(Level.INFO)) {
            sbLog = new StringBuilder(this.toString());
        }
        Fraction sectorsPerFrame = null;
        if (this._wholeFrameRate != null) {
            int[] aiPossibleSectorsPerFrame = this._wholeFrameRate.getPossibleSectorsPerFrame();
            if (aiPossibleSectorsPerFrame != null) {
                sectorsPerFrame = new Fraction(aiPossibleSectorsPerFrame[aiPossibleSectorsPerFrame.length - 1]);
            }
        } else if (this._inconsistentFrameRate != null) {
            for (InconsistentFrameSequence frameSeq : this._inconsistentFrameRate) {
                Fraction frmSeqSpf = frameSeq.getSectorsPerFrame();
                if (sectorsPerFrame == null) {
                    sectorsPerFrame = frmSeqSpf;
                    continue;
                }
                if (frmSeqSpf.getNumerator() >= sectorsPerFrame.getNumerator()) continue;
                sectorsPerFrame = frmSeqSpf;
            }
        }
        if (sbLog != null) {
            if (sectorsPerFrame != null) {
                sbLog.append(" Chose ").append(sectorsPerFrame);
            }
            LOG.info(sbLog.toString());
        }
        return sectorsPerFrame;
    }
}

