/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased.fps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.Fraction;

public class InconsistentFrameSequence {
    private static final Logger LOG = Logger.getLogger(InconsistentFrameSequence.class.getName());
    private static final String[] FPS_LISTS = new String[]{"20FPS_A8.dat", "20FPS_A16.dat", "NTSC20_A8.dat", "NTSC20_A8-SB.dat", "NTSC15_A8-100,999.dat", "NTSC15_A8-101,1000.dat", "LUNAR2_24FPS_A16(S43).dat", "LUNAR2_24FPS_A16(S56).dat", "DREDD15FPS.dat"};
    @Nonnull
    private BufferedReader _reader;
    @Nonnull
    private final String _sSourceResource;
    @Nonnull
    private final HeaderParse _header;
    private int _iLoopStartSector;

    @Nonnull
    public static LinkedList<InconsistentFrameSequence> generate(int iFirstFrameStartSector, int iFirstFrameEndSector) {
        LinkedList<InconsistentFrameSequence> possibles = new LinkedList<InconsistentFrameSequence>();
        for (String sResource : FPS_LISTS) {
            possibles.add(new InconsistentFrameSequence(sResource));
        }
        return possibles;
    }

    private InconsistentFrameSequence(@Nonnull String sSourceResource) {
        this._sSourceResource = sSourceResource;
        try {
            InputStream is = InconsistentFrameSequence.class.getResourceAsStream(sSourceResource);
            if (is == null) {
                throw new RuntimeException("Unable to find inconsistent frame resource " + sSourceResource);
            }
            this._reader = new BufferedReader(new InputStreamReader(is));
            String sLine = this._reader.readLine();
            this._header = new HeaderParse(sLine);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @CheckForNull
    private String readNextLine() throws IOException {
        String sLine = this._reader.readLine();
        if (sLine == null) {
            if (this._header.iLoopSector >= 0) {
                this._reader.close();
                InputStream is = InconsistentFrameSequence.class.getResourceAsStream(this._sSourceResource);
                this._reader = new BufferedReader(new InputStreamReader(is));
                this._reader.readLine();
                sLine = this._reader.readLine();
                this._iLoopStartSector += this._header.iLoopSector;
            } else {
                LOG.log(Level.WARNING, "Movie is longer than sequence {0}", this._sSourceResource);
            }
        }
        return sLine;
    }

    public boolean matchesNextVideo(int iFrameStartSector, int iFrameEndSector) {
        try {
            LineParse currentLineFrame;
            do {
                String sLine;
                if ((sLine = this.readNextLine()) == null) {
                    return false;
                }
                currentLineFrame = new LineParse(sLine);
            } while (currentLineFrame.iFrameStartSector + this._iLoopStartSector < iFrameStartSector);
            return currentLineFrame.iFrameStartSector + this._iLoopStartSector <= iFrameStartSector && currentLineFrame.iFrameEndSector + this._iLoopStartSector >= iFrameEndSector;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    public Fraction getSectorsPerFrame() {
        return new Fraction(this._header.iSectors, this._header.iPerFrame);
    }

    public String toString() {
        return this._sSourceResource;
    }

    static class LineParse {
        public final int iFrameStartSector;
        public final int iFrameEndSector;

        public LineParse(@Nonnull String sLine) {
            String[] asValues = sLine.split("\\D+");
            this.iFrameStartSector = Integer.parseInt(asValues[0]);
            this.iFrameEndSector = Integer.parseInt(asValues[1]);
        }
    }

    private static class HeaderParse {
        public final int iSectors;
        public final int iPerFrame;
        public final int iAudStart;
        public final int iAudStride;
        public final int iLoopSector;

        public HeaderParse(@Nonnull String sLine) {
            String[] asValues = sLine.split("\\D+");
            this.iSectors = Integer.parseInt(asValues[0]);
            this.iPerFrame = Integer.parseInt(asValues[1]);
            this.iAudStart = Integer.parseInt(asValues[2]);
            this.iAudStride = Integer.parseInt(asValues[3]);
            this.iLoopSector = asValues.length > 4 ? Integer.parseInt(asValues[4]) : -1;
        }
    }
}

