/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.sectorbased.DemuxedFrameWithNumberAndDims;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;
import jpsxdec.modules.video.sectorbased.IVideoSectorWithFrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameBuilder;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.DemuxedData;

public class VideoSectorWithFrameNumberDemuxer
implements ISelfDemuxingVideoSector.IDemuxer {
    @Nonnull
    private final SectorBasedFrameBuilder<IVideoSectorWithFrameNumber> _bldr;
    private final int _iWidth;
    private final int _iHeight;

    public VideoSectorWithFrameNumberDemuxer(@Nonnull IVideoSectorWithFrameNumber firstChunk, @Nonnull ILocalizedLogger log) {
        this._bldr = new SectorBasedFrameBuilder<IVideoSectorWithFrameNumber>(firstChunk, firstChunk.getChunkNumber(), firstChunk.getChunksInFrame(), firstChunk.getSectorNumber(), firstChunk.getHeaderFrameNumber(), log);
        this._iWidth = firstChunk.getWidth();
        this._iHeight = firstChunk.getHeight();
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public int getHeaderFrameNumber() {
        return this._bldr.getHeaderFrameNumber();
    }

    @Override
    public boolean addSectorIfPartOfFrame(@Nonnull ISelfDemuxingVideoSector sector) {
        if (!(sector instanceof IVideoSectorWithFrameNumber)) {
            return false;
        }
        return this.addSectorWithFameNumberIfPartOfFrame((IVideoSectorWithFrameNumber)sector);
    }

    public boolean addSectorWithFameNumberIfPartOfFrame(@Nonnull IVideoSectorWithFrameNumber chunk) {
        return chunk.getWidth() == this._iWidth && chunk.getHeight() == this._iHeight && this._bldr.addSectorIfPartOfFrame(chunk, chunk.getChunkNumber(), chunk.getChunksInFrame(), chunk.getSectorNumber(), chunk.getHeaderFrameNumber());
    }

    @Override
    public boolean isFrameComplete() {
        return this._bldr.isFrameComplete();
    }

    @Nonnull
    protected final List<IVideoSectorWithFrameNumber> getNonNullChunks(@Nonnull ILocalizedLogger log) {
        return this._bldr.getNonNullChunks(log);
    }

    @Override
    @Nonnull
    public DemuxedFrameWithNumberAndDims finishFrame(@Nonnull ILocalizedLogger log) {
        List<IVideoSectorWithFrameNumber> sectors = this.getNonNullChunks(log);
        ArrayList<VideoSectorReplaceableDemuxPiece> wrappedSectors = new ArrayList<VideoSectorReplaceableDemuxPiece>(sectors.size());
        for (IVideoSectorWithFrameNumber vidSector : sectors) {
            wrappedSectors.add(new VideoSectorReplaceableDemuxPiece(vidSector));
        }
        return new DemuxedFrameWithNumberAndDims(this._iWidth, this._iHeight, this._bldr.getHeaderFrameNumber(), wrappedSectors);
    }

    private static class VideoSectorReplaceableDemuxPiece
    implements DemuxedData.Piece,
    SectorBasedFrameReplace.IReplaceableVideoSector {
        @Nonnull
        private final IVideoSectorWithFrameNumber _vidSector;

        public VideoSectorReplaceableDemuxPiece(@Nonnull IVideoSectorWithFrameNumber vidSector) {
            this._vidSector = vidSector;
        }

        @Override
        public int getDemuxPieceSize() {
            return this._vidSector.getDemuxPieceSize();
        }

        @Override
        public byte getDemuxPieceByte(int i) {
            return this._vidSector.getDemuxPieceByte(i);
        }

        @Override
        public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
            this._vidSector.copyDemuxPieceData(abOut, iOutPos);
        }

        @Override
        public int getSectorNumber() {
            return this._vidSector.getSectorNumber();
        }

        @Override
        public int getVideoSectorHeaderSize() {
            return this._vidSector.getVideoSectorHeaderSize();
        }

        @Override
        public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) throws LocalizedIncompatibleException {
            this._vidSector.replaceVideoSectorHeader(existingFrame, newFrame, abCurrentVidSectorHeader);
        }

        @Override
        @Nonnull
        public CdSector getCdSector() {
            return this._vidSector.getCdSector();
        }

        public String toString() {
            return "VideoSectorReplaceableDemuxPiece[" + this._vidSector + "]";
        }
    }
}

