/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.aconcagua.SectorAconcaguaVideo;
import jpsxdec.modules.granturismo.SectorGTVideo;
import jpsxdec.modules.square.SectorChronoXVideoNull;
import jpsxdec.modules.square.SectorFF8;
import jpsxdec.modules.square.SectorFF9;
import jpsxdec.modules.strvideo.GenericStrVideoSector;
import jpsxdec.modules.strvideo.SectorAliceNullVideo;
import jpsxdec.modules.strvideo.SectorAliceVideo;
import jpsxdec.modules.strvideo.SectorStarbladeAlphaGalaxian3;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;

public class VideoSectorIdentifier {
    @CheckForNull
    public static ISelfDemuxingVideoSector idAndClaim(@Nonnull SectorClaimSystem.ClaimableSector cs) {
        CdSector cdSector = cs.getSector();
        ISelfDemuxingVideoSector vid = VideoSectorIdentifier.isVideo(new SectorFF8.SectorFF8Video(cdSector), cs);
        if (vid != null) {
            return vid;
        }
        vid = VideoSectorIdentifier.isVideo(new SectorFF9.SectorFF9Video(cdSector), cs);
        if (vid != null) {
            return vid;
        }
        vid = VideoSectorIdentifier.isVideo(new SectorGTVideo(cdSector), cs);
        if (vid != null) {
            return vid;
        }
        vid = VideoSectorIdentifier.isVideo(new SectorAconcaguaVideo(cdSector), cs);
        if (vid != null) {
            return vid;
        }
        vid = VideoSectorIdentifier.isVideo(new SectorStarbladeAlphaGalaxian3(cdSector), cs);
        if (vid != null) {
            return vid;
        }
        if (VideoSectorIdentifier.isMatch(new SectorChronoXVideoNull(cdSector), cs)) {
            return null;
        }
        vid = VideoSectorIdentifier.isVideo(new GenericStrVideoSector(cdSector), cs);
        if (vid != null) {
            return vid;
        }
        SectorAliceNullVideo an = new SectorAliceNullVideo(cdSector);
        if (an.getProbability() > 0) {
            vid = VideoSectorIdentifier.isVideo(new SectorAliceVideo(cdSector), cs);
            if (vid != null) {
                return vid;
            }
            cs.claim(an);
            return null;
        }
        return null;
    }

    @CheckForNull
    private static ISelfDemuxingVideoSector isVideo(@Nonnull ISelfDemuxingVideoSector videoSector, @Nonnull SectorClaimSystem.ClaimableSector cs) {
        if (videoSector.getProbability() > 0) {
            cs.claim(videoSector);
            return videoSector;
        }
        return null;
    }

    private static boolean isMatch(@Nonnull IIdentifiedSector otherSector, @Nonnull SectorClaimSystem.ClaimableSector cs) {
        if (otherSector.getProbability() > 0) {
            cs.claim(otherSector);
            return true;
        }
        return false;
    }
}

