/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;

public class VideoSectorCommon16byteHeader {
    public final long lngMagic;
    public final int iChunkNumber;
    public final int iChunksInThisFrame;
    public final int iFrameNumber;
    public final int iUsedDemuxedSize;

    public VideoSectorCommon16byteHeader(@Nonnull CdSector cdSector) {
        this.lngMagic = cdSector.readUInt32LE(0);
        this.iChunkNumber = cdSector.readSInt16LE(4);
        this.iChunksInThisFrame = cdSector.readSInt16LE(6);
        this.iFrameNumber = cdSector.readSInt32LE(8);
        this.iUsedDemuxedSize = cdSector.readSInt32LE(12);
    }

    public boolean hasStandardChunkNumber() {
        return this.iChunkNumber >= 0;
    }

    public boolean hasStandardChunksInFrame() {
        return this.iChunksInThisFrame >= 1;
    }

    public boolean hasStandardFrameNumber() {
        return this.iFrameNumber >= 0;
    }

    public boolean hasStandardUsedDemuxSize() {
        return this.iUsedDemuxedSize >= 1;
    }
}

