/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import argparser.BooleanHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.TabularFeedback;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.modules.video.AudioStreamsCombiner;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.save.VideoSaver;
import jpsxdec.modules.video.save.VideoSaverBuilder;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoSaverBuilderGui;
import jpsxdec.util.ArgParser;
import jpsxdec.util.TaskCanceledException;

public class SectorBasedVideoSaverBuilder
extends VideoSaverBuilder {
    @Nonnull
    private final DiscItemSectorBasedVideoStream _sourceVidItem;
    @Nonnull
    private final List<DiscItemAudioStream> _parallelAudio;
    @Nonnull
    private final boolean[] _ablnParallelAudio;
    private boolean _blnEmulatePsxAVSync = false;

    public SectorBasedVideoSaverBuilder(@Nonnull DiscItemSectorBasedVideoStream vidItem) {
        super(vidItem);
        this._sourceVidItem = vidItem;
        if (vidItem.hasAudio()) {
            this._parallelAudio = vidItem.getParallelAudioStreams();
            this._ablnParallelAudio = new boolean[vidItem.getChildCount()];
        } else {
            this._parallelAudio = new ArrayList<DiscItemAudioStream>(0);
            this._ablnParallelAudio = new boolean[0];
        }
        if (this._sourceVidItem.hasAudio()) {
            List<DiscItemAudioStream> defaultAud = this._sourceVidItem.getLongestNonIntersectingAudioStreams();
            for (int i = 0; i < this._ablnParallelAudio.length; ++i) {
                this._ablnParallelAudio[i] = defaultAud.contains(this._parallelAudio.get(i));
            }
        }
    }

    @Override
    public boolean copySettingsTo(@Nonnull DiscItemSaverBuilder otherBuilder) {
        if (super.copySettingsTo(otherBuilder)) {
            if (otherBuilder instanceof SectorBasedVideoSaverBuilder) {
                SectorBasedVideoSaverBuilder other = (SectorBasedVideoSaverBuilder)otherBuilder;
                if (this.getEmulatePsxAVSync_enabled()) {
                    other.setEmulatePsxAVSync(this.getEmulatePsxAvSync());
                }
                if (this.hasAudio() && !this.getSavingAudio()) {
                    other.setParallelAudioNone();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public DiscItemSaverBuilderGui getOptionPane() {
        return new SectorBasedVideoSaverBuilderGui(this);
    }

    @Override
    public boolean getAudioVolume_enabled() {
        return this.getSavingAudio();
    }

    public int getParallelAudioCount() {
        return this._sourceVidItem.getChildCount();
    }

    @Nonnull
    public DiscItemAudioStream getParallelAudio(int i) {
        return this._parallelAudio.get(i);
    }

    public boolean getParallelAudio_selected(int i) {
        if (this.getParallelAudio_enabled()) {
            return this._ablnParallelAudio[i];
        }
        return false;
    }

    public void setParallelAudio(@Nonnull DiscItemAudioStream parallelAudio, boolean blnSelected) {
        if (!this._sourceVidItem.hasAudio()) {
            return;
        }
        this.setParallelAudio(this._parallelAudio.indexOf(parallelAudio), blnSelected);
    }

    public void setParallelAudio(int iIndex, boolean blnSelected) {
        if (!this._sourceVidItem.hasAudio()) {
            return;
        }
        if (iIndex < 0 || iIndex >= this._sourceVidItem.getChildCount()) {
            return;
        }
        DiscItemAudioStream aud = this._parallelAudio.get(iIndex);
        for (int i = 0; i < this._ablnParallelAudio.length; ++i) {
            DiscItemAudioStream other;
            if (!this._ablnParallelAudio[i] || !aud.overlaps(other = this._parallelAudio.get(i)) && aud.hasSameFormat(other)) continue;
            this._ablnParallelAudio[i] = false;
        }
        this._ablnParallelAudio[iIndex] = blnSelected;
        this.firePossibleChange();
    }

    public void setParallelAudioNone() {
        for (int i = 0; i < this.getParallelAudioCount(); ++i) {
            this.setParallelAudio(i, false);
        }
    }

    public boolean getParallelAudio_enabled() {
        return this.getVideoFormat().isAvi() && this.getSaveStartFrame() == null;
    }

    @Override
    public boolean hasAudio() {
        return this._sourceVidItem.hasAudio();
    }

    @Override
    public boolean getSavingAudio() {
        if (!this.getParallelAudio_enabled()) {
            return false;
        }
        for (boolean b : this._ablnParallelAudio) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getEmulatePsxAvSync() {
        if (this.getEmulatePsxAVSync_enabled()) {
            return this._blnEmulatePsxAVSync;
        }
        return false;
    }

    public void setEmulatePsxAVSync(boolean val) {
        this._blnEmulatePsxAVSync = val;
        this.firePossibleChange();
    }

    public boolean getEmulatePsxAVSync_enabled() {
        return this.getSavingAudio();
    }

    @Override
    public void commandLineOptions(@Nonnull ArgParser ap, @Nonnull FeedbackStream fbs) {
        super.commandLineOptions(ap, fbs);
        if (!ap.hasRemaining()) {
            return;
        }
        BooleanHolder noaud = ap.addBoolOption(false, "-noaud");
        BooleanHolder emulateav = ap.addBoolOption(false, "-psxav");
        ap.match();
        this.setEmulatePsxAVSync(emulateav.value);
        if (noaud.value) {
            this.setParallelAudioNone();
        }
    }

    @Override
    protected void makeHelpTable(@Nonnull TabularFeedback tfb) {
        super.makeHelpTable(tfb);
        if (this._sourceVidItem.hasAudio()) {
            tfb.newRow();
            tfb.addCell(I.CMD_VIDEO_NOAUD()).addCell(I.CMD_VIDEO_NOAUD_HELP());
        }
        if (this._sourceVidItem.hasAudio()) {
            tfb.newRow();
            tfb.addCell(I.CMD_VIDEO_PSXAV()).addCell(I.CMD_VIDEO_PSXAV_HELP());
        }
    }

    @Override
    protected void printSelectedAudioOptions(@Nonnull ILocalizedLogger log) {
        for (DiscItemAudioStream discItemAudioStream : this.collectSelectedAudio()) {
            log.log(Level.INFO, discItemAudioStream.getDetails());
        }
    }

    @Nonnull
    private ArrayList<DiscItemAudioStream> collectSelectedAudio() {
        ArrayList<DiscItemAudioStream> parallelAudio = new ArrayList<DiscItemAudioStream>();
        if (this.getSavingAudio()) {
            for (int i = 0; i < this._ablnParallelAudio.length; ++i) {
                if (!this._ablnParallelAudio[i]) continue;
                parallelAudio.add(this._parallelAudio.get(i));
            }
        }
        return parallelAudio;
    }

    @Override
    public void startSave(@Nonnull ProgressLogger pl, @CheckForNull File directory) throws LoggedFailure, TaskCanceledException {
        this.clearGeneratedFiles();
        this.printSelectedOptions(pl);
        ISectorClaimToDemuxedFrame demuxer = this._sourceVidItem.makeDemuxer();
        ArrayList<DiscItemAudioStream> parallelAudio = this.collectSelectedAudio();
        ISectorAudioDecoder audDecoder = parallelAudio.isEmpty() ? null : (parallelAudio.size() == 1 ? parallelAudio.get(0).makeDecoder(this.getAudioVolume()) : new AudioStreamsCombiner(parallelAudio, this.getAudioVolume()));
        VideoSaver vs = new VideoSaver(this._sourceVidItem, this, this.thisGeneratedFileListener, directory, pl, demuxer, audDecoder);
        vs.save(pl);
    }
}

