/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfo;
import jpsxdec.modules.video.sectorbased.fps.StrFrameRateCalc;
import jpsxdec.util.Fraction;

public class SectorBasedVideoInfoBuilder {
    private static final Logger LOG = Logger.getLogger(SectorBasedVideoInfoBuilder.class.getName());
    private final int _iWidth;
    private final int _iHeight;
    private final int _iStartSector;
    private int _iEndSector;
    @Nonnull
    private final StrFrameRateCalc _fpsCalc;
    private final int _iFrame1PresentationSector;
    private int _iFrameCount;

    public SectorBasedVideoInfoBuilder(int iWidth, int iHeight, int iStartSector, int iEndSector) {
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        this._iStartSector = iStartSector;
        this._iEndSector = iEndSector;
        this._iFrame1PresentationSector = iEndSector - this._iStartSector;
        this._fpsCalc = new StrFrameRateCalc(iStartSector - this._iStartSector, iEndSector - this._iStartSector);
        this._iFrameCount = 1;
    }

    public void next(@Nonnull int iStartSector, int iEndSector) {
        if (iStartSector < this._iStartSector || iEndSector < this._iEndSector) {
            throw new IllegalArgumentException("Adding frame with strange sector range");
        }
        this._iEndSector = iEndSector;
        this._fpsCalc.addFrame(iStartSector - this._iStartSector, iEndSector - this._iStartSector);
        ++this._iFrameCount;
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public int getStartSector() {
        return this._iStartSector;
    }

    public int getEndSector() {
        return this._iEndSector;
    }

    public int getSectorLength() {
        return this._iEndSector - this._iStartSector + 1;
    }

    public int getFrame1PresentationSector() {
        return this._iFrame1PresentationSector;
    }

    @Nonnull
    private Fraction getSectorsPerFrame() {
        Fraction sectorsPerFrame = this._fpsCalc.getSectorsPerFrame();
        if (sectorsPerFrame == null) {
            sectorsPerFrame = new Fraction(this.getSectorLength(), this._iFrameCount);
        }
        return sectorsPerFrame;
    }

    @Nonnull
    public SectorBasedVideoInfo makeStrVidInfo() {
        return new SectorBasedVideoInfo(this.getSectorsPerFrame(), this._iFrame1PresentationSector);
    }

    public Dimensions makeDims() {
        return new Dimensions(this._iWidth, this._iHeight);
    }
}

