/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import javax.annotation.Nonnull;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.util.Fraction;

public class SectorBasedVideoInfo {
    private static final String SECTORSPERFRAME_KEY = "Sectors/Frame";
    @Nonnull
    private final Fraction _sectorsPerFrame;
    private static final String FRAME1_LAST_SECTOR_KEY = "1st frame end sector";
    private final int _iFirstFrameLastSector;

    public SectorBasedVideoInfo(@Nonnull Fraction sectorsPerFrame, int iFirstFrameLastSector) {
        this._sectorsPerFrame = sectorsPerFrame;
        this._iFirstFrameLastSector = iFirstFrameLastSector;
    }

    public SectorBasedVideoInfo(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        long[] alng = fields.getFraction(SECTORSPERFRAME_KEY);
        this._sectorsPerFrame = new Fraction(alng[0], alng[1]);
        this._iFirstFrameLastSector = fields.getInt(FRAME1_LAST_SECTOR_KEY);
    }

    public void serialize(@Nonnull SerializedDiscItem serial) {
        serial.addFraction(SECTORSPERFRAME_KEY, this._sectorsPerFrame.getNumerator(), this._sectorsPerFrame.getDenominator());
        serial.addNumber(FRAME1_LAST_SECTOR_KEY, this._iFirstFrameLastSector);
    }

    @Nonnull
    public Fraction getSectorsPerFrame() {
        return this._sectorsPerFrame;
    }

    public int getFirstFrameLastSector() {
        return this._iFirstFrameLastSector;
    }
}

