/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.util.logging.Level;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.DiscPatcher;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.DemuxedData;

public class SectorBasedFrameReplace {
    public static void writeToSectors(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull CdFileSectorReader cd, @Nonnull ILocalizedLogger log, @Nonnull Iterable<? extends IReplaceableVideoSector> chunks) throws LoggedFailure {
        int iDemuxOfs = 0;
        for (IReplaceableVideoSector iReplaceableVideoSector : chunks) {
            if (iReplaceableVideoSector == null) {
                log.log(Level.WARNING, I.CMD_FRAME_TO_REPLACE_MISSING_CHUNKS());
                continue;
            }
            byte[] abSectUserData = iReplaceableVideoSector.getCdSector().getCdUserDataCopy();
            try {
                iReplaceableVideoSector.replaceVideoSectorHeader(existingFrame, newFrame, abSectUserData);
            }
            catch (LocalizedIncompatibleException ex) {
                throw new LoggedFailure(log, Level.SEVERE, ex.getSourceMessage(), ex);
            }
            int iBytesToCopy = iReplaceableVideoSector.getDemuxPieceSize();
            if (iDemuxOfs + iBytesToCopy > newFrame.getBitStreamArrayLength()) {
                iBytesToCopy = newFrame.getBitStreamArrayLength() - iDemuxOfs;
            }
            int iSectorHeaderSize = iReplaceableVideoSector.getVideoSectorHeaderSize();
            newFrame.arrayCopy(iDemuxOfs, abSectUserData, iSectorHeaderSize, iBytesToCopy);
            try {
                cd.addPatch(iReplaceableVideoSector.getCdSector().getSectorIndexFromStart(), 0, abSectUserData);
            }
            catch (DiscPatcher.WritePatchException ex) {
                throw new LoggedFailure(log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(ex.getFile().toString()), ex);
            }
            iDemuxOfs += iBytesToCopy;
        }
    }

    public static interface IReplaceableVideoSector
    extends DemuxedData.Piece {
        public int getVideoSectorHeaderSize();

        public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis var1, @Nonnull BitStreamAnalysis var2, @Nonnull byte[] var3) throws LocalizedIncompatibleException;

        @Nonnull
        public CdSector getCdSector();
    }
}

