/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.util.ArrayList;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.log.ILocalizedLogger;

public class SectorBasedFrameBuilder<T> {
    @Nonnull
    private final T[] _aoChunks;
    private int _iLastChunkReceived;
    private final int _iFrameStartSector;
    private int _iFrameEndSector;
    private final int _iHeaderFrameNumber;

    public SectorBasedFrameBuilder(@Nonnull T firstChunk, int iChunkNumber, int iExpectedChunks, int iSector, int iHeaderFrameNumber, @Nonnull ILocalizedLogger log) {
        if (iChunkNumber < iExpectedChunks) {
            this._aoChunks = new Object[iExpectedChunks];
        } else {
            log.log(Level.WARNING, I.FRAME_NUM_CORRUPTED(String.valueOf(iHeaderFrameNumber)));
            this._aoChunks = new Object[iChunkNumber + 1];
        }
        this._aoChunks[iChunkNumber] = firstChunk;
        this._iLastChunkReceived = iChunkNumber;
        this._iFrameStartSector = this._iFrameEndSector = iSector;
        this._iHeaderFrameNumber = iHeaderFrameNumber;
    }

    public int getHeaderFrameNumber() {
        return this._iHeaderFrameNumber;
    }

    public boolean addSectorIfPartOfFrame(@Nonnull T chunk, int iChunkNumber, int iExpectedCount, int iSectorNumber, int iHeaderFrameNumber) {
        boolean blnIsPartOfFrame;
        if (iSectorNumber < this._iFrameStartSector) {
            throw new IllegalArgumentException("Receiving sectors out of order?");
        }
        boolean bl = blnIsPartOfFrame = iHeaderFrameNumber == this._iHeaderFrameNumber && iChunkNumber > this._iLastChunkReceived && iChunkNumber < this._aoChunks.length && iExpectedCount == this._aoChunks.length && this._aoChunks[iChunkNumber] == null && iSectorNumber < this._iFrameEndSector + 50;
        if (!blnIsPartOfFrame) {
            return false;
        }
        this._iFrameEndSector = iSectorNumber;
        this._iLastChunkReceived = iChunkNumber;
        this._aoChunks[iChunkNumber] = chunk;
        return true;
    }

    public boolean isFrameComplete() {
        return this._iLastChunkReceived >= this._aoChunks.length - 1;
    }

    @Nonnull
    public ArrayList<T> getNonNullChunks(@Nonnull ILocalizedLogger log) {
        ArrayList<T> nonNullChunks = new ArrayList<T>();
        for (int iChunk = 0; iChunk < this._aoChunks.length; ++iChunk) {
            T chunk = this._aoChunks[iChunk];
            if (chunk == null) {
                log.log(Level.WARNING, I.MISSING_CHUNK_FRAME_IN_SECTORS(this._iFrameStartSector, this._iFrameEndSector, iChunk));
                continue;
            }
            nonNullChunks.add(chunk);
        }
        return nonNullChunks;
    }

    public String toString() {
        return String.format("Sectors %d-%d %d/%d chunks", this._iFrameStartSector, this._iFrameEndSector, this._iLastChunkReceived, this._aoChunks.length);
    }
}

