/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.io.PrintStream;
import javax.annotation.Nonnull;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.BinaryDataNotRecognized;

public class SectorBasedFrameAnalysis
extends BitStreamAnalysis {
    @Nonnull
    private final IDemuxedFrame _frame;

    @Nonnull
    public static SectorBasedFrameAnalysis create(@Nonnull IDemuxedFrame frame) throws BinaryDataNotRecognized, MdecException.ReadCorruption, MdecException.EndOfStream, IllegalArgumentException {
        MdecInputStream mis = frame.getCustomFrameMdecStream();
        if (mis != null) {
            throw new IllegalArgumentException();
        }
        byte[] abBitStream = frame.copyDemuxData();
        assert (abBitStream.length == frame.getDemuxSize());
        return new SectorBasedFrameAnalysis(abBitStream, frame);
    }

    protected SectorBasedFrameAnalysis(@Nonnull byte[] abBitstream, @Nonnull IDemuxedFrame frame) throws BinaryDataNotRecognized, MdecException.ReadCorruption, MdecException.EndOfStream {
        super(abBitstream, frame.getWidth(), frame.getHeight());
        this._frame = frame;
    }

    @Override
    public void printInfo(@Nonnull PrintStream ps) {
        ps.println(this._frame);
        ps.println("Available demux size: " + this._frame.getDemuxSize());
        this._frame.printSectors(ps);
        super.printInfo(ps);
    }
}

