/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.video.sectorbased.IVideoSectorWithFrameNumber;
import jpsxdec.modules.video.sectorbased.VideoSectorWithFrameNumberDemuxer;
import jpsxdec.util.DemuxedData;

public abstract class SectorAbstractVideo
extends IdentifiedSector
implements IVideoSectorWithFrameNumber,
DemuxedData.Piece {
    public SectorAbstractVideo(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        this.setProbability(1);
    }

    @Override
    public abstract String toString();

    @Override
    public abstract int getVideoSectorHeaderSize();

    @Override
    @Nonnull
    public final VideoSectorWithFrameNumberDemuxer createDemuxer(@Nonnull ILocalizedLogger log) {
        return new VideoSectorWithFrameNumberDemuxer(this, log);
    }

    @Override
    public final int getDemuxPieceSize() {
        return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
    }

    @Override
    public final byte getDemuxPieceByte(int i) {
        return this.getCdSector().readUserDataByte(this.getVideoSectorHeaderSize() + i);
    }

    @Override
    public final void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
    }
}

